/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.posix;

import java.util.Locale;
import org.python.core.PySystemState;

enum OS {
    NT("Windows", (String[][])new String[][]{{OS.getenv("ComSpec", "C:\\WINDOWS\\System32\\cmd.exe"), "/c"}, {"command.com", "/c"}}),
    IBMi("OS/400", (String[][])new String[][]{{"/QOpenSys/usr/bin/sh", "-c"}}),
    POSIX(new String[][]{{"/bin/sh", "-c"}});

    private final String[][] shellCommands;
    private final String pattern;

    private OS(String pattern, String[] ... shellCommands) {
        this.shellCommands = shellCommands;
        this.pattern = pattern != null ? pattern : this.name();
    }

    private OS(String[] ... shellCommands) {
        this((String)null, shellCommands);
    }

    String getModuleName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    String[][] getShellCommands() {
        return this.shellCommands;
    }

    static OS getOS() {
        String osName = PySystemState.registry.getProperty("python.os");
        if (osName == null) {
            osName = System.getProperty("os.name");
        }
        for (OS os2 : OS.values()) {
            if (!osName.startsWith(os2.pattern)) continue;
            return os2;
        }
        return POSIX;
    }

    private static String getenv(String name, String defaultValue) {
        try {
            String value = System.getenv(name);
            return value != null && value.length() > 0 ? value : defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }
}

