/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Roaring64Map;
import org.roaringbitmap.Util;

public class BitmapValue {
    public static final int EMPTY = 0;
    public static final int SINGLE32 = 1;
    public static final int BITMAP32 = 2;
    public static final int SINGLE64 = 3;
    public static final int BITMAP64 = 4;
    public static final int SINGLE_VALUE = 1;
    public static final int BITMAP_VALUE = 2;
    public static final long UNSIGNED_32BIT_INT_MAX_VALUE = 0xFFFFFFFFL;
    private int bitmapType = 0;
    private long singleValue;
    private Roaring64Map bitmap;

    public void add(int value) {
        this.add(Util.toUnsignedLong((int)value));
    }

    public void add(long value) {
        switch (this.bitmapType) {
            case 0: {
                this.singleValue = value;
                this.bitmapType = 1;
                break;
            }
            case 1: {
                if (this.singleValue == value) break;
                this.bitmap = new Roaring64Map();
                this.bitmap.add(value);
                this.bitmap.add(this.singleValue);
                this.bitmapType = 2;
                break;
            }
            case 2: {
                this.bitmap.addLong(value);
            }
        }
    }

    public boolean contains(int value) {
        return this.contains(Util.toUnsignedLong((int)value));
    }

    public boolean contains(long value) {
        switch (this.bitmapType) {
            case 0: {
                return false;
            }
            case 1: {
                return this.singleValue == value;
            }
            case 2: {
                return this.bitmap.contains(value);
            }
        }
        return false;
    }

    public long cardinality() {
        switch (this.bitmapType) {
            case 0: {
                return 0L;
            }
            case 1: {
                return 1L;
            }
            case 2: {
                return this.bitmap.getLongCardinality();
            }
        }
        return 0L;
    }

    public void serialize(DataOutput output) throws IOException {
        switch (this.bitmapType) {
            case 0: {
                output.writeByte(0);
                break;
            }
            case 1: {
                if (this.isLongValue32bitEnough(this.singleValue)) {
                    output.write(1);
                    output.writeInt(Integer.reverseBytes((int)this.singleValue));
                    break;
                }
                output.writeByte(3);
                output.writeLong(Long.reverseBytes(this.singleValue));
                break;
            }
            case 2: {
                this.bitmap.serialize(output);
            }
        }
    }

    public void deserialize(DataInput input) throws IOException {
        this.clear();
        byte bitmapType = input.readByte();
        switch (bitmapType) {
            case 0: {
                break;
            }
            case 1: {
                this.singleValue = Util.toUnsignedLong((int)Integer.reverseBytes(input.readInt()));
                this.bitmapType = 1;
                break;
            }
            case 3: {
                this.singleValue = Long.reverseBytes(input.readLong());
                this.bitmapType = 1;
                break;
            }
            case 2: 
            case 4: {
                this.bitmap = this.bitmap == null ? new Roaring64Map() : this.bitmap;
                this.bitmap.deserialize(input, bitmapType);
                this.bitmapType = 2;
                break;
            }
            default: {
                throw new RuntimeException(String.format("unknown bitmap type %s ", bitmapType));
            }
        }
    }

    public void and(BitmapValue other) {
        block17: {
            block0 : switch (other.bitmapType) {
                case 0: {
                    this.clear();
                    break;
                }
                case 1: {
                    switch (this.bitmapType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (this.singleValue == other.singleValue) break;
                            this.clear();
                            break;
                        }
                        case 2: {
                            if (!this.bitmap.contains(other.singleValue)) {
                                this.clear();
                                break;
                            }
                            this.clear();
                            this.singleValue = other.singleValue;
                            this.bitmapType = 1;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.bitmapType) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (!other.bitmap.contains(this.singleValue)) {
                                this.clear();
                                break block0;
                            }
                            break block17;
                        }
                        case 2: {
                            this.bitmap.and(other.bitmap);
                            this.convertToSmallerType();
                        }
                    }
                }
            }
        }
    }

    public void or(BitmapValue other) {
        block0 : switch (other.bitmapType) {
            case 0: {
                break;
            }
            case 1: {
                this.add(other.singleValue);
                break;
            }
            case 2: {
                switch (this.bitmapType) {
                    case 0: {
                        this.bitmap = new Roaring64Map();
                        this.bitmap.or(other.bitmap);
                        this.bitmapType = 2;
                        break block0;
                    }
                    case 1: {
                        this.bitmap = new Roaring64Map();
                        this.bitmap.or(other.bitmap);
                        this.bitmap.add(this.singleValue);
                        this.bitmapType = 2;
                        break block0;
                    }
                    case 2: {
                        this.bitmap.or(other.bitmap);
                    }
                }
            }
        }
    }

    public void remove(long value) {
        switch (this.bitmapType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.singleValue != value) break;
                this.clear();
                break;
            }
            case 2: {
                this.bitmap.removeLong(value);
                this.convertToSmallerType();
            }
        }
    }

    public void not(BitmapValue other) {
        block11: {
            block0 : switch (other.bitmapType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.remove(other.singleValue);
                    break;
                }
                case 2: {
                    switch (this.bitmapType) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (other.bitmap.contains(this.singleValue)) {
                                this.clear();
                                break block0;
                            }
                            break block11;
                        }
                        case 2: {
                            this.bitmap.andNot(other.bitmap);
                            this.convertToSmallerType();
                        }
                    }
                }
            }
        }
    }

    public void xor(BitmapValue other) {
        block0 : switch (other.bitmapType) {
            case 0: {
                break;
            }
            case 1: {
                switch (this.bitmapType) {
                    case 0: {
                        this.add(other.singleValue);
                        break;
                    }
                    case 1: {
                        if (this.singleValue != other.singleValue) {
                            this.add(other.singleValue);
                            break;
                        }
                        this.clear();
                        break;
                    }
                    case 2: {
                        if (!this.bitmap.contains(other.singleValue)) {
                            this.bitmap.add(other.singleValue);
                            break;
                        }
                        this.bitmap.removeLong(other.singleValue);
                        this.convertToSmallerType();
                    }
                }
                break;
            }
            case 2: {
                switch (this.bitmapType) {
                    case 0: {
                        this.bitmap = other.bitmap;
                        this.bitmapType = 2;
                        break block0;
                    }
                    case 1: {
                        this.bitmap = other.bitmap;
                        this.bitmapType = 2;
                        if (this.bitmap.contains(this.singleValue)) {
                            this.bitmap.removeLong(this.singleValue);
                            break block0;
                        }
                        this.bitmap.add(this.bitmapType);
                        break block0;
                    }
                    case 2: {
                        this.bitmap.xor(other.bitmap);
                        this.convertToSmallerType();
                    }
                }
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BitmapValue)) {
            return false;
        }
        boolean ret = false;
        if (this.bitmapType != ((BitmapValue)other).bitmapType) {
            return false;
        }
        switch (((BitmapValue)other).bitmapType) {
            case 0: {
                ret = true;
                break;
            }
            case 1: {
                ret = this.singleValue == ((BitmapValue)other).singleValue;
                break;
            }
            case 2: {
                ret = this.bitmap.equals(((BitmapValue)other).bitmap);
            }
        }
        return ret;
    }

    public long getSizeInBytes() {
        long size = 0L;
        switch (this.bitmapType) {
            case 0: {
                size = 1L;
                break;
            }
            case 1: {
                if (this.isLongValue32bitEnough(this.singleValue)) {
                    size = 5L;
                    break;
                }
                size = 9L;
                break;
            }
            case 2: {
                size = 1 + this.bitmap.getSizeInBytes();
            }
        }
        return size;
    }

    public String toString() {
        String toStringStr = "{}";
        switch (this.bitmapType) {
            case 0: {
                break;
            }
            case 1: {
                toStringStr = String.format("{%s}", this.singleValue);
                break;
            }
            case 2: {
                toStringStr = this.bitmap.toString();
            }
        }
        return toStringStr;
    }

    public void clear() {
        this.bitmapType = 0;
        this.singleValue = -1L;
        this.bitmap = null;
    }

    private void convertToSmallerType() {
        if (this.bitmapType == 2) {
            if (this.bitmap.getLongCardinality() == 0L) {
                this.bitmap = null;
                this.bitmapType = 0;
            } else if (this.bitmap.getLongCardinality() == 1L) {
                this.singleValue = this.bitmap.select(0L);
                this.bitmapType = 1;
                this.bitmap = null;
            }
        }
    }

    private boolean isLongValue32bitEnough(long value) {
        return value <= 0xFFFFFFFFL;
    }

    public int getBitmapType() {
        return this.bitmapType;
    }

    public boolean is32BitsEnough() {
        switch (this.bitmapType) {
            case 0: {
                return true;
            }
            case 1: {
                return this.isLongValue32bitEnough(this.singleValue);
            }
            case 2: {
                return this.bitmap.is32BitsEnough();
            }
        }
        return false;
    }
}

