/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Codec {
    public static void encodeVarint64(long source, DataOutput out) throws IOException {
        assert (source >= 0L);
        int B = 128;
        while (source >= (long)B) {
            out.write((int)(source & (long)(B - 1) | (long)B));
            source >>= 7;
        }
        out.write((int)(source & (long)(B - 1)));
    }

    public static long decodeVarint64(DataInput in) throws IOException {
        long result = 0L;
        int shift = 0;
        int B = 128;
        while (true) {
            int oneByte;
            boolean isEnd = ((oneByte = in.readUnsignedByte()) & B) == 0;
            result |= (long)(oneByte & B - 1) << shift * 7;
            if (isEnd) break;
            ++shift;
        }
        return result;
    }
}

