/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum TBrokerOperationStatusCode implements TEnum
{
    OK(0),
    END_OF_FILE(301),
    NOT_AUTHORIZED(401),
    DUPLICATE_REQUEST(402),
    INVALID_INPUT_OFFSET(403),
    INVALID_INPUT_FILE_PATH(404),
    INVALID_ARGUMENT(405),
    FILE_NOT_FOUND(501),
    TARGET_STORAGE_SERVICE_ERROR(502),
    OPERATION_NOT_SUPPORTED(503);

    private final int value;

    private TBrokerOperationStatusCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Nullable
    public static TBrokerOperationStatusCode findByValue(int value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 301: {
                return END_OF_FILE;
            }
            case 401: {
                return NOT_AUTHORIZED;
            }
            case 402: {
                return DUPLICATE_REQUEST;
            }
            case 403: {
                return INVALID_INPUT_OFFSET;
            }
            case 404: {
                return INVALID_INPUT_FILE_PATH;
            }
            case 405: {
                return INVALID_ARGUMENT;
            }
            case 501: {
                return FILE_NOT_FOUND;
            }
            case 502: {
                return TARGET_STORAGE_SERVICE_ERROR;
            }
            case 503: {
                return OPERATION_NOT_SUPPORTED;
            }
        }
        return null;
    }
}

