/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TColumn;
import org.apache.doris.thrift.TKeysType;
import org.apache.doris.thrift.TOlapTableIndex;
import org.apache.doris.thrift.TSortType;
import org.apache.doris.thrift.TStorageType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TTabletSchema
implements TBase<TTabletSchema, _Fields>,
Serializable,
Cloneable,
Comparable<TTabletSchema> {
    private static final TStruct STRUCT_DESC = new TStruct("TTabletSchema");
    private static final TField SHORT_KEY_COLUMN_COUNT_FIELD_DESC = new TField("short_key_column_count", 6, 1);
    private static final TField SCHEMA_HASH_FIELD_DESC = new TField("schema_hash", 8, 2);
    private static final TField KEYS_TYPE_FIELD_DESC = new TField("keys_type", 8, 3);
    private static final TField STORAGE_TYPE_FIELD_DESC = new TField("storage_type", 8, 4);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 5);
    private static final TField BLOOM_FILTER_FPP_FIELD_DESC = new TField("bloom_filter_fpp", 4, 6);
    private static final TField INDEXES_FIELD_DESC = new TField("indexes", 15, 7);
    private static final TField IS_IN_MEMORY_FIELD_DESC = new TField("is_in_memory", 2, 8);
    private static final TField DELETE_SIGN_IDX_FIELD_DESC = new TField("delete_sign_idx", 8, 9);
    private static final TField SEQUENCE_COL_IDX_FIELD_DESC = new TField("sequence_col_idx", 8, 10);
    private static final TField SORT_TYPE_FIELD_DESC = new TField("sort_type", 8, 11);
    private static final TField SORT_COL_NUM_FIELD_DESC = new TField("sort_col_num", 8, 12);
    private static final TField DISABLE_AUTO_COMPACTION_FIELD_DESC = new TField("disable_auto_compaction", 2, 13);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TTabletSchemaStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TTabletSchemaTupleSchemeFactory();
    public short short_key_column_count;
    public int schema_hash;
    @Nullable
    public TKeysType keys_type;
    @Nullable
    public TStorageType storage_type;
    @Nullable
    public List<TColumn> columns;
    public double bloom_filter_fpp;
    @Nullable
    public List<TOlapTableIndex> indexes;
    public boolean is_in_memory;
    public int delete_sign_idx;
    public int sequence_col_idx;
    @Nullable
    public TSortType sort_type;
    public int sort_col_num;
    public boolean disable_auto_compaction;
    private static final int __SHORT_KEY_COLUMN_COUNT_ISSET_ID = 0;
    private static final int __SCHEMA_HASH_ISSET_ID = 1;
    private static final int __BLOOM_FILTER_FPP_ISSET_ID = 2;
    private static final int __IS_IN_MEMORY_ISSET_ID = 3;
    private static final int __DELETE_SIGN_IDX_ISSET_ID = 4;
    private static final int __SEQUENCE_COL_IDX_ISSET_ID = 5;
    private static final int __SORT_COL_NUM_ISSET_ID = 6;
    private static final int __DISABLE_AUTO_COMPACTION_ISSET_ID = 7;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.BLOOM_FILTER_FPP, _Fields.INDEXES, _Fields.IS_IN_MEMORY, _Fields.DELETE_SIGN_IDX, _Fields.SEQUENCE_COL_IDX, _Fields.SORT_TYPE, _Fields.SORT_COL_NUM, _Fields.DISABLE_AUTO_COMPACTION};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TTabletSchema() {
        this.delete_sign_idx = -1;
        this.sequence_col_idx = -1;
    }

    public TTabletSchema(short short_key_column_count, int schema_hash, TKeysType keys_type, TStorageType storage_type, List<TColumn> columns) {
        this();
        this.short_key_column_count = short_key_column_count;
        this.setShortKeyColumnCountIsSet(true);
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        this.keys_type = keys_type;
        this.storage_type = storage_type;
        this.columns = columns;
    }

    public TTabletSchema(TTabletSchema other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.short_key_column_count = other.short_key_column_count;
        this.schema_hash = other.schema_hash;
        if (other.isSetKeysType()) {
            this.keys_type = other.keys_type;
        }
        if (other.isSetStorageType()) {
            this.storage_type = other.storage_type;
        }
        if (other.isSetColumns()) {
            ArrayList<TColumn> __this__columns = new ArrayList<TColumn>(other.columns.size());
            for (TColumn tColumn : other.columns) {
                __this__columns.add(new TColumn(tColumn));
            }
            this.columns = __this__columns;
        }
        this.bloom_filter_fpp = other.bloom_filter_fpp;
        if (other.isSetIndexes()) {
            ArrayList<TOlapTableIndex> __this__indexes = new ArrayList<TOlapTableIndex>(other.indexes.size());
            for (TOlapTableIndex tOlapTableIndex : other.indexes) {
                __this__indexes.add(new TOlapTableIndex(tOlapTableIndex));
            }
            this.indexes = __this__indexes;
        }
        this.is_in_memory = other.is_in_memory;
        this.delete_sign_idx = other.delete_sign_idx;
        this.sequence_col_idx = other.sequence_col_idx;
        if (other.isSetSortType()) {
            this.sort_type = other.sort_type;
        }
        this.sort_col_num = other.sort_col_num;
        this.disable_auto_compaction = other.disable_auto_compaction;
    }

    public TTabletSchema deepCopy() {
        return new TTabletSchema(this);
    }

    public void clear() {
        this.setShortKeyColumnCountIsSet(false);
        this.short_key_column_count = 0;
        this.setSchemaHashIsSet(false);
        this.schema_hash = 0;
        this.keys_type = null;
        this.storage_type = null;
        this.columns = null;
        this.setBloomFilterFppIsSet(false);
        this.bloom_filter_fpp = 0.0;
        this.indexes = null;
        this.setIsInMemoryIsSet(false);
        this.is_in_memory = false;
        this.delete_sign_idx = -1;
        this.sequence_col_idx = -1;
        this.sort_type = null;
        this.setSortColNumIsSet(false);
        this.sort_col_num = 0;
        this.setDisableAutoCompactionIsSet(false);
        this.disable_auto_compaction = false;
    }

    public short getShortKeyColumnCount() {
        return this.short_key_column_count;
    }

    public TTabletSchema setShortKeyColumnCount(short short_key_column_count) {
        this.short_key_column_count = short_key_column_count;
        this.setShortKeyColumnCountIsSet(true);
        return this;
    }

    public void unsetShortKeyColumnCount() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetShortKeyColumnCount() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setShortKeyColumnCountIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSchemaHash() {
        return this.schema_hash;
    }

    public TTabletSchema setSchemaHash(int schema_hash) {
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        return this;
    }

    public void unsetSchemaHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSchemaHash() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setSchemaHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    @Nullable
    public TKeysType getKeysType() {
        return this.keys_type;
    }

    public TTabletSchema setKeysType(@Nullable TKeysType keys_type) {
        this.keys_type = keys_type;
        return this;
    }

    public void unsetKeysType() {
        this.keys_type = null;
    }

    public boolean isSetKeysType() {
        return this.keys_type != null;
    }

    public void setKeysTypeIsSet(boolean value) {
        if (!value) {
            this.keys_type = null;
        }
    }

    @Nullable
    public TStorageType getStorageType() {
        return this.storage_type;
    }

    public TTabletSchema setStorageType(@Nullable TStorageType storage_type) {
        this.storage_type = storage_type;
        return this;
    }

    public void unsetStorageType() {
        this.storage_type = null;
    }

    public boolean isSetStorageType() {
        return this.storage_type != null;
    }

    public void setStorageTypeIsSet(boolean value) {
        if (!value) {
            this.storage_type = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Nullable
    public Iterator<TColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(TColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TColumn>();
        }
        this.columns.add(elem);
    }

    @Nullable
    public List<TColumn> getColumns() {
        return this.columns;
    }

    public TTabletSchema setColumns(@Nullable List<TColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public double getBloomFilterFpp() {
        return this.bloom_filter_fpp;
    }

    public TTabletSchema setBloomFilterFpp(double bloom_filter_fpp) {
        this.bloom_filter_fpp = bloom_filter_fpp;
        this.setBloomFilterFppIsSet(true);
        return this;
    }

    public void unsetBloomFilterFpp() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetBloomFilterFpp() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setBloomFilterFppIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getIndexesSize() {
        return this.indexes == null ? 0 : this.indexes.size();
    }

    @Nullable
    public Iterator<TOlapTableIndex> getIndexesIterator() {
        return this.indexes == null ? null : this.indexes.iterator();
    }

    public void addToIndexes(TOlapTableIndex elem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<TOlapTableIndex>();
        }
        this.indexes.add(elem);
    }

    @Nullable
    public List<TOlapTableIndex> getIndexes() {
        return this.indexes;
    }

    public TTabletSchema setIndexes(@Nullable List<TOlapTableIndex> indexes) {
        this.indexes = indexes;
        return this;
    }

    public void unsetIndexes() {
        this.indexes = null;
    }

    public boolean isSetIndexes() {
        return this.indexes != null;
    }

    public void setIndexesIsSet(boolean value) {
        if (!value) {
            this.indexes = null;
        }
    }

    public boolean isIsInMemory() {
        return this.is_in_memory;
    }

    public TTabletSchema setIsInMemory(boolean is_in_memory) {
        this.is_in_memory = is_in_memory;
        this.setIsInMemoryIsSet(true);
        return this;
    }

    public void unsetIsInMemory() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetIsInMemory() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setIsInMemoryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getDeleteSignIdx() {
        return this.delete_sign_idx;
    }

    public TTabletSchema setDeleteSignIdx(int delete_sign_idx) {
        this.delete_sign_idx = delete_sign_idx;
        this.setDeleteSignIdxIsSet(true);
        return this;
    }

    public void unsetDeleteSignIdx() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetDeleteSignIdx() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setDeleteSignIdxIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getSequenceColIdx() {
        return this.sequence_col_idx;
    }

    public TTabletSchema setSequenceColIdx(int sequence_col_idx) {
        this.sequence_col_idx = sequence_col_idx;
        this.setSequenceColIdxIsSet(true);
        return this;
    }

    public void unsetSequenceColIdx() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetSequenceColIdx() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setSequenceColIdxIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    @Nullable
    public TSortType getSortType() {
        return this.sort_type;
    }

    public TTabletSchema setSortType(@Nullable TSortType sort_type) {
        this.sort_type = sort_type;
        return this;
    }

    public void unsetSortType() {
        this.sort_type = null;
    }

    public boolean isSetSortType() {
        return this.sort_type != null;
    }

    public void setSortTypeIsSet(boolean value) {
        if (!value) {
            this.sort_type = null;
        }
    }

    public int getSortColNum() {
        return this.sort_col_num;
    }

    public TTabletSchema setSortColNum(int sort_col_num) {
        this.sort_col_num = sort_col_num;
        this.setSortColNumIsSet(true);
        return this;
    }

    public void unsetSortColNum() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)6);
    }

    public boolean isSetSortColNum() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)6);
    }

    public void setSortColNumIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public boolean isDisableAutoCompaction() {
        return this.disable_auto_compaction;
    }

    public TTabletSchema setDisableAutoCompaction(boolean disable_auto_compaction) {
        this.disable_auto_compaction = disable_auto_compaction;
        this.setDisableAutoCompactionIsSet(true);
        return this;
    }

    public void unsetDisableAutoCompaction() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)7);
    }

    public boolean isSetDisableAutoCompaction() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)7);
    }

    public void setDisableAutoCompactionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case SHORT_KEY_COLUMN_COUNT: {
                if (value == null) {
                    this.unsetShortKeyColumnCount();
                    break;
                }
                this.setShortKeyColumnCount((Short)value);
                break;
            }
            case SCHEMA_HASH: {
                if (value == null) {
                    this.unsetSchemaHash();
                    break;
                }
                this.setSchemaHash((Integer)value);
                break;
            }
            case KEYS_TYPE: {
                if (value == null) {
                    this.unsetKeysType();
                    break;
                }
                this.setKeysType((TKeysType)((Object)value));
                break;
            }
            case STORAGE_TYPE: {
                if (value == null) {
                    this.unsetStorageType();
                    break;
                }
                this.setStorageType((TStorageType)((Object)value));
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case BLOOM_FILTER_FPP: {
                if (value == null) {
                    this.unsetBloomFilterFpp();
                    break;
                }
                this.setBloomFilterFpp((Double)value);
                break;
            }
            case INDEXES: {
                if (value == null) {
                    this.unsetIndexes();
                    break;
                }
                this.setIndexes((List)value);
                break;
            }
            case IS_IN_MEMORY: {
                if (value == null) {
                    this.unsetIsInMemory();
                    break;
                }
                this.setIsInMemory((Boolean)value);
                break;
            }
            case DELETE_SIGN_IDX: {
                if (value == null) {
                    this.unsetDeleteSignIdx();
                    break;
                }
                this.setDeleteSignIdx((Integer)value);
                break;
            }
            case SEQUENCE_COL_IDX: {
                if (value == null) {
                    this.unsetSequenceColIdx();
                    break;
                }
                this.setSequenceColIdx((Integer)value);
                break;
            }
            case SORT_TYPE: {
                if (value == null) {
                    this.unsetSortType();
                    break;
                }
                this.setSortType((TSortType)((Object)value));
                break;
            }
            case SORT_COL_NUM: {
                if (value == null) {
                    this.unsetSortColNum();
                    break;
                }
                this.setSortColNum((Integer)value);
                break;
            }
            case DISABLE_AUTO_COMPACTION: {
                if (value == null) {
                    this.unsetDisableAutoCompaction();
                    break;
                }
                this.setDisableAutoCompaction((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case SHORT_KEY_COLUMN_COUNT: {
                return this.getShortKeyColumnCount();
            }
            case SCHEMA_HASH: {
                return this.getSchemaHash();
            }
            case KEYS_TYPE: {
                return this.getKeysType();
            }
            case STORAGE_TYPE: {
                return this.getStorageType();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case BLOOM_FILTER_FPP: {
                return this.getBloomFilterFpp();
            }
            case INDEXES: {
                return this.getIndexes();
            }
            case IS_IN_MEMORY: {
                return this.isIsInMemory();
            }
            case DELETE_SIGN_IDX: {
                return this.getDeleteSignIdx();
            }
            case SEQUENCE_COL_IDX: {
                return this.getSequenceColIdx();
            }
            case SORT_TYPE: {
                return this.getSortType();
            }
            case SORT_COL_NUM: {
                return this.getSortColNum();
            }
            case DISABLE_AUTO_COMPACTION: {
                return this.isDisableAutoCompaction();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case SHORT_KEY_COLUMN_COUNT: {
                return this.isSetShortKeyColumnCount();
            }
            case SCHEMA_HASH: {
                return this.isSetSchemaHash();
            }
            case KEYS_TYPE: {
                return this.isSetKeysType();
            }
            case STORAGE_TYPE: {
                return this.isSetStorageType();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case BLOOM_FILTER_FPP: {
                return this.isSetBloomFilterFpp();
            }
            case INDEXES: {
                return this.isSetIndexes();
            }
            case IS_IN_MEMORY: {
                return this.isSetIsInMemory();
            }
            case DELETE_SIGN_IDX: {
                return this.isSetDeleteSignIdx();
            }
            case SEQUENCE_COL_IDX: {
                return this.isSetSequenceColIdx();
            }
            case SORT_TYPE: {
                return this.isSetSortType();
            }
            case SORT_COL_NUM: {
                return this.isSetSortColNum();
            }
            case DISABLE_AUTO_COMPACTION: {
                return this.isSetDisableAutoCompaction();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TTabletSchema) {
            return this.equals((TTabletSchema)that);
        }
        return false;
    }

    public boolean equals(TTabletSchema that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_short_key_column_count = true;
        boolean that_present_short_key_column_count = true;
        if (this_present_short_key_column_count || that_present_short_key_column_count) {
            if (!this_present_short_key_column_count || !that_present_short_key_column_count) {
                return false;
            }
            if (this.short_key_column_count != that.short_key_column_count) {
                return false;
            }
        }
        boolean this_present_schema_hash = true;
        boolean that_present_schema_hash = true;
        if (this_present_schema_hash || that_present_schema_hash) {
            if (!this_present_schema_hash || !that_present_schema_hash) {
                return false;
            }
            if (this.schema_hash != that.schema_hash) {
                return false;
            }
        }
        boolean this_present_keys_type = this.isSetKeysType();
        boolean that_present_keys_type = that.isSetKeysType();
        if (this_present_keys_type || that_present_keys_type) {
            if (!this_present_keys_type || !that_present_keys_type) {
                return false;
            }
            if (!this.keys_type.equals((Object)that.keys_type)) {
                return false;
            }
        }
        boolean this_present_storage_type = this.isSetStorageType();
        boolean that_present_storage_type = that.isSetStorageType();
        if (this_present_storage_type || that_present_storage_type) {
            if (!this_present_storage_type || !that_present_storage_type) {
                return false;
            }
            if (!this.storage_type.equals((Object)that.storage_type)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_bloom_filter_fpp = this.isSetBloomFilterFpp();
        boolean that_present_bloom_filter_fpp = that.isSetBloomFilterFpp();
        if (this_present_bloom_filter_fpp || that_present_bloom_filter_fpp) {
            if (!this_present_bloom_filter_fpp || !that_present_bloom_filter_fpp) {
                return false;
            }
            if (this.bloom_filter_fpp != that.bloom_filter_fpp) {
                return false;
            }
        }
        boolean this_present_indexes = this.isSetIndexes();
        boolean that_present_indexes = that.isSetIndexes();
        if (this_present_indexes || that_present_indexes) {
            if (!this_present_indexes || !that_present_indexes) {
                return false;
            }
            if (!this.indexes.equals(that.indexes)) {
                return false;
            }
        }
        boolean this_present_is_in_memory = this.isSetIsInMemory();
        boolean that_present_is_in_memory = that.isSetIsInMemory();
        if (this_present_is_in_memory || that_present_is_in_memory) {
            if (!this_present_is_in_memory || !that_present_is_in_memory) {
                return false;
            }
            if (this.is_in_memory != that.is_in_memory) {
                return false;
            }
        }
        boolean this_present_delete_sign_idx = this.isSetDeleteSignIdx();
        boolean that_present_delete_sign_idx = that.isSetDeleteSignIdx();
        if (this_present_delete_sign_idx || that_present_delete_sign_idx) {
            if (!this_present_delete_sign_idx || !that_present_delete_sign_idx) {
                return false;
            }
            if (this.delete_sign_idx != that.delete_sign_idx) {
                return false;
            }
        }
        boolean this_present_sequence_col_idx = this.isSetSequenceColIdx();
        boolean that_present_sequence_col_idx = that.isSetSequenceColIdx();
        if (this_present_sequence_col_idx || that_present_sequence_col_idx) {
            if (!this_present_sequence_col_idx || !that_present_sequence_col_idx) {
                return false;
            }
            if (this.sequence_col_idx != that.sequence_col_idx) {
                return false;
            }
        }
        boolean this_present_sort_type = this.isSetSortType();
        boolean that_present_sort_type = that.isSetSortType();
        if (this_present_sort_type || that_present_sort_type) {
            if (!this_present_sort_type || !that_present_sort_type) {
                return false;
            }
            if (!this.sort_type.equals((Object)that.sort_type)) {
                return false;
            }
        }
        boolean this_present_sort_col_num = this.isSetSortColNum();
        boolean that_present_sort_col_num = that.isSetSortColNum();
        if (this_present_sort_col_num || that_present_sort_col_num) {
            if (!this_present_sort_col_num || !that_present_sort_col_num) {
                return false;
            }
            if (this.sort_col_num != that.sort_col_num) {
                return false;
            }
        }
        boolean this_present_disable_auto_compaction = this.isSetDisableAutoCompaction();
        boolean that_present_disable_auto_compaction = that.isSetDisableAutoCompaction();
        if (this_present_disable_auto_compaction || that_present_disable_auto_compaction) {
            if (!this_present_disable_auto_compaction || !that_present_disable_auto_compaction) {
                return false;
            }
            if (this.disable_auto_compaction != that.disable_auto_compaction) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.short_key_column_count;
        hashCode = hashCode * 8191 + this.schema_hash;
        hashCode = hashCode * 8191 + (this.isSetKeysType() ? 131071 : 524287);
        if (this.isSetKeysType()) {
            hashCode = hashCode * 8191 + this.keys_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetStorageType() ? 131071 : 524287);
        if (this.isSetStorageType()) {
            hashCode = hashCode * 8191 + this.storage_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetColumns() ? 131071 : 524287);
        if (this.isSetColumns()) {
            hashCode = hashCode * 8191 + this.columns.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBloomFilterFpp() ? 131071 : 524287);
        if (this.isSetBloomFilterFpp()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.bloom_filter_fpp);
        }
        hashCode = hashCode * 8191 + (this.isSetIndexes() ? 131071 : 524287);
        if (this.isSetIndexes()) {
            hashCode = hashCode * 8191 + this.indexes.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsInMemory() ? 131071 : 524287);
        if (this.isSetIsInMemory()) {
            hashCode = hashCode * 8191 + (this.is_in_memory ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetDeleteSignIdx() ? 131071 : 524287);
        if (this.isSetDeleteSignIdx()) {
            hashCode = hashCode * 8191 + this.delete_sign_idx;
        }
        hashCode = hashCode * 8191 + (this.isSetSequenceColIdx() ? 131071 : 524287);
        if (this.isSetSequenceColIdx()) {
            hashCode = hashCode * 8191 + this.sequence_col_idx;
        }
        hashCode = hashCode * 8191 + (this.isSetSortType() ? 131071 : 524287);
        if (this.isSetSortType()) {
            hashCode = hashCode * 8191 + this.sort_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetSortColNum() ? 131071 : 524287);
        if (this.isSetSortColNum()) {
            hashCode = hashCode * 8191 + this.sort_col_num;
        }
        hashCode = hashCode * 8191 + (this.isSetDisableAutoCompaction() ? 131071 : 524287);
        if (this.isSetDisableAutoCompaction()) {
            hashCode = hashCode * 8191 + (this.disable_auto_compaction ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TTabletSchema other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetShortKeyColumnCount()).compareTo(other.isSetShortKeyColumnCount());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetShortKeyColumnCount() && (lastComparison = TBaseHelper.compareTo((short)this.short_key_column_count, (short)other.short_key_column_count)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchemaHash()).compareTo(other.isSetSchemaHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaHash() && (lastComparison = TBaseHelper.compareTo((int)this.schema_hash, (int)other.schema_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKeysType()).compareTo(other.isSetKeysType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeysType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.keys_type), (Comparable)((Object)other.keys_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStorageType()).compareTo(other.isSetStorageType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStorageType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.storage_type), (Comparable)((Object)other.storage_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBloomFilterFpp()).compareTo(other.isSetBloomFilterFpp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBloomFilterFpp() && (lastComparison = TBaseHelper.compareTo((double)this.bloom_filter_fpp, (double)other.bloom_filter_fpp)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIndexes()).compareTo(other.isSetIndexes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndexes() && (lastComparison = TBaseHelper.compareTo(this.indexes, other.indexes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsInMemory()).compareTo(other.isSetIsInMemory());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsInMemory() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_in_memory, (boolean)other.is_in_memory)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDeleteSignIdx()).compareTo(other.isSetDeleteSignIdx());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDeleteSignIdx() && (lastComparison = TBaseHelper.compareTo((int)this.delete_sign_idx, (int)other.delete_sign_idx)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSequenceColIdx()).compareTo(other.isSetSequenceColIdx());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSequenceColIdx() && (lastComparison = TBaseHelper.compareTo((int)this.sequence_col_idx, (int)other.sequence_col_idx)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSortType()).compareTo(other.isSetSortType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSortType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sort_type), (Comparable)((Object)other.sort_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSortColNum()).compareTo(other.isSetSortColNum());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSortColNum() && (lastComparison = TBaseHelper.compareTo((int)this.sort_col_num, (int)other.sort_col_num)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDisableAutoCompaction()).compareTo(other.isSetDisableAutoCompaction());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDisableAutoCompaction() && (lastComparison = TBaseHelper.compareTo((boolean)this.disable_auto_compaction, (boolean)other.disable_auto_compaction)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TTabletSchema.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TTabletSchema.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TTabletSchema(");
        boolean first = true;
        sb.append("short_key_column_count:");
        sb.append(this.short_key_column_count);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("schema_hash:");
        sb.append(this.schema_hash);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("keys_type:");
        if (this.keys_type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.keys_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("storage_type:");
        if (this.storage_type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.storage_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (this.isSetBloomFilterFpp()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bloom_filter_fpp:");
            sb.append(this.bloom_filter_fpp);
            first = false;
        }
        if (this.isSetIndexes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("indexes:");
            if (this.indexes == null) {
                sb.append("null");
            } else {
                sb.append(this.indexes);
            }
            first = false;
        }
        if (this.isSetIsInMemory()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_in_memory:");
            sb.append(this.is_in_memory);
            first = false;
        }
        if (this.isSetDeleteSignIdx()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("delete_sign_idx:");
            sb.append(this.delete_sign_idx);
            first = false;
        }
        if (this.isSetSequenceColIdx()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sequence_col_idx:");
            sb.append(this.sequence_col_idx);
            first = false;
        }
        if (this.isSetSortType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sort_type:");
            if (this.sort_type == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.sort_type);
            }
            first = false;
        }
        if (this.isSetSortColNum()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sort_col_num:");
            sb.append(this.sort_col_num);
            first = false;
        }
        if (this.isSetDisableAutoCompaction()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("disable_auto_compaction:");
            sb.append(this.disable_auto_compaction);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.keys_type == null) {
            throw new TProtocolException("Required field 'keys_type' was not present! Struct: " + this.toString());
        }
        if (this.storage_type == null) {
            throw new TProtocolException("Required field 'storage_type' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SHORT_KEY_COLUMN_COUNT, new FieldMetaData("short_key_column_count", 1, new FieldValueMetaData(6)));
        tmpMap.put(_Fields.SCHEMA_HASH, new FieldMetaData("schema_hash", 1, new FieldValueMetaData(8, "TSchemaHash")));
        tmpMap.put(_Fields.KEYS_TYPE, new FieldMetaData("keys_type", 1, (FieldValueMetaData)new EnumMetaData(16, TKeysType.class)));
        tmpMap.put(_Fields.STORAGE_TYPE, new FieldMetaData("storage_type", 1, (FieldValueMetaData)new EnumMetaData(16, TStorageType.class)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumn.class))));
        tmpMap.put(_Fields.BLOOM_FILTER_FPP, new FieldMetaData("bloom_filter_fpp", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.INDEXES, new FieldMetaData("indexes", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TOlapTableIndex.class))));
        tmpMap.put(_Fields.IS_IN_MEMORY, new FieldMetaData("is_in_memory", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.DELETE_SIGN_IDX, new FieldMetaData("delete_sign_idx", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SEQUENCE_COL_IDX, new FieldMetaData("sequence_col_idx", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SORT_TYPE, new FieldMetaData("sort_type", 2, (FieldValueMetaData)new EnumMetaData(16, TSortType.class)));
        tmpMap.put(_Fields.SORT_COL_NUM, new FieldMetaData("sort_col_num", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DISABLE_AUTO_COMPACTION, new FieldMetaData("disable_auto_compaction", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TTabletSchema.class, metaDataMap);
    }

    private static class TTabletSchemaTupleScheme
    extends TupleScheme<TTabletSchema> {
        private TTabletSchemaTupleScheme() {
        }

        public void write(TProtocol prot, TTabletSchema struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI16(struct.short_key_column_count);
            oprot.writeI32(struct.schema_hash);
            oprot.writeI32(struct.keys_type.getValue());
            oprot.writeI32(struct.storage_type.getValue());
            oprot.writeI32(struct.columns.size());
            for (TColumn _iter8 : struct.columns) {
                _iter8.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetBloomFilterFpp()) {
                optionals.set(0);
            }
            if (struct.isSetIndexes()) {
                optionals.set(1);
            }
            if (struct.isSetIsInMemory()) {
                optionals.set(2);
            }
            if (struct.isSetDeleteSignIdx()) {
                optionals.set(3);
            }
            if (struct.isSetSequenceColIdx()) {
                optionals.set(4);
            }
            if (struct.isSetSortType()) {
                optionals.set(5);
            }
            if (struct.isSetSortColNum()) {
                optionals.set(6);
            }
            if (struct.isSetDisableAutoCompaction()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetBloomFilterFpp()) {
                oprot.writeDouble(struct.bloom_filter_fpp);
            }
            if (struct.isSetIndexes()) {
                oprot.writeI32(struct.indexes.size());
                for (TOlapTableIndex _iter9 : struct.indexes) {
                    _iter9.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIsInMemory()) {
                oprot.writeBool(struct.is_in_memory);
            }
            if (struct.isSetDeleteSignIdx()) {
                oprot.writeI32(struct.delete_sign_idx);
            }
            if (struct.isSetSequenceColIdx()) {
                oprot.writeI32(struct.sequence_col_idx);
            }
            if (struct.isSetSortType()) {
                oprot.writeI32(struct.sort_type.getValue());
            }
            if (struct.isSetSortColNum()) {
                oprot.writeI32(struct.sort_col_num);
            }
            if (struct.isSetDisableAutoCompaction()) {
                oprot.writeBool(struct.disable_auto_compaction);
            }
        }

        public void read(TProtocol prot, TTabletSchema struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.short_key_column_count = iprot.readI16();
            struct.setShortKeyColumnCountIsSet(true);
            struct.schema_hash = iprot.readI32();
            struct.setSchemaHashIsSet(true);
            struct.keys_type = TKeysType.findByValue(iprot.readI32());
            struct.setKeysTypeIsSet(true);
            struct.storage_type = TStorageType.findByValue(iprot.readI32());
            struct.setStorageTypeIsSet(true);
            TList _list10 = new TList(12, iprot.readI32());
            struct.columns = new ArrayList<TColumn>(_list10.size);
            for (int _i12 = 0; _i12 < _list10.size; ++_i12) {
                TColumn _elem11 = new TColumn();
                _elem11.read((TProtocol)iprot);
                struct.columns.add(_elem11);
            }
            struct.setColumnsIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.bloom_filter_fpp = iprot.readDouble();
                struct.setBloomFilterFppIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list13 = new TList(12, iprot.readI32());
                struct.indexes = new ArrayList<TOlapTableIndex>(_list13.size);
                for (int _i15 = 0; _i15 < _list13.size; ++_i15) {
                    TOlapTableIndex _elem14 = new TOlapTableIndex();
                    _elem14.read((TProtocol)iprot);
                    struct.indexes.add(_elem14);
                }
                struct.setIndexesIsSet(true);
            }
            if (incoming.get(2)) {
                struct.is_in_memory = iprot.readBool();
                struct.setIsInMemoryIsSet(true);
            }
            if (incoming.get(3)) {
                struct.delete_sign_idx = iprot.readI32();
                struct.setDeleteSignIdxIsSet(true);
            }
            if (incoming.get(4)) {
                struct.sequence_col_idx = iprot.readI32();
                struct.setSequenceColIdxIsSet(true);
            }
            if (incoming.get(5)) {
                struct.sort_type = TSortType.findByValue(iprot.readI32());
                struct.setSortTypeIsSet(true);
            }
            if (incoming.get(6)) {
                struct.sort_col_num = iprot.readI32();
                struct.setSortColNumIsSet(true);
            }
            if (incoming.get(7)) {
                struct.disable_auto_compaction = iprot.readBool();
                struct.setDisableAutoCompactionIsSet(true);
            }
        }
    }

    private static class TTabletSchemaTupleSchemeFactory
    implements SchemeFactory {
        private TTabletSchemaTupleSchemeFactory() {
        }

        public TTabletSchemaTupleScheme getScheme() {
            return new TTabletSchemaTupleScheme();
        }
    }

    private static class TTabletSchemaStandardScheme
    extends StandardScheme<TTabletSchema> {
        private TTabletSchemaStandardScheme() {
        }

        public void read(TProtocol iprot, TTabletSchema struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 6) {
                            struct.short_key_column_count = iprot.readI16();
                            struct.setShortKeyColumnCountIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.schema_hash = iprot.readI32();
                            struct.setSchemaHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.keys_type = TKeysType.findByValue(iprot.readI32());
                            struct.setKeysTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.storage_type = TStorageType.findByValue(iprot.readI32());
                            struct.setStorageTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.columns = new ArrayList<TColumn>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                TColumn _elem1 = new TColumn();
                                _elem1.read(iprot);
                                struct.columns.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 4) {
                            struct.bloom_filter_fpp = iprot.readDouble();
                            struct.setBloomFilterFppIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list3 = iprot.readListBegin();
                            struct.indexes = new ArrayList<TOlapTableIndex>(_list3.size);
                            for (int _i5 = 0; _i5 < _list3.size; ++_i5) {
                                TOlapTableIndex _elem4 = new TOlapTableIndex();
                                _elem4.read(iprot);
                                struct.indexes.add(_elem4);
                            }
                            iprot.readListEnd();
                            struct.setIndexesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 2) {
                            struct.is_in_memory = iprot.readBool();
                            struct.setIsInMemoryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.delete_sign_idx = iprot.readI32();
                            struct.setDeleteSignIdxIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.sequence_col_idx = iprot.readI32();
                            struct.setSequenceColIdxIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.sort_type = TSortType.findByValue(iprot.readI32());
                            struct.setSortTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 8) {
                            struct.sort_col_num = iprot.readI32();
                            struct.setSortColNumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 2) {
                            struct.disable_auto_compaction = iprot.readBool();
                            struct.setDisableAutoCompactionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetShortKeyColumnCount()) {
                throw new TProtocolException("Required field 'short_key_column_count' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetSchemaHash()) {
                throw new TProtocolException("Required field 'schema_hash' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TTabletSchema struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(SHORT_KEY_COLUMN_COUNT_FIELD_DESC);
            oprot.writeI16(struct.short_key_column_count);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SCHEMA_HASH_FIELD_DESC);
            oprot.writeI32(struct.schema_hash);
            oprot.writeFieldEnd();
            if (struct.keys_type != null) {
                oprot.writeFieldBegin(KEYS_TYPE_FIELD_DESC);
                oprot.writeI32(struct.keys_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.storage_type != null) {
                oprot.writeFieldBegin(STORAGE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.storage_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (TColumn _iter6 : struct.columns) {
                    _iter6.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetBloomFilterFpp()) {
                oprot.writeFieldBegin(BLOOM_FILTER_FPP_FIELD_DESC);
                oprot.writeDouble(struct.bloom_filter_fpp);
                oprot.writeFieldEnd();
            }
            if (struct.indexes != null && struct.isSetIndexes()) {
                oprot.writeFieldBegin(INDEXES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.indexes.size()));
                for (TOlapTableIndex _iter7 : struct.indexes) {
                    _iter7.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsInMemory()) {
                oprot.writeFieldBegin(IS_IN_MEMORY_FIELD_DESC);
                oprot.writeBool(struct.is_in_memory);
                oprot.writeFieldEnd();
            }
            if (struct.isSetDeleteSignIdx()) {
                oprot.writeFieldBegin(DELETE_SIGN_IDX_FIELD_DESC);
                oprot.writeI32(struct.delete_sign_idx);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSequenceColIdx()) {
                oprot.writeFieldBegin(SEQUENCE_COL_IDX_FIELD_DESC);
                oprot.writeI32(struct.sequence_col_idx);
                oprot.writeFieldEnd();
            }
            if (struct.sort_type != null && struct.isSetSortType()) {
                oprot.writeFieldBegin(SORT_TYPE_FIELD_DESC);
                oprot.writeI32(struct.sort_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetSortColNum()) {
                oprot.writeFieldBegin(SORT_COL_NUM_FIELD_DESC);
                oprot.writeI32(struct.sort_col_num);
                oprot.writeFieldEnd();
            }
            if (struct.isSetDisableAutoCompaction()) {
                oprot.writeFieldBegin(DISABLE_AUTO_COMPACTION_FIELD_DESC);
                oprot.writeBool(struct.disable_auto_compaction);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TTabletSchemaStandardSchemeFactory
    implements SchemeFactory {
        private TTabletSchemaStandardSchemeFactory() {
        }

        public TTabletSchemaStandardScheme getScheme() {
            return new TTabletSchemaStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SHORT_KEY_COLUMN_COUNT(1, "short_key_column_count"),
        SCHEMA_HASH(2, "schema_hash"),
        KEYS_TYPE(3, "keys_type"),
        STORAGE_TYPE(4, "storage_type"),
        COLUMNS(5, "columns"),
        BLOOM_FILTER_FPP(6, "bloom_filter_fpp"),
        INDEXES(7, "indexes"),
        IS_IN_MEMORY(8, "is_in_memory"),
        DELETE_SIGN_IDX(9, "delete_sign_idx"),
        SEQUENCE_COL_IDX(10, "sequence_col_idx"),
        SORT_TYPE(11, "sort_type"),
        SORT_COL_NUM(12, "sort_col_num"),
        DISABLE_AUTO_COMPACTION(13, "disable_auto_compaction");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SHORT_KEY_COLUMN_COUNT;
                }
                case 2: {
                    return SCHEMA_HASH;
                }
                case 3: {
                    return KEYS_TYPE;
                }
                case 4: {
                    return STORAGE_TYPE;
                }
                case 5: {
                    return COLUMNS;
                }
                case 6: {
                    return BLOOM_FILTER_FPP;
                }
                case 7: {
                    return INDEXES;
                }
                case 8: {
                    return IS_IN_MEMORY;
                }
                case 9: {
                    return DELETE_SIGN_IDX;
                }
                case 10: {
                    return SEQUENCE_COL_IDX;
                }
                case 11: {
                    return SORT_TYPE;
                }
                case 12: {
                    return SORT_COL_NUM;
                }
                case 13: {
                    return DISABLE_AUTO_COMPACTION;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

