/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect;

import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.dialect.impl.AnsiSqlDialect;
import cn.hutool.db.dialect.impl.H2Dialect;
import cn.hutool.db.dialect.impl.MysqlDialect;
import cn.hutool.db.dialect.impl.OracleDialect;
import cn.hutool.db.dialect.impl.PostgresqlDialect;
import cn.hutool.db.dialect.impl.SqlServer2012Dialect;
import cn.hutool.db.dialect.impl.Sqlite3Dialect;
import cn.hutool.log.StaticLog;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DialectFactory {
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_MYSQL_V6 = "com.mysql.cj.jdbc.Driver";
    public static final String DRIVER_ORACLE = "oracle.jdbc.OracleDriver";
    public static final String DRIVER_ORACLE_OLD = "oracle.jdbc.driver.OracleDriver";
    public static final String DRIVER_POSTGRESQL = "org.postgresql.Driver";
    public static final String DRIVER_SQLLITE3 = "org.sqlite.JDBC";
    public static final String DRIVER_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String DRIVER_HIVE = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static final String DRIVER_HIVE2 = "org.apache.hive.jdbc.HiveDriver";
    public static final String DRIVER_H2 = "org.h2.Driver";
    public static final String DRIVER_DERBY = "org.apache.derby.jdbc.AutoloadedDriver";
    public static final String DRIVER_HSQLDB = "org.hsqldb.jdbc.JDBCDriver";
    public static final String DRIVER_DM7 = "dm.jdbc.driver.DmDriver";
    private static final Map<DataSource, Dialect> DIALECT_POOL = new ConcurrentHashMap<DataSource, Dialect>();

    private DialectFactory() {
    }

    public static Dialect newDialect(String driverName) {
        Dialect dialect = DialectFactory.internalNewDialect(driverName);
        StaticLog.debug("Use Dialect: [{}].", dialect.getClass().getSimpleName());
        return dialect;
    }

    private static Dialect internalNewDialect(String driverName) {
        if (StrUtil.isNotBlank(driverName)) {
            if (DRIVER_MYSQL.equalsIgnoreCase(driverName) || DRIVER_MYSQL_V6.equalsIgnoreCase(driverName)) {
                return new MysqlDialect();
            }
            if (DRIVER_ORACLE.equalsIgnoreCase(driverName) || DRIVER_ORACLE_OLD.equalsIgnoreCase(driverName)) {
                return new OracleDialect();
            }
            if (DRIVER_SQLLITE3.equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect();
            }
            if (DRIVER_POSTGRESQL.equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect();
            }
            if (DRIVER_H2.equalsIgnoreCase(driverName)) {
                return new H2Dialect();
            }
            if (DRIVER_SQLSERVER.equalsIgnoreCase(driverName)) {
                return new SqlServer2012Dialect();
            }
        }
        return new AnsiSqlDialect();
    }

    public static String identifyDriver(String nameContainsProductInfo) {
        if (StrUtil.isBlank(nameContainsProductInfo)) {
            return null;
        }
        nameContainsProductInfo = StrUtil.cleanBlank(nameContainsProductInfo.toLowerCase());
        String driver = null;
        if (nameContainsProductInfo.contains("mysql")) {
            driver = ClassLoaderUtil.isPresent(DRIVER_MYSQL_V6) ? DRIVER_MYSQL_V6 : DRIVER_MYSQL;
        } else if (nameContainsProductInfo.contains("oracle")) {
            driver = ClassLoaderUtil.isPresent(DRIVER_ORACLE) ? DRIVER_ORACLE : DRIVER_ORACLE_OLD;
        } else if (nameContainsProductInfo.contains("postgresql")) {
            driver = DRIVER_POSTGRESQL;
        } else if (nameContainsProductInfo.contains("sqlite")) {
            driver = DRIVER_SQLLITE3;
        } else if (nameContainsProductInfo.contains("sqlserver")) {
            driver = DRIVER_SQLSERVER;
        } else if (nameContainsProductInfo.contains("hive")) {
            driver = DRIVER_HIVE;
        } else if (nameContainsProductInfo.contains("h2")) {
            driver = DRIVER_H2;
        } else if (nameContainsProductInfo.contains("derby")) {
            driver = DRIVER_DERBY;
        } else if (nameContainsProductInfo.contains("hsqldb")) {
            driver = DRIVER_HSQLDB;
        } else if (nameContainsProductInfo.contains("dm")) {
            driver = DRIVER_DM7;
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect getDialect(DataSource ds) {
        Dialect dialect = DIALECT_POOL.get(ds);
        if (null == dialect) {
            DataSource dataSource = ds;
            synchronized (dataSource) {
                dialect = DIALECT_POOL.get(ds);
                if (null == dialect) {
                    dialect = DialectFactory.newDialect(ds);
                    DIALECT_POOL.put(ds, dialect);
                }
            }
        }
        return dialect;
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(DriverUtil.identifyDriver(ds));
    }

    public static Dialect newDialect(Connection conn) {
        return DialectFactory.newDialect(DriverUtil.identifyDriver(conn));
    }
}

