/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HighlightField
implements JsonpSerializable {
    @Nullable
    private final String boundaryChars;
    @Nullable
    private final Integer boundaryMaxScan;
    @Nullable
    private final BoundaryScanner boundaryScanner;
    @Nullable
    private final String boundaryScannerLocale;
    @Nullable
    private final String field;
    @Nullable
    private final Boolean forceSource;
    @Nullable
    private final HighlighterFragmenter fragmenter;
    @Nullable
    private final Integer fragmentOffset;
    @Nullable
    private final Integer fragmentSize;
    @Nullable
    private final Query highlightQuery;
    private final List<String> matchedFields;
    @Nullable
    private final Integer maxFragmentLength;
    @Nullable
    private final Integer noMatchSize;
    @Nullable
    private final Integer numberOfFragments;
    @Nullable
    private final HighlighterOrder order;
    @Nullable
    private final Integer phraseLimit;
    private final List<String> postTags;
    private final List<String> preTags;
    @Nullable
    private final Boolean requireFieldMatch;
    @Nullable
    private final HighlighterTagsSchema tagsSchema;
    @Nullable
    private final HighlighterType type;
    public static final JsonpDeserializer<HighlightField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HighlightField::setupHighlightFieldDeserializer);

    private HighlightField(Builder builder) {
        this.boundaryChars = builder.boundaryChars;
        this.boundaryMaxScan = builder.boundaryMaxScan;
        this.boundaryScanner = builder.boundaryScanner;
        this.boundaryScannerLocale = builder.boundaryScannerLocale;
        this.field = builder.field;
        this.forceSource = builder.forceSource;
        this.fragmenter = builder.fragmenter;
        this.fragmentOffset = builder.fragmentOffset;
        this.fragmentSize = builder.fragmentSize;
        this.highlightQuery = builder.highlightQuery;
        this.matchedFields = ApiTypeHelper.unmodifiable(builder.matchedFields);
        this.maxFragmentLength = builder.maxFragmentLength;
        this.noMatchSize = builder.noMatchSize;
        this.numberOfFragments = builder.numberOfFragments;
        this.order = builder.order;
        this.phraseLimit = builder.phraseLimit;
        this.postTags = ApiTypeHelper.unmodifiable(builder.postTags);
        this.preTags = ApiTypeHelper.unmodifiable(builder.preTags);
        this.requireFieldMatch = builder.requireFieldMatch;
        this.tagsSchema = builder.tagsSchema;
        this.type = builder.type;
    }

    public static HighlightField of(Function<Builder, ObjectBuilder<HighlightField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String boundaryChars() {
        return this.boundaryChars;
    }

    @Nullable
    public final Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    @Nullable
    public final BoundaryScanner boundaryScanner() {
        return this.boundaryScanner;
    }

    @Nullable
    public final String boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean forceSource() {
        return this.forceSource;
    }

    @Nullable
    public final HighlighterFragmenter fragmenter() {
        return this.fragmenter;
    }

    @Nullable
    public final Integer fragmentOffset() {
        return this.fragmentOffset;
    }

    @Nullable
    public final Integer fragmentSize() {
        return this.fragmentSize;
    }

    @Nullable
    public final Query highlightQuery() {
        return this.highlightQuery;
    }

    public final List<String> matchedFields() {
        return this.matchedFields;
    }

    @Nullable
    public final Integer maxFragmentLength() {
        return this.maxFragmentLength;
    }

    @Nullable
    public final Integer noMatchSize() {
        return this.noMatchSize;
    }

    @Nullable
    public final Integer numberOfFragments() {
        return this.numberOfFragments;
    }

    @Nullable
    public final HighlighterOrder order() {
        return this.order;
    }

    @Nullable
    public final Integer phraseLimit() {
        return this.phraseLimit;
    }

    public final List<String> postTags() {
        return this.postTags;
    }

    public final List<String> preTags() {
        return this.preTags;
    }

    @Nullable
    public final Boolean requireFieldMatch() {
        return this.requireFieldMatch;
    }

    @Nullable
    public final HighlighterTagsSchema tagsSchema() {
        return this.tagsSchema;
    }

    @Nullable
    public final HighlighterType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.boundaryChars != null) {
            generator.writeKey("boundary_chars");
            generator.write(this.boundaryChars);
        }
        if (this.boundaryMaxScan != null) {
            generator.writeKey("boundary_max_scan");
            generator.write(this.boundaryMaxScan.intValue());
        }
        if (this.boundaryScanner != null) {
            generator.writeKey("boundary_scanner");
            this.boundaryScanner.serialize(generator, mapper);
        }
        if (this.boundaryScannerLocale != null) {
            generator.writeKey("boundary_scanner_locale");
            generator.write(this.boundaryScannerLocale);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.forceSource != null) {
            generator.writeKey("force_source");
            generator.write(this.forceSource.booleanValue());
        }
        if (this.fragmenter != null) {
            generator.writeKey("fragmenter");
            this.fragmenter.serialize(generator, mapper);
        }
        if (this.fragmentOffset != null) {
            generator.writeKey("fragment_offset");
            generator.write(this.fragmentOffset.intValue());
        }
        if (this.fragmentSize != null) {
            generator.writeKey("fragment_size");
            generator.write(this.fragmentSize.intValue());
        }
        if (this.highlightQuery != null) {
            generator.writeKey("highlight_query");
            this.highlightQuery.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.matchedFields)) {
            generator.writeKey("matched_fields");
            generator.writeStartArray();
            for (String item0 : this.matchedFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.maxFragmentLength != null) {
            generator.writeKey("max_fragment_length");
            generator.write(this.maxFragmentLength.intValue());
        }
        if (this.noMatchSize != null) {
            generator.writeKey("no_match_size");
            generator.write(this.noMatchSize.intValue());
        }
        if (this.numberOfFragments != null) {
            generator.writeKey("number_of_fragments");
            generator.write(this.numberOfFragments.intValue());
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.phraseLimit != null) {
            generator.writeKey("phrase_limit");
            generator.write(this.phraseLimit.intValue());
        }
        if (ApiTypeHelper.isDefined(this.postTags)) {
            generator.writeKey("post_tags");
            generator.writeStartArray();
            for (String item0 : this.postTags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.preTags)) {
            generator.writeKey("pre_tags");
            generator.writeStartArray();
            for (String item0 : this.preTags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.requireFieldMatch != null) {
            generator.writeKey("require_field_match");
            generator.write(this.requireFieldMatch.booleanValue());
        }
        if (this.tagsSchema != null) {
            generator.writeKey("tags_schema");
            this.tagsSchema.serialize(generator, mapper);
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHighlightFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boundaryChars, JsonpDeserializer.stringDeserializer(), "boundary_chars");
        op.add(Builder::boundaryMaxScan, JsonpDeserializer.integerDeserializer(), "boundary_max_scan");
        op.add(Builder::boundaryScanner, BoundaryScanner._DESERIALIZER, "boundary_scanner");
        op.add(Builder::boundaryScannerLocale, JsonpDeserializer.stringDeserializer(), "boundary_scanner_locale");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::forceSource, JsonpDeserializer.booleanDeserializer(), "force_source");
        op.add(Builder::fragmenter, HighlighterFragmenter._DESERIALIZER, "fragmenter");
        op.add(Builder::fragmentOffset, JsonpDeserializer.integerDeserializer(), "fragment_offset");
        op.add(Builder::fragmentSize, JsonpDeserializer.integerDeserializer(), "fragment_size");
        op.add(Builder::highlightQuery, Query._DESERIALIZER, "highlight_query");
        op.add(Builder::matchedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "matched_fields");
        op.add(Builder::maxFragmentLength, JsonpDeserializer.integerDeserializer(), "max_fragment_length");
        op.add(Builder::noMatchSize, JsonpDeserializer.integerDeserializer(), "no_match_size");
        op.add(Builder::numberOfFragments, JsonpDeserializer.integerDeserializer(), "number_of_fragments");
        op.add(Builder::order, HighlighterOrder._DESERIALIZER, "order");
        op.add(Builder::phraseLimit, JsonpDeserializer.integerDeserializer(), "phrase_limit");
        op.add(Builder::postTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "post_tags");
        op.add(Builder::preTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pre_tags");
        op.add(Builder::requireFieldMatch, JsonpDeserializer.booleanDeserializer(), "require_field_match");
        op.add(Builder::tagsSchema, HighlighterTagsSchema._DESERIALIZER, "tags_schema");
        op.add(Builder::type, HighlighterType._DESERIALIZER, "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HighlightField> {
        @Nullable
        private String boundaryChars;
        @Nullable
        private Integer boundaryMaxScan;
        @Nullable
        private BoundaryScanner boundaryScanner;
        @Nullable
        private String boundaryScannerLocale;
        @Nullable
        private String field;
        @Nullable
        private Boolean forceSource;
        @Nullable
        private HighlighterFragmenter fragmenter;
        @Nullable
        private Integer fragmentOffset;
        @Nullable
        private Integer fragmentSize;
        @Nullable
        private Query highlightQuery;
        @Nullable
        private List<String> matchedFields;
        @Nullable
        private Integer maxFragmentLength;
        @Nullable
        private Integer noMatchSize;
        @Nullable
        private Integer numberOfFragments;
        @Nullable
        private HighlighterOrder order;
        @Nullable
        private Integer phraseLimit;
        @Nullable
        private List<String> postTags;
        @Nullable
        private List<String> preTags;
        @Nullable
        private Boolean requireFieldMatch;
        @Nullable
        private HighlighterTagsSchema tagsSchema;
        @Nullable
        private HighlighterType type;

        public final Builder boundaryChars(@Nullable String value) {
            this.boundaryChars = value;
            return this;
        }

        public final Builder boundaryMaxScan(@Nullable Integer value) {
            this.boundaryMaxScan = value;
            return this;
        }

        public final Builder boundaryScanner(@Nullable BoundaryScanner value) {
            this.boundaryScanner = value;
            return this;
        }

        public final Builder boundaryScannerLocale(@Nullable String value) {
            this.boundaryScannerLocale = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder forceSource(@Nullable Boolean value) {
            this.forceSource = value;
            return this;
        }

        public final Builder fragmenter(@Nullable HighlighterFragmenter value) {
            this.fragmenter = value;
            return this;
        }

        public final Builder fragmentOffset(@Nullable Integer value) {
            this.fragmentOffset = value;
            return this;
        }

        public final Builder fragmentSize(@Nullable Integer value) {
            this.fragmentSize = value;
            return this;
        }

        public final Builder highlightQuery(@Nullable Query value) {
            this.highlightQuery = value;
            return this;
        }

        public final Builder highlightQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.highlightQuery(fn.apply(new Query.Builder()).build());
        }

        public final Builder matchedFields(List<String> list) {
            this.matchedFields = Builder._listAddAll(this.matchedFields, list);
            return this;
        }

        public final Builder matchedFields(String value, String ... values) {
            this.matchedFields = Builder._listAdd(this.matchedFields, value, values);
            return this;
        }

        public final Builder maxFragmentLength(@Nullable Integer value) {
            this.maxFragmentLength = value;
            return this;
        }

        public final Builder noMatchSize(@Nullable Integer value) {
            this.noMatchSize = value;
            return this;
        }

        public final Builder numberOfFragments(@Nullable Integer value) {
            this.numberOfFragments = value;
            return this;
        }

        public final Builder order(@Nullable HighlighterOrder value) {
            this.order = value;
            return this;
        }

        public final Builder phraseLimit(@Nullable Integer value) {
            this.phraseLimit = value;
            return this;
        }

        public final Builder postTags(List<String> list) {
            this.postTags = Builder._listAddAll(this.postTags, list);
            return this;
        }

        public final Builder postTags(String value, String ... values) {
            this.postTags = Builder._listAdd(this.postTags, value, values);
            return this;
        }

        public final Builder preTags(List<String> list) {
            this.preTags = Builder._listAddAll(this.preTags, list);
            return this;
        }

        public final Builder preTags(String value, String ... values) {
            this.preTags = Builder._listAdd(this.preTags, value, values);
            return this;
        }

        public final Builder requireFieldMatch(@Nullable Boolean value) {
            this.requireFieldMatch = value;
            return this;
        }

        public final Builder tagsSchema(@Nullable HighlighterTagsSchema value) {
            this.tagsSchema = value;
            return this;
        }

        public final Builder type(@Nullable HighlighterType value) {
            this.type = value;
            return this;
        }

        public final Builder type(Function<HighlighterType.Builder, ObjectBuilder<HighlighterType>> fn) {
            return this.type(fn.apply(new HighlighterType.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HighlightField build() {
            this._checkSingleUse();
            return new HighlightField(this);
        }
    }
}

