/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ErrorResponse
implements JsonpSerializable {
    private final ErrorCause error;
    private final int status;
    public static final JsonpDeserializer<ErrorResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ErrorResponse::setupErrorResponseDeserializer);

    private ErrorResponse(Builder builder) {
        this.error = ApiTypeHelper.requireNonNull(builder.error, this, "error");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static ErrorResponse of(Function<Builder, ObjectBuilder<ErrorResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ErrorCause error() {
        return this.error;
    }

    public final int status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error");
        this.error.serialize(generator, mapper);
        generator.writeKey("status");
        generator.write(this.status);
    }

    protected static void setupErrorResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ErrorResponse> {
        private ErrorCause error;
        private Integer status;

        public final Builder error(ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder status(int value) {
            this.status = value;
            return this;
        }

        @Override
        public ErrorResponse build() {
            this._checkSingleUse();
            return new ErrorResponse(this);
        }
    }
}

