/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.CheckpointStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Checkpointing
implements JsonpSerializable {
    @Nullable
    private final Long changesLastDetectedAt;
    @Nullable
    private final DateTime changesLastDetectedAtDateTime;
    private final CheckpointStats last;
    @Nullable
    private final CheckpointStats next;
    @Nullable
    private final Long operationsBehind;
    @Nullable
    private final Long lastSearchTime;
    public static final JsonpDeserializer<Checkpointing> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Checkpointing::setupCheckpointingDeserializer);

    private Checkpointing(Builder builder) {
        this.changesLastDetectedAt = builder.changesLastDetectedAt;
        this.changesLastDetectedAtDateTime = builder.changesLastDetectedAtDateTime;
        this.last = ApiTypeHelper.requireNonNull(builder.last, this, "last");
        this.next = builder.next;
        this.operationsBehind = builder.operationsBehind;
        this.lastSearchTime = builder.lastSearchTime;
    }

    public static Checkpointing of(Function<Builder, ObjectBuilder<Checkpointing>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long changesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    @Nullable
    public final DateTime changesLastDetectedAtDateTime() {
        return this.changesLastDetectedAtDateTime;
    }

    public final CheckpointStats last() {
        return this.last;
    }

    @Nullable
    public final CheckpointStats next() {
        return this.next;
    }

    @Nullable
    public final Long operationsBehind() {
        return this.operationsBehind;
    }

    @Nullable
    public final Long lastSearchTime() {
        return this.lastSearchTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.changesLastDetectedAt != null) {
            generator.writeKey("changes_last_detected_at");
            generator.write(this.changesLastDetectedAt.longValue());
        }
        if (this.changesLastDetectedAtDateTime != null) {
            generator.writeKey("changes_last_detected_at_date_time");
            this.changesLastDetectedAtDateTime.serialize(generator, mapper);
        }
        generator.writeKey("last");
        this.last.serialize(generator, mapper);
        if (this.next != null) {
            generator.writeKey("next");
            this.next.serialize(generator, mapper);
        }
        if (this.operationsBehind != null) {
            generator.writeKey("operations_behind");
            generator.write(this.operationsBehind.longValue());
        }
        if (this.lastSearchTime != null) {
            generator.writeKey("last_search_time");
            generator.write(this.lastSearchTime.longValue());
        }
    }

    protected static void setupCheckpointingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::changesLastDetectedAt, JsonpDeserializer.longDeserializer(), "changes_last_detected_at");
        op.add(Builder::changesLastDetectedAtDateTime, DateTime._DESERIALIZER, "changes_last_detected_at_date_time");
        op.add(Builder::last, CheckpointStats._DESERIALIZER, "last");
        op.add(Builder::next, CheckpointStats._DESERIALIZER, "next");
        op.add(Builder::operationsBehind, JsonpDeserializer.longDeserializer(), "operations_behind");
        op.add(Builder::lastSearchTime, JsonpDeserializer.longDeserializer(), "last_search_time");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Checkpointing> {
        @Nullable
        private Long changesLastDetectedAt;
        @Nullable
        private DateTime changesLastDetectedAtDateTime;
        private CheckpointStats last;
        @Nullable
        private CheckpointStats next;
        @Nullable
        private Long operationsBehind;
        @Nullable
        private Long lastSearchTime;

        public final Builder changesLastDetectedAt(@Nullable Long value) {
            this.changesLastDetectedAt = value;
            return this;
        }

        public final Builder changesLastDetectedAtDateTime(@Nullable DateTime value) {
            this.changesLastDetectedAtDateTime = value;
            return this;
        }

        public final Builder last(CheckpointStats value) {
            this.last = value;
            return this;
        }

        public final Builder last(Function<CheckpointStats.Builder, ObjectBuilder<CheckpointStats>> fn) {
            return this.last(fn.apply(new CheckpointStats.Builder()).build());
        }

        public final Builder next(@Nullable CheckpointStats value) {
            this.next = value;
            return this;
        }

        public final Builder next(Function<CheckpointStats.Builder, ObjectBuilder<CheckpointStats>> fn) {
            return this.next(fn.apply(new CheckpointStats.Builder()).build());
        }

        public final Builder operationsBehind(@Nullable Long value) {
            this.operationsBehind = value;
            return this;
        }

        public final Builder lastSearchTime(@Nullable Long value) {
            this.lastSearchTime = value;
            return this;
        }

        @Override
        public Checkpointing build() {
            this._checkSingleUse();
            return new Checkpointing(this);
        }
    }
}

