/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.DataEmailAttachment;
import co.elastic.clients.elasticsearch.watcher.EmailAttachmentVariant;
import co.elastic.clients.elasticsearch.watcher.HttpEmailAttachment;
import co.elastic.clients.elasticsearch.watcher.ReportingEmailAttachment;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EmailAttachment
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<EmailAttachment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EmailAttachment::setupEmailAttachmentDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public EmailAttachment(EmailAttachmentVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._emailAttachmentKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private EmailAttachment(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static EmailAttachment of(Function<Builder, ObjectBuilder<EmailAttachment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isHttp() {
        return this._kind == Kind.Http;
    }

    public HttpEmailAttachment http() {
        return (HttpEmailAttachment)TaggedUnionUtils.get(this, Kind.Http);
    }

    public boolean isReporting() {
        return this._kind == Kind.Reporting;
    }

    public ReportingEmailAttachment reporting() {
        return (ReportingEmailAttachment)TaggedUnionUtils.get(this, Kind.Reporting);
    }

    public boolean isData() {
        return this._kind == Kind.Data;
    }

    public DataEmailAttachment data() {
        return (DataEmailAttachment)TaggedUnionUtils.get(this, Kind.Data);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupEmailAttachmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::http, HttpEmailAttachment._DESERIALIZER, "http");
        op.add(Builder::reporting, ReportingEmailAttachment._DESERIALIZER, "reporting");
        op.add(Builder::data, DataEmailAttachment._DESERIALIZER, "data");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<EmailAttachment> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<EmailAttachment> http(HttpEmailAttachment v) {
            this._kind = Kind.Http;
            this._value = v;
            return this;
        }

        public ObjectBuilder<EmailAttachment> http(Function<HttpEmailAttachment.Builder, ObjectBuilder<HttpEmailAttachment>> fn) {
            return this.http(fn.apply(new HttpEmailAttachment.Builder()).build());
        }

        public ObjectBuilder<EmailAttachment> reporting(ReportingEmailAttachment v) {
            this._kind = Kind.Reporting;
            this._value = v;
            return this;
        }

        public ObjectBuilder<EmailAttachment> reporting(Function<ReportingEmailAttachment.Builder, ObjectBuilder<ReportingEmailAttachment>> fn) {
            return this.reporting(fn.apply(new ReportingEmailAttachment.Builder()).build());
        }

        public ObjectBuilder<EmailAttachment> data(DataEmailAttachment v) {
            this._kind = Kind.Data;
            this._value = v;
            return this;
        }

        public ObjectBuilder<EmailAttachment> data(Function<DataEmailAttachment.Builder, ObjectBuilder<DataEmailAttachment>> fn) {
            return this.data(fn.apply(new DataEmailAttachment.Builder()).build());
        }

        @Override
        public EmailAttachment build() {
            this._checkSingleUse();
            return new EmailAttachment(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Http("http"),
        Reporting("reporting"),
        Data("data");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

