/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexAction
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String docId;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final OpType opType;
    @Nullable
    private final Time timeout;
    @Nullable
    private final String executionTimeField;
    public static final JsonpDeserializer<IndexAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexAction::setupIndexActionDeserializer);

    private IndexAction(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.docId = builder.docId;
        this.refresh = builder.refresh;
        this.opType = builder.opType;
        this.timeout = builder.timeout;
        this.executionTimeField = builder.executionTimeField;
    }

    public static IndexAction of(Function<Builder, ObjectBuilder<IndexAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String docId() {
        return this.docId;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final OpType opType() {
        return this.opType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final String executionTimeField() {
        return this.executionTimeField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.docId != null) {
            generator.writeKey("doc_id");
            generator.write(this.docId);
        }
        if (this.refresh != null) {
            generator.writeKey("refresh");
            this.refresh.serialize(generator, mapper);
        }
        if (this.opType != null) {
            generator.writeKey("op_type");
            this.opType.serialize(generator, mapper);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
        if (this.executionTimeField != null) {
            generator.writeKey("execution_time_field");
            generator.write(this.executionTimeField);
        }
    }

    protected static void setupIndexActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::docId, JsonpDeserializer.stringDeserializer(), "doc_id");
        op.add(Builder::refresh, Refresh._DESERIALIZER, "refresh");
        op.add(Builder::opType, OpType._DESERIALIZER, "op_type");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
        op.add(Builder::executionTimeField, JsonpDeserializer.stringDeserializer(), "execution_time_field");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexAction> {
        private String index;
        @Nullable
        private String docId;
        @Nullable
        private Refresh refresh;
        @Nullable
        private OpType opType;
        @Nullable
        private Time timeout;
        @Nullable
        private String executionTimeField;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder docId(@Nullable String value) {
            this.docId = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder opType(@Nullable OpType value) {
            this.opType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder executionTimeField(@Nullable String value) {
            this.executionTimeField = value;
            return this;
        }

        @Override
        public IndexAction build() {
            this._checkSingleUse();
            return new IndexAction(this);
        }
    }
}

