/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class JSONReaderASCII
extends JSONReaderUTF8 {
    final String str;

    JSONReaderASCII(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, str, bytes, offset, length);
        this.str = str;
        this.nameAscii = true;
    }

    JSONReaderASCII(JSONReader.Context ctx, InputStream is) {
        super(ctx, is);
        this.nameAscii = true;
        this.str = null;
    }

    @Override
    public final void next() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset >= this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch > 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)(ch & 0xFF);
        if (ch == 47) {
            this.skipComment();
        }
    }

    @Override
    public final boolean nextIfObjectStart() {
        int ch = this.ch;
        if (ch != 123) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.ch = (char)(ch & 0xFF);
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (first == 'n' && offset + 2 < end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            offset += 3;
        } else if ((first == '\"' || first == '\'') && offset < end && bytes[offset] == first) {
            ++offset;
        } else {
            return false;
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)(ch & 0xFF);
        return true;
    }

    @Override
    public final long readFieldNameHashCode() {
        long hashCode;
        byte c1;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        if (ch != 34 && ch != 39) {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderASCII.isFirstIdentifier(ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (ch == 125 || this.isNull()) {
                return -1L;
            }
            String errorMsg = ch == 91 && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + ch;
            throw new JSONException(this.info(errorMsg));
        }
        int quote = ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (offset + 9 < this.end) {
            byte c0 = bytes[offset];
            if (c0 == quote) {
                nameValue = 0L;
            } else {
                c1 = bytes[offset + 1];
                if (c1 == quote && c0 != 92 && c0 > 0) {
                    nameValue = c0;
                    this.nameLength = 1;
                    this.nameEnd = offset + 1;
                    offset += 2;
                } else {
                    byte c2 = bytes[offset + 2];
                    if (c2 == quote && c0 != 92 && c1 != 92 && c0 >= 0 && c1 > 0) {
                        nameValue = (c1 << 8) + c0;
                        this.nameLength = 2;
                        this.nameEnd = offset + 2;
                        offset += 3;
                    } else {
                        byte c3 = bytes[offset + 3];
                        if (c3 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c0 >= 0 && c1 >= 0 && c2 > 0) {
                            nameValue = (c2 << 16) + (c1 << 8) + c0;
                            this.nameLength = 3;
                            this.nameEnd = offset + 3;
                            offset += 4;
                        } else {
                            byte c4 = bytes[offset + 4];
                            if (c4 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 > 0) {
                                nameValue = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                                this.nameLength = 4;
                                this.nameEnd = offset + 4;
                                offset += 5;
                            } else {
                                byte c5 = bytes[offset + 5];
                                if (c5 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 > 0) {
                                    nameValue = ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                    this.nameLength = 5;
                                    this.nameEnd = offset + 5;
                                    offset += 6;
                                } else {
                                    byte c6 = bytes[offset + 6];
                                    if (c6 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 > 0) {
                                        nameValue = ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                        this.nameLength = 6;
                                        this.nameEnd = offset + 6;
                                        offset += 7;
                                    } else {
                                        byte c7 = bytes[offset + 7];
                                        if (c7 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 > 0) {
                                            nameValue = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 7;
                                            this.nameEnd = offset + 7;
                                            offset += 8;
                                        } else if (bytes[offset + 8] == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 >= 0 && c7 > 0) {
                                            nameValue = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 8;
                                            this.nameEnd = offset + 8;
                                            offset += 9;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < this.end) {
                ch = bytes[offset] & 0xFF;
                if (ch == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    if (ch > 255) {
                        this.nameAscii = false;
                    }
                } else if (ch == -61 || ch == -62) {
                    c1 = bytes[++offset];
                    ch = (char)((ch & 0x1F) << 6 | c1 & 0x3F);
                    this.nameAscii = false;
                }
                if (ch > 255 || ch < 0 || i >= 8 || i == 0 && ch == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)ch;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                if ((ch = bytes[offset]) == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                } else {
                    if (ch == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch != 58) {
            throw new JSONException(this.info("expect ':', but " + ch));
        }
        int n2 = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)(ch & 0xFF);
        return hashCode;
    }

    @Override
    public final long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        int offset = this.offset;
        int end = this.end;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        this.nameBegin = offset - 1;
        int first = ch;
        long nameValue = 0L;
        int i = 0;
        block26: while (offset <= end) {
            switch (ch) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 26: 
                case 32: 
                case 33: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    this.nameLength = i;
                    int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                    if (ch > 32 || (1L << ch & 0x100003700L) == 0L) break block26;
                    ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
                    break block26;
                }
                default: {
                    if (ch == 92) {
                        this.nameEscape = true;
                        ch = (char)bytes[offset++];
                        switch (ch) {
                            case 117: {
                                ch = JSONReaderASCII.char4(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
                                offset += 4;
                                break;
                            }
                            case 120: {
                                ch = JSONReaderASCII.char2(bytes[offset], bytes[offset + 1]);
                                offset += 2;
                                break;
                            }
                            case 34: 
                            case 42: 
                            case 43: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 64: 
                            case 92: {
                                break;
                            }
                            default: {
                                ch = this.char1(ch);
                            }
                        }
                    }
                    if (ch > 255 || i >= 8 || i == 0 && ch == 0) {
                        nameValue = 0L;
                        ch = first;
                        offset = this.nameBegin + 1;
                        break block26;
                    }
                    byte c = (byte)ch;
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ch = offset == end ? 26 : bytes[offset++] & 0xFF;
                    ++i;
                    continue block26;
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            block27: while (true) {
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = bytes[offset++];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderASCII.char4(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderASCII.char2(bytes[offset], bytes[offset + 1]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                    ch = offset == end ? 26 : bytes[offset++] & 0xFF;
                } else {
                    switch (ch) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 26: 
                        case 32: 
                        case 33: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 91: 
                        case 93: 
                        case 123: 
                        case 125: {
                            this.nameLength = i2;
                            int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                                ch = offset == end ? 26 : bytes[offset++] & 0xFF;
                            }
                            break block27;
                        }
                        default: {
                            hashCode ^= (long)ch;
                            hashCode *= 1099511628211L;
                            ch = offset == end ? 26 : bytes[offset++] & 0xFF;
                        }
                    }
                }
                ++i2;
            }
        }
        if (ch == 58) {
            int n = ch = offset == end ? 26 : bytes[offset++] & 0xFF;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++] & 0xFF;
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    public static long getLong(byte[] bytes, int off) {
        return JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off);
    }

    @Override
    public final long readValueHashCode() {
        long hashCode;
        int ch = this.ch;
        if (ch != 34 && ch != 39) {
            return -1L;
        }
        byte[] bytes = this.bytes;
        int quote = ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        int i = 0;
        while (offset < this.end) {
            ch = bytes[offset];
            if (ch == quote) {
                if (i == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                this.nameLength = i;
                this.nameEnd = offset++;
                break;
            }
            if (ch == 92) {
                this.nameEscape = true;
                ch = bytes[++offset];
                switch (ch) {
                    case 117: {
                        ch = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 120: {
                        ch = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        ch = this.char1(ch);
                        break;
                    }
                }
            } else if (ch == -61 || ch == -62) {
                ch = (char)((ch & 0x1F) << 6 | bytes[++offset] & 0x3F);
            }
            if (ch > 255 || ch < 0 || i >= 8 || i == 0 && ch == 0) {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)ch;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++offset;
            ++i;
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            while (true) {
                if ((ch = bytes[offset]) == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                } else {
                    if (ch == 34) {
                        this.nameLength = i2;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
                ++i2;
            }
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)(ch & 0xFF);
        return hashCode;
    }

    @Override
    public final long getNameHashCodeLCase() {
        int offset;
        byte[] bytes = this.bytes;
        long nameValue = 0L;
        int i = 0;
        for (offset = this.nameBegin; offset < this.end; ++offset) {
            byte c1;
            char c = bytes[offset];
            if (c == '\\') {
                c = bytes[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if (c > '\u00ff' || c < '\u0000' || i >= 8 || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if ((c == '_' || c == '-' || c == ' ') && (c1 = bytes[offset + 1]) != 34 && c1 != 39 && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        while (offset < this.end) {
            byte c1;
            char c = bytes[offset];
            if (c == '\\') {
                c = bytes[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-' || c == ' ') && (c1 = bytes[++offset]) != 34 && c1 != 39 && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= c < '\u0000' ? (long)(c & 0xFF) : (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public final String getFieldName() {
        int i;
        Object[] chars;
        byte[] bytes = this.bytes;
        int offset = this.nameBegin;
        int length = this.nameEnd - offset;
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(offset, this.nameEnd);
            }
            if (JDKUtils.ANDROID) {
                return this.getLatin1String(offset, length);
            }
            return new String(bytes, offset, length, StandardCharsets.ISO_8859_1);
        }
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            chars = new byte[this.nameLength];
            i = 0;
            block10: while (offset < this.nameEnd) {
                byte b = bytes[offset];
                if (b == 92) {
                    b = bytes[++offset];
                    switch (b) {
                        case 117: {
                            char ch = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            if (ch > '\u00ff') {
                                chars = null;
                                break block10;
                            }
                            b = (byte)ch;
                            break;
                        }
                        case 120: {
                            char c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            if (c > '\u00ff') {
                                chars = null;
                                break block10;
                            }
                            b = (byte)c;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            b = (byte)this.char1(b);
                            break;
                        }
                    }
                } else if (b == 34) break;
                chars[i] = b;
                ++offset;
                ++i;
            }
            if (chars != null) {
                return JDKUtils.STRING_CREATOR_JDK11.apply((byte[])chars, JDKUtils.LATIN1);
            }
        }
        offset = this.nameBegin;
        chars = new char[this.nameLength];
        i = 0;
        while (offset < this.nameEnd) {
            char ch = (char)(bytes[offset] & 0xFF);
            if (ch == '\\') {
                ch = (char)bytes[++offset];
                switch (ch) {
                    case 'u': {
                        ch = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        ch = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': {
                        break;
                    }
                    default: {
                        ch = this.char1(ch);
                        break;
                    }
                }
            } else if (ch == '\"') break;
            chars[i] = ch;
            ++offset;
            ++i;
        }
        return new String((char[])chars);
    }

    @Override
    public final String readFieldName() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderASCII.isFirstIdentifier(quote)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        byte[] bytes = this.bytes;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int nameBegin = this.nameBegin;
        int i = 0;
        while (offset < this.end) {
            byte c = bytes[offset];
            if (c == 92) {
                this.nameEscape = true;
                offset += (c = bytes[offset + 1]) == 117 ? 6 : (c == 120 ? 4 : 2);
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = bytes[++offset];
                    }
                    if (c != 58) {
                        throw JSONReaderASCII.syntaxError(offset, this.ch);
                    }
                    if (++offset >= this.end) {
                        this.ch = (char)26;
                        throw JSONReaderASCII.syntaxError(offset, this.ch);
                    }
                    c = bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = bytes[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = (char)c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (this.nameEnd < nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            int length = this.nameEnd - nameBegin;
            switch (length) {
                case 1: {
                    return TypeUtils.toString(bytes[nameBegin]);
                }
                case 2: {
                    return TypeUtils.toString(bytes[nameBegin], bytes[nameBegin + 1]);
                }
                case 3: {
                    nameValue0 = (bytes[nameBegin + 2] << 16) + ((bytes[nameBegin + 1] & 0xFF) << 8) + (bytes[nameBegin] & 0xFF);
                    break;
                }
                case 4: {
                    nameValue0 = (bytes[nameBegin + 3] << 24) + ((bytes[nameBegin + 2] & 0xFF) << 16) + ((bytes[nameBegin + 1] & 0xFF) << 8) + (bytes[nameBegin] & 0xFF);
                    break;
                }
                case 5: {
                    nameValue0 = ((long)bytes[nameBegin + 4] << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    break;
                }
                case 6: {
                    nameValue0 = ((long)bytes[nameBegin + 5] << 40) + (((long)bytes[nameBegin + 4] & 0xFFL) << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    break;
                }
                case 7: {
                    nameValue0 = ((long)bytes[nameBegin + 6] << 48) + (((long)bytes[nameBegin + 5] & 0xFFL) << 40) + (((long)bytes[nameBegin + 4] & 0xFFL) << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    break;
                }
                case 8: {
                    nameValue0 = ((long)bytes[nameBegin + 7] << 56) + (((long)bytes[nameBegin + 6] & 0xFFL) << 48) + (((long)bytes[nameBegin + 5] & 0xFFL) << 40) + (((long)bytes[nameBegin + 4] & 0xFFL) << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    break;
                }
                case 9: {
                    nameValue0 = bytes[nameBegin];
                    nameValue1 = ((long)bytes[nameBegin + 8] << 56) + (((long)bytes[nameBegin + 7] & 0xFFL) << 48) + (((long)bytes[nameBegin + 6] & 0xFFL) << 40) + (((long)bytes[nameBegin + 5] & 0xFFL) << 32) + (((long)bytes[nameBegin + 4] & 0xFFL) << 24) + (((long)bytes[nameBegin + 3] & 0xFFL) << 16) + (((long)bytes[nameBegin + 2] & 0xFFL) << 8) + ((long)bytes[nameBegin + 1] & 0xFFL);
                    break;
                }
                case 10: {
                    nameValue0 = (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                    nameValue1 = ((long)bytes[nameBegin + 9] << 56) + (((long)bytes[nameBegin + 8] & 0xFFL) << 48) + (((long)bytes[nameBegin + 7] & 0xFFL) << 40) + (((long)bytes[nameBegin + 6] & 0xFFL) << 32) + (((long)bytes[nameBegin + 5] & 0xFFL) << 24) + (((long)bytes[nameBegin + 4] & 0xFFL) << 16) + (((long)bytes[nameBegin + 3] & 0xFFL) << 8) + ((long)bytes[nameBegin + 2] & 0xFFL);
                    break;
                }
                case 11: {
                    nameValue0 = (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                    nameValue1 = ((long)bytes[nameBegin + 10] << 56) + (((long)bytes[nameBegin + 9] & 0xFFL) << 48) + (((long)bytes[nameBegin + 8] & 0xFFL) << 40) + (((long)bytes[nameBegin + 7] & 0xFFL) << 32) + (((long)bytes[nameBegin + 6] & 0xFFL) << 24) + (((long)bytes[nameBegin + 5] & 0xFFL) << 16) + (((long)bytes[nameBegin + 4] & 0xFFL) << 8) + ((long)bytes[nameBegin + 3] & 0xFFL);
                    break;
                }
                case 12: {
                    nameValue0 = (bytes[nameBegin + 3] << 24) + (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                    nameValue1 = ((long)bytes[nameBegin + 11] << 56) + (((long)bytes[nameBegin + 10] & 0xFFL) << 48) + (((long)bytes[nameBegin + 9] & 0xFFL) << 40) + (((long)bytes[nameBegin + 8] & 0xFFL) << 32) + (((long)bytes[nameBegin + 7] & 0xFFL) << 24) + (((long)bytes[nameBegin + 6] & 0xFFL) << 16) + (((long)bytes[nameBegin + 5] & 0xFFL) << 8) + ((long)bytes[nameBegin + 4] & 0xFFL);
                    break;
                }
                case 13: {
                    nameValue0 = ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                    nameValue1 = ((long)bytes[nameBegin + 12] << 56) + (((long)bytes[nameBegin + 11] & 0xFFL) << 48) + (((long)bytes[nameBegin + 10] & 0xFFL) << 40) + (((long)bytes[nameBegin + 9] & 0xFFL) << 32) + (((long)bytes[nameBegin + 8] & 0xFFL) << 24) + (((long)bytes[nameBegin + 7] & 0xFFL) << 16) + (((long)bytes[nameBegin + 6] & 0xFFL) << 8) + ((long)bytes[nameBegin + 5] & 0xFFL);
                    break;
                }
                case 14: {
                    nameValue0 = ((long)bytes[nameBegin + 5] << 40) + (((long)bytes[nameBegin + 4] & 0xFFL) << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    nameValue1 = ((long)bytes[nameBegin + 13] << 56) + (((long)bytes[nameBegin + 12] & 0xFFL) << 48) + (((long)bytes[nameBegin + 11] & 0xFFL) << 40) + (((long)bytes[nameBegin + 10] & 0xFFL) << 32) + (((long)bytes[nameBegin + 9] & 0xFFL) << 24) + (((long)bytes[nameBegin + 8] & 0xFFL) << 16) + (((long)bytes[nameBegin + 7] & 0xFFL) << 8) + ((long)bytes[nameBegin + 6] & 0xFFL);
                    break;
                }
                case 15: {
                    nameValue0 = ((long)bytes[nameBegin + 6] << 48) + (((long)bytes[nameBegin + 5] & 0xFFL) << 40) + (((long)bytes[nameBegin + 4] & 0xFFL) << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    nameValue1 = ((long)bytes[nameBegin + 14] << 56) + (((long)bytes[nameBegin + 13] & 0xFFL) << 48) + (((long)bytes[nameBegin + 12] & 0xFFL) << 40) + (((long)bytes[nameBegin + 11] & 0xFFL) << 32) + (((long)bytes[nameBegin + 10] & 0xFFL) << 24) + (((long)bytes[nameBegin + 9] & 0xFFL) << 16) + (((long)bytes[nameBegin + 8] & 0xFFL) << 8) + ((long)bytes[nameBegin + 7] & 0xFFL);
                    break;
                }
                case 16: {
                    nameValue0 = ((long)bytes[nameBegin + 7] << 56) + (((long)bytes[nameBegin + 6] & 0xFFL) << 48) + (((long)bytes[nameBegin + 5] & 0xFFL) << 40) + (((long)bytes[nameBegin + 4] & 0xFFL) << 32) + (((long)bytes[nameBegin + 3] & 0xFFL) << 24) + (((long)bytes[nameBegin + 2] & 0xFFL) << 16) + (((long)bytes[nameBegin + 1] & 0xFFL) << 8) + ((long)bytes[nameBegin] & 0xFFL);
                    nameValue1 = ((long)bytes[nameBegin + 15] << 56) + (((long)bytes[nameBegin + 14] & 0xFFL) << 48) + (((long)bytes[nameBegin + 13] & 0xFFL) << 40) + (((long)bytes[nameBegin + 12] & 0xFFL) << 32) + (((long)bytes[nameBegin + 11] & 0xFFL) << 24) + (((long)bytes[nameBegin + 10] & 0xFFL) << 16) + (((long)bytes[nameBegin + 9] & 0xFFL) << 8) + ((long)bytes[nameBegin + 8] & 0xFFL);
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    long nameValue01 = nameValue0 ^ nameValue1;
                    int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        char[] chars = new char[length];
                        for (int i2 = 0; i2 < length; ++i2) {
                            chars[i2] = (char)(bytes[nameBegin + i2] & 0xFF);
                        }
                        String name = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                    JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        char[] chars = new char[length];
                        for (int i3 = 0; i3 < length; ++i3) {
                            chars[i3] = (char)(bytes[nameBegin + i3] & 0xFF);
                        }
                        String name = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
        }
        return this.getFieldName();
    }

    @Override
    protected final void readString0() {
        String str;
        byte[] bytes = this.bytes;
        char quote = this.ch;
        int start = this.offset;
        int offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = bytes[offset]) == 92) {
                this.valueEscape = true;
                offset += (c = bytes[offset + 1]) == 117 ? 6 : (c == 120 ? 4 : 2);
            } else {
                if (c == quote) break;
                ++offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = (char)(bytes[offset] & 0xFF)) == '\\') {
                    c = (char)bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++offset;
                ++i2;
            }
            str = new String(chars);
        } else if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            byte[] buf = Arrays.copyOfRange(bytes, start, offset);
            str = JDKUtils.STRING_CREATOR_JDK11.apply(buf, JDKUtils.LATIN1);
        } else {
            str = new String(bytes, start, offset - start, StandardCharsets.ISO_8859_1);
        }
        byte ch = bytes[++offset];
        while (ch > 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = bytes[++offset];
        }
        this.offset = offset + 1;
        this.comma = ch == 44;
        if (this.comma) {
            this.next();
        } else {
            this.ch = (char)ch;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            int ch;
            String str;
            int valueLength;
            byte by;
            int offset;
            byte[] bytes = this.bytes;
            byte quote = (byte)this.ch;
            int slash = 92;
            int start = offset = this.offset;
            int end = this.end;
            boolean valueEscape = false;
            int i = 0;
            byte c0 = 0;
            byte c1 = 0;
            boolean bl = false;
            boolean quoted = false;
            int upperBound = offset + (end - offset & 0xFFFFFFFC);
            while (offset < upperBound) {
                c0 = bytes[offset];
                c1 = bytes[offset + 1];
                by = bytes[offset + 2];
                byte c3 = bytes[offset + 3];
                if (c0 == 92 || c1 == 92 || by == 92 || c3 == 92) break;
                if (c0 == quote || c1 == quote || by == quote || c3 == quote) {
                    quoted = true;
                    break;
                }
                offset += 4;
                i += 4;
            }
            if (quoted) {
                if (c0 != quote) {
                    if (c1 == quote) {
                        ++offset;
                        ++i;
                    } else if (by == quote) {
                        offset += 2;
                        i += 2;
                    } else {
                        offset += 3;
                        i += 3;
                    }
                }
                valueLength = i;
            } else {
                while (true) {
                    if (offset >= end) {
                        throw new JSONException("invalid escape character EOI");
                    }
                    byte c = bytes[offset];
                    if (c == 92) {
                        valueEscape = true;
                        offset += (c = bytes[offset + 1]) == 117 ? 6 : (c == 120 ? 4 : 2);
                    } else {
                        if (c == quote) {
                            valueLength = i;
                            break;
                        }
                        ++offset;
                    }
                    ++i;
                }
            }
            if (valueEscape) {
                char[] buf = new char[valueLength];
                offset = start;
                int i2 = 0;
                while (true) {
                    byte by2;
                    if ((by2 = (byte)(bytes[offset] & 0xFF)) == 92) {
                        by2 = (char)bytes[++offset];
                        switch (by2) {
                            case 117: {
                                by2 = (byte)JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                                offset += 4;
                                break;
                            }
                            case 120: {
                                by2 = (byte)JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                                offset += 2;
                                break;
                            }
                            case 34: 
                            case 92: {
                                break;
                            }
                            case 98: {
                                by2 = 8;
                                break;
                            }
                            case 116: {
                                by2 = 9;
                                break;
                            }
                            case 110: {
                                by2 = 10;
                                break;
                            }
                            case 102: {
                                by2 = 12;
                                break;
                            }
                            case 114: {
                                by2 = 13;
                                break;
                            }
                            default: {
                                by2 = (byte)this.char1(by2);
                                break;
                            }
                        }
                    } else if (by2 == quote) break;
                    buf[i2] = by2;
                    ++offset;
                    ++i2;
                }
                str = new String(buf);
            } else {
                str = this.str != null ? this.str.substring(start, offset) : (JDKUtils.STRING_CREATOR_JDK11 != null ? JDKUtils.STRING_CREATOR_JDK11.apply(Arrays.copyOfRange(bytes, start, offset), JDKUtils.LATIN1) : (JDKUtils.ANDROID ? this.getLatin1String(start, offset - start) : new String(bytes, start, offset - start, StandardCharsets.ISO_8859_1)));
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            int n = ch = ++offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.comma = ch == 44;
            if (this.comma) {
                int n2 = ch = offset == end ? 26 : bytes[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? 26 : bytes[offset++];
                }
            }
            this.ch = (char)(ch & 0xFF);
            this.offset = offset;
            return str;
        }
        return this.readStringNotMatch();
    }
}

