/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.translation.results;

import com.alibaba.dashscope.audio.asr.translation.TranslationRecognizerUsage;
import com.alibaba.dashscope.audio.asr.translation.results.TranscriptionResult;
import com.alibaba.dashscope.audio.asr.translation.results.TranslationResult;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class TranslationRecognizerResult {
    @SerializedName(value="request_id")
    private String requestId;
    private TranslationResult translationResult;
    private TranscriptionResult transcriptionResult;
    private TranslationRecognizerUsage usage;
    private boolean isSentenceEnd = false;
    private boolean isCompleteResult = false;

    public static TranslationRecognizerResult fromDashScopeResult(DashScopeResult dashScopeResult) throws ApiException {
        JsonObject jsonDashScopeResult;
        TranslationRecognizerResult result = new TranslationRecognizerResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), TranslationRecognizerUsage.class));
        }
        if ((jsonDashScopeResult = (JsonObject)dashScopeResult.getOutput()).has("transcription") || jsonDashScopeResult.has("translations")) {
            JsonObject transcription_json = null;
            JsonArray translations_json = null;
            if (jsonDashScopeResult.has("transcription")) {
                transcription_json = jsonDashScopeResult.getAsJsonObject("transcription");
                result.transcriptionResult = TranscriptionResult.from(transcription_json);
            }
            if (jsonDashScopeResult.has("translations")) {
                translations_json = jsonDashScopeResult.getAsJsonArray("translations");
                result.translationResult = TranslationResult.from(translations_json);
            }
            if (translations_json == null && transcription_json == null) {
                result.isCompleteResult = true;
            } else {
                result.isSentenceEnd = result.transcriptionResult != null && result.transcriptionResult.isSentenceEnd() ? true : result.translationResult != null && result.translationResult.isSentenceEnd();
            }
        } else {
            result.isCompleteResult = true;
            result.isSentenceEnd = false;
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public TranslationResult getTranslationResult() {
        return this.translationResult;
    }

    public TranscriptionResult getTranscriptionResult() {
        return this.transcriptionResult;
    }

    public TranslationRecognizerUsage getUsage() {
        return this.usage;
    }

    public boolean isSentenceEnd() {
        return this.isSentenceEnd;
    }

    public boolean isCompleteResult() {
        return this.isCompleteResult;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setTranslationResult(TranslationResult translationResult) {
        this.translationResult = translationResult;
    }

    public void setTranscriptionResult(TranscriptionResult transcriptionResult) {
        this.transcriptionResult = transcriptionResult;
    }

    public void setUsage(TranslationRecognizerUsage usage) {
        this.usage = usage;
    }

    public void setSentenceEnd(boolean isSentenceEnd) {
        this.isSentenceEnd = isSentenceEnd;
    }

    public void setCompleteResult(boolean isCompleteResult) {
        this.isCompleteResult = isCompleteResult;
    }

    public String toString() {
        return "TranslationRecognizerResult(requestId=" + this.getRequestId() + ", translationResult=" + this.getTranslationResult() + ", transcriptionResult=" + this.getTranscriptionResult() + ", usage=" + this.getUsage() + ", isSentenceEnd=" + this.isSentenceEnd() + ", isCompleteResult=" + this.isCompleteResult() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationRecognizerResult)) {
            return false;
        }
        TranslationRecognizerResult other = (TranslationRecognizerResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSentenceEnd() != other.isSentenceEnd()) {
            return false;
        }
        if (this.isCompleteResult() != other.isCompleteResult()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        TranslationResult this$translationResult = this.getTranslationResult();
        TranslationResult other$translationResult = other.getTranslationResult();
        if (this$translationResult == null ? other$translationResult != null : !((Object)this$translationResult).equals(other$translationResult)) {
            return false;
        }
        TranscriptionResult this$transcriptionResult = this.getTranscriptionResult();
        TranscriptionResult other$transcriptionResult = other.getTranscriptionResult();
        if (this$transcriptionResult == null ? other$transcriptionResult != null : !((Object)this$transcriptionResult).equals(other$transcriptionResult)) {
            return false;
        }
        TranslationRecognizerUsage this$usage = this.getUsage();
        TranslationRecognizerUsage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationRecognizerResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSentenceEnd() ? 79 : 97);
        result = result * 59 + (this.isCompleteResult() ? 79 : 97);
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        TranslationResult $translationResult = this.getTranslationResult();
        result = result * 59 + ($translationResult == null ? 43 : ((Object)$translationResult).hashCode());
        TranscriptionResult $transcriptionResult = this.getTranscriptionResult();
        result = result * 59 + ($transcriptionResult == null ? 43 : ((Object)$transcriptionResult).hashCode());
        TranslationRecognizerUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }
}

