/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLStructExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefault;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLNotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryCharExpr;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryDateTimeExpr;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQueryLexer;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQuerySelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class BigQueryExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;
    static final long SAFE_CAST;

    public BigQueryExprParser(String sql) {
        this(new BigQueryLexer(sql, new SQLParserFeature[0]));
        this.lexer.nextToken();
    }

    public BigQueryExprParser(String sql, SQLParserFeature ... features) {
        this(new BigQueryLexer(sql, features));
        this.lexer.nextToken();
    }

    public BigQueryExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.bigquery;
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            long hashCode64 = identifierExpr.hashCode64();
            if (hashCode64 == FnvHash.Constants.STRUCT && acceptLPAREN) {
                SQLStructExpr struct = this.struct();
                if (this.lexer.isKeepSourceLocation()) {
                    struct.setSource(identifierExpr.getSourceLine(), identifierExpr.getSourceColumn());
                }
                return struct;
            }
            if (hashCode64 == SAFE_CAST && acceptLPAREN) {
                SQLCastExpr castExpr = new SQLCastExpr();
                this.lexer.nextToken();
                castExpr.setExpr(this.expr());
                castExpr.setTry(true);
                this.accept(Token.AS);
                castExpr.setDataType(this.parseDataType());
                this.accept(Token.RPAREN);
                return castExpr;
            }
        }
        return super.methodRest(expr, acceptLPAREN);
    }

    private SQLStructExpr struct() {
        SQLStructExpr structExpr = new SQLStructExpr();
        this.accept(Token.LPAREN);
        this.aliasedItems(structExpr.getItems(), structExpr);
        this.accept(Token.RPAREN);
        return structExpr;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
            this.parseAssignItem(column.getColProperties(), (SQLObject)column);
        }
        return super.parseColumnRest(column);
    }

    @Override
    protected SQLStructDataType parseDataTypeStruct() {
        this.acceptIdentifier("STRUCT");
        return this.parseDataTypeStruct0();
    }

    protected SQLStructDataType parseDataTypeStruct0() {
        SQLStructDataType struct = new SQLStructDataType(this.dbType);
        this.accept(Token.LT);
        while (true) {
            SQLName name = this.name();
            SQLDataType dataType = this.parseDataType();
            SQLStructDataType.Field field = struct.addField(name, dataType);
            this.parseFieldConstraints(field);
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.OPTIONS)) {
                this.parseAssignItem(field.getOptions(), (SQLObject)field);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.GTGTGT) {
            this.lexer.setToken(Token.GTGT);
        } else if (this.lexer.token() == Token.GTGT) {
            this.lexer.setToken(Token.GT);
        } else {
            this.accept(Token.GT);
        }
        return struct;
    }

    private void parseFieldConstraints(SQLStructDataType.Field field) {
        switch (this.lexer.token()) {
            case DEFAULT: {
                field.addConstraint(this.parseColumnDefault());
                break;
            }
            case NOT: {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                SQLNotNullConstraint notNull = new SQLNotNullConstraint();
                field.addConstraint(notNull);
                break;
            }
            case PRIMARY: {
                SQLColumnPrimaryKey pk = new SQLColumnPrimaryKey();
                this.lexer.nextToken();
                this.accept(Token.KEY);
                this.accept(Token.NOT);
                this.acceptIdentifier("ENFORCED");
                pk.setNotEnforced(true);
                field.addConstraint(pk);
                break;
            }
            case REFERENCES: {
                SQLColumnReference ref = this.parseReference();
                this.accept(Token.NOT);
                this.acceptIdentifier("ENFORCED");
                ref.setNotEnforced(true);
                field.addConstraint(ref);
                break;
            }
        }
    }

    private SQLColumnDefault parseColumnDefault() {
        SQLColumnDefault columnDefault = new SQLColumnDefault();
        this.accept(Token.DEFAULT);
        if (this.lexer.token() == Token.LPAREN) {
            while (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
            }
            columnDefault.setDefaultExpr(this.primary());
            while (this.lexer.token() == Token.RPAREN) {
                this.accept(Token.RPAREN);
            }
        } else {
            columnDefault.setDefaultExpr(this.primary());
        }
        return columnDefault;
    }

    @Override
    public void parsePrimaryKeyRest(SQLPrimaryKeyImpl primaryKey) {
        this.accept(Token.NOT);
        this.acceptIdentifier("ENFORCED");
        primaryKey.setNotEnforced(true);
        super.parsePrimaryKeyRest(primaryKey);
    }

    @Override
    protected void parseForeignKeyRest(SQLForeignKeyImpl foreignKey) {
        this.accept(Token.NOT);
        this.acceptIdentifier("ENFORCED");
        foreignKey.setNotEnforced(true);
        super.parseForeignKeyRest(foreignKey);
    }

    @Override
    public SQLExpr primary() {
        if (this.lexer.nextIf(Token.DOT)) {
            String name = this.lexer.stringVal();
            SQLExpr expr = new SQLPropertyExpr((SQLExpr)null, name);
            this.lexer.nextToken();
            if (this.lexer.nextIf(Token.DOT)) {
                expr = this.dotRest(expr);
            }
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.WITH) {
            return this.primaryRest(this.parseQueryExpr());
        }
        return super.primary();
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        SQLIdentifierExpr identifierExpr;
        long hashCode64;
        SQLPropertyExpr propertyExpr;
        SQLExpr owner;
        if (expr instanceof SQLPropertyExpr && (owner = (propertyExpr = (SQLPropertyExpr)expr).getOwner()) instanceof SQLIdentifierExpr && ((hashCode64 = (identifierExpr = (SQLIdentifierExpr)owner).hashCode64()) == FnvHash.Constants.DATE || hashCode64 == FnvHash.Constants.DATETIME || hashCode64 == FnvHash.Constants.TIMESTAMP)) {
            String name = null;
            if (this.lexer.nextIf(Token.DOT)) {
                name = this.lexer.stringVal();
                this.lexer.nextToken();
            }
            SQLExpr timeZone = null;
            if (this.lexer.nextIf(Token.COMMA)) {
                timeZone = this.primary();
            }
            this.accept(Token.RPAREN);
            SQLMethodInvokeExpr func = new SQLMethodInvokeExpr((SQLIdentifierExpr)owner);
            func.addArgument(name != null ? new SQLPropertyExpr(new SQLIdentifierExpr(propertyExpr.getName()), name) : new SQLIdentifierExpr(identifierExpr.getName()));
            if (timeZone != null) {
                func.addArgument(timeZone);
            }
            expr = func;
        }
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr2 = (SQLIdentifierExpr)expr;
            String ident = identifierExpr2.getName();
            if (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                boolean isSpace;
                boolean isAlias;
                boolean bl = isAlias = this.lexer.token() == Token.LITERAL_ALIAS;
                if (ident.equalsIgnoreCase("b") || ident.equalsIgnoreCase("r")) {
                    isSpace = false;
                } else if (ident.equalsIgnoreCase("json")) {
                    isSpace = true;
                } else {
                    throw new ParserException("Not supported prefix: " + ident + " for bigquery");
                }
                String charValue = this.lexer.stringVal();
                this.lexer.nextToken();
                expr = new BigQueryCharExpr(charValue, ident, isSpace, isAlias);
            }
        }
        Lexer.SavePoint savePoint = this.lexer.markOut();
        if (this.lexer.identifierEquals(FnvHash.Constants.AT)) {
            this.lexer.nextToken();
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.TIME)) {
                this.acceptIdentifier("ZONE");
                SQLExpr timeZone = this.primary();
                expr = new BigQueryDateTimeExpr(expr, timeZone);
            } else {
                this.lexer.reset(savePoint);
            }
        }
        return super.primaryRest(expr);
    }

    @Override
    public SQLDataType parseDataType() {
        if (this.lexer.nextIf(Token.ANY)) {
            this.acceptIdentifier("TYPE");
            return new SQLDataTypeImpl("ANY TYPE");
        }
        return this.parseDataType(true);
    }

    @Override
    protected SQLExpr dotRest(SQLExpr expr) {
        return super.dotRest(expr);
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new BigQuerySelectParser(this, null);
    }

    @Override
    public SQLExpr exprRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LT && expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameEquals("STRUCT")) {
            SQLStructExpr structExpr = new SQLStructExpr();
            structExpr.setDataType(this.parseDataTypeStruct0());
            this.accept(Token.LPAREN);
            this.aliasedItems(structExpr.getItems(), structExpr);
            this.accept(Token.RPAREN);
            expr = structExpr;
        }
        return super.exprRest(expr);
    }

    @Override
    protected SQLCastExpr parseCastFormat(SQLCastExpr cast) {
        if (this.lexer.nextIfIdentifier("FORMAT")) {
            cast.setFormat(this.expr());
        }
        return cast;
    }

    @Override
    protected SQLExpr primaryIdentifierRest(long hash_lower, String ident) {
        if (ident.length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
            return this.topPropertyExpr(ident);
        }
        return super.primaryIdentifierRest(hash_lower, ident);
    }

    @Override
    public SQLName nameRest(SQLName name) {
        String ident;
        if (name instanceof SQLIdentifierExpr && (ident = ((SQLIdentifierExpr)name).getName()).length() > 3 && ident.charAt(0) == '`' && ident.charAt(ident.length() - 1) == '`' && ident.indexOf(46) != -1) {
            return this.topPropertyExpr(ident);
        }
        return super.nameRest(name);
    }

    static {
        String[] strings = new String[]{"ANY_VALUE", "ARRAY_AGG", "ARRAY_CONCAT_AGG", "AVG", "BIT_AND", "BIT_OR", "BIT_XOR", "COUNT", "COUNTIF", "FIRST_VALUE", "GROUPING", "LAST_VALUE", "LOGICAL_AND", "LOGICAL_OR", "MAX", "MAX_BY", "MIN", "MIN_BY", "STRING_AGG", "SUM"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            BigQueryExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
        SAFE_CAST = FnvHash.fnv1a_64_lower("SAFE_CAST");
    }
}

