/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.parser.DialectFeature;
import com.alibaba.druid.sql.parser.Keywords;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import java.util.HashMap;

public class HiveLexer
extends Lexer {
    @Override
    protected Keywords loadKeywords() {
        HashMap<String, Token> map = new HashMap<String, Token>();
        map.putAll(Keywords.DEFAULT_KEYWORDS.getKeywords());
        map.put("OF", Token.OF);
        map.put("CONCAT", Token.CONCAT);
        map.put("CONTINUE", Token.CONTINUE);
        map.put("MERGE", Token.MERGE);
        map.put("MATCHED", Token.MATCHED);
        map.put("USING", Token.USING);
        map.put("ROW", Token.ROW);
        map.put("LIMIT", Token.LIMIT);
        map.put("PARTITIONED", Token.PARTITIONED);
        map.put("PARTITION", Token.PARTITION);
        map.put("OVERWRITE", Token.OVERWRITE);
        map.put("IF", Token.IF);
        map.put("TRUE", Token.TRUE);
        map.put("FALSE", Token.FALSE);
        map.put("RLIKE", Token.RLIKE);
        map.put("CONSTRAINT", Token.CONSTRAINT);
        map.put("DIV", Token.DIV);
        return new Keywords(map);
    }

    public HiveLexer(String input) {
        super(input);
        this.skipComment = true;
        this.keepComments = true;
        this.dbType = DbType.hive;
        this.features |= SQLParserFeature.SupportUnicodeCodePoint.mask;
    }

    public HiveLexer(String input, SQLParserFeature ... features) {
        super(input);
        this.dbType = DbType.hive;
        this.skipComment = true;
        this.keepComments = true;
        this.features |= SQLParserFeature.SupportUnicodeCodePoint.mask;
        for (SQLParserFeature feature : features) {
            this.config(feature, true);
        }
    }

    @Override
    protected void scanString() {
        boolean hasSpecial = false;
        int startIndex = this.pos + 1;
        int endIndex = -1;
        for (int i = startIndex; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                hasSpecial = true;
                continue;
            }
            if (ch != '\'') continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            throw new ParserException("unclosed str. " + this.info());
        }
        String stringVal = this.token == Token.AS ? this.text.substring(this.pos, endIndex + 1) : (startIndex == endIndex ? "" : this.text.substring(startIndex, endIndex));
        if (!hasSpecial) {
            this.stringVal = stringVal;
            int pos = endIndex + 1;
            char ch = this.charAt(pos);
            if (ch != '\'') {
                this.pos = pos;
                this.ch = ch;
                this.token = Token.LITERAL_CHARS;
                return;
            }
        }
        this.mark = this.pos;
        hasSpecial = false;
        block15: while (true) {
            if (this.isEOF()) {
                this.lexError("unclosed.str.lit", new Object[0]);
                return;
            }
            this.ch = this.charAt(++this.pos);
            if (this.ch == '\\') {
                this.scanChar();
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                switch (this.ch) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block15;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block15;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block15;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block15;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block15;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block15;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block15;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block15;
                    }
                    case 'Z': {
                        this.putChar('\u001a');
                        continue block15;
                    }
                    case '%': {
                        this.putChar('%');
                        continue block15;
                    }
                    case '_': {
                        this.putChar('_');
                        continue block15;
                    }
                    case 'u': {
                        if ((this.features & SQLParserFeature.SupportUnicodeCodePoint.mask) != 0) {
                            char c1 = this.charAt(++this.pos);
                            char c2 = this.charAt(++this.pos);
                            char c3 = this.charAt(++this.pos);
                            char c4 = this.charAt(++this.pos);
                            int intVal = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                            this.putChar((char)intVal);
                            continue block15;
                        }
                        this.putChar(this.ch);
                        continue block15;
                    }
                }
                this.putChar(this.ch);
                continue;
            }
            if (this.ch == '\'') {
                this.scanChar();
                if (this.ch != '\'') break;
                if (!hasSpecial) {
                    this.initBuff(this.bufPos);
                    this.arraycopy(this.mark + 1, this.buf, 0, this.bufPos);
                    hasSpecial = true;
                }
                this.putChar('\'');
                continue;
            }
            if (!hasSpecial) {
                ++this.bufPos;
                continue;
            }
            if (this.bufPos == this.buf.length) {
                this.putChar(this.ch);
                continue;
            }
            this.buf[this.bufPos++] = this.ch;
        }
        this.token = Token.LITERAL_CHARS;
        this.stringVal = !hasSpecial ? this.subString(this.mark + 1, this.bufPos) : new String(this.buf, 0, this.bufPos);
    }

    @Override
    public void scanComment() {
        if (this.ch != '/' && this.ch != '-') {
            throw new IllegalStateException();
        }
        Token lastToken = this.token;
        this.mark = this.pos;
        this.bufPos = 0;
        this.scanChar();
        if (this.ch == ' ') {
            this.mark = this.pos;
            this.bufPos = 0;
            this.scanChar();
            if (this.dialectFeatureEnabled(DialectFeature.LexerFeature.ScanHiveCommentDoubleSpace) && this.ch == ' ') {
                this.mark = this.pos;
                this.bufPos = 0;
                this.scanChar();
            }
        }
        if (this.ch == '*') {
            this.scanChar();
            ++this.bufPos;
            while (this.ch == ' ') {
                this.scanChar();
                ++this.bufPos;
            }
            boolean isHint = false;
            int startHintSp = this.bufPos + 1;
            if (this.ch == '+') {
                isHint = true;
                this.scanChar();
                ++this.bufPos;
            }
            while (true) {
                if (this.ch == '*') {
                    if (this.charAt(this.pos + 1) == '/') {
                        this.bufPos += 2;
                        this.scanChar();
                        this.scanChar();
                        break;
                    }
                    if (CharTypes.isWhitespace(this.charAt(this.pos + 1))) {
                        int i;
                        for (i = 2; i < 0x100000 && CharTypes.isWhitespace(this.charAt(this.pos + i)); ++i) {
                        }
                        if (this.charAt(this.pos + i) == '/') {
                            this.bufPos += 2;
                            this.pos += i + 1;
                            this.ch = this.charAt(this.pos);
                            break;
                        }
                    }
                }
                this.scanChar();
                if (this.ch == '\u001a') break;
                ++this.bufPos;
            }
            if (isHint) {
                this.stringVal = this.subString(this.mark + startHintSp, this.bufPos - startHintSp - 1);
                this.token = Token.HINT;
            } else {
                this.stringVal = this.subString(this.mark, this.bufPos + 1);
                this.token = Token.MULTI_LINE_COMMENT;
                ++this.commentCount;
                if (this.keepComments) {
                    this.addComment(this.stringVal);
                }
            }
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            if (this.token != Token.HINT && !this.isAllowComment()) {
                throw new NotAllowCommentException();
            }
            return;
        }
        if (!this.isAllowComment()) {
            throw new NotAllowCommentException();
        }
        if (this.ch == '/' || this.ch == '-') {
            this.scanChar();
            ++this.bufPos;
            while (true) {
                if (this.ch == '\r') {
                    if (this.charAt(this.pos + 1) == '\n') {
                        ++this.line;
                        this.bufPos += 2;
                        this.scanChar();
                        break;
                    }
                    ++this.bufPos;
                    break;
                }
                if (this.ch == '\u001a' && this.pos >= this.text.length()) break;
                if (this.ch == '\n') {
                    ++this.line;
                    this.scanChar();
                    ++this.bufPos;
                    break;
                }
                this.scanChar();
                ++this.bufPos;
            }
            this.stringVal = this.subString(this.mark, this.ch != '\u001a' ? this.bufPos : this.bufPos + 1);
            this.token = Token.LINE_COMMENT;
            ++this.commentCount;
            if (this.keepComments) {
                this.addComment(this.stringVal);
            }
            this.endOfComment = this.isEOF();
            if (this.commentHandler != null && this.commentHandler.handle(lastToken, this.stringVal)) {
                return;
            }
            return;
        }
    }

    @Override
    protected void initDialectFeature() {
        super.initDialectFeature();
        this.dialectFeature.configFeature(DialectFeature.LexerFeature.ScanSQLTypeWithFrom, DialectFeature.LexerFeature.NextTokenColon, DialectFeature.LexerFeature.ScanAliasU, DialectFeature.ParserFeature.JoinRightTableFrom, DialectFeature.ParserFeature.GroupByAll, DialectFeature.ParserFeature.SQLDateExpr, DialectFeature.ParserFeature.ParseAssignItemRparenCommaSetReturn, DialectFeature.ParserFeature.TableAliasLock, DialectFeature.ParserFeature.TableAliasPartition, DialectFeature.ParserFeature.AsSkip, DialectFeature.ParserFeature.AsSequence, DialectFeature.ParserFeature.AsDatabase, DialectFeature.ParserFeature.AsDefault);
        this.dialectFeature.unconfigFeature(DialectFeature.ParserFeature.PrimaryBangBangSupport);
    }
}

