/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.impala.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.druid.sql.dialect.impala.parser.ImpalaExprParser;
import com.alibaba.druid.sql.dialect.impala.stmt.ImpalaCreateTableStatement;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class ImpalaCreateTableParser
extends HiveCreateTableParser {
    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new ImpalaCreateTableParser(this.exprParser);
    }

    public ImpalaCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.impala;
    }

    public ImpalaCreateTableParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.impala;
    }

    @Override
    protected ImpalaCreateTableStatement newCreateStatement() {
        return new ImpalaCreateTableStatement();
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement createTable) {
        SQLSelect select;
        SQLExpr comment;
        ImpalaCreateTableStatement stmt = (ImpalaCreateTableStatement)createTable;
        if (this.lexer.nextIf(Token.PARTITIONED)) {
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                SQLColumnDefinition column = this.exprParser.parseColumn();
                stmt.addPartitionColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORT)) {
            this.parseSortedBy(stmt);
        }
        SQLPartitionBy partitionClause = this.parsePartitionBy();
        stmt.setPartitionBy(partitionClause);
        if (this.lexer.nextIf(Token.COMMENT)) {
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.token() == Token.ROW || this.lexer.identifierEquals(FnvHash.Constants.ROW)) {
            this.parseRowFormat(stmt);
        }
        if (Token.LBRACKET.equals((Object)this.lexer.token())) {
            stmt.setLbracketUse(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            SQLName name = this.exprParser.name();
            stmt.setStoredAs(name);
        }
        if (Token.RBRACKET.equals((Object)this.lexer.token())) {
            stmt.setRbracketUse(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.primary();
            stmt.setLocation(location);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.UNCACHED)) {
            this.lexer.nextToken();
            stmt.setUnCached(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CACHED)) {
            this.lexer.nextToken();
            this.accept(Token.IN);
            SQLExpr poolName = this.exprParser.primary();
            stmt.setCachedPool(poolName);
            if (this.lexer.hashLCase() == FnvHash.Constants.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("REPLICATION");
                this.accept(Token.EQ);
                stmt.setCachedReplication(this.exprParser.parseIntValue());
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.parseOptions(stmt);
        }
        if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.AS) {
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
            }
            select = this.createSQLSelectParser().select();
            stmt.setSelect(select);
        }
        if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.AS) {
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
            }
            select = this.createSQLSelectParser().select();
            stmt.setSelect(select);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            Lexer.SavePoint mark = this.lexer.mark();
            if (this.lexer.token() == Token.SELECT) {
                stmt.setLikeQuery(true);
                SQLSelect select2 = this.createSQLSelectParser().select();
                stmt.setSelect(select2);
            } else {
                this.lexer.reset(mark);
                if (this.lexer.identifierEquals(FnvHash.Constants.MAPPING)) {
                    SQLExpr like = this.exprParser.primary();
                    stmt.setLike(new SQLExprTableSource(like));
                } else {
                    SQLName name = this.exprParser.name();
                    stmt.setLike(name);
                }
            }
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING) || this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            SQLExpr using = this.exprParser.expr();
            stmt.setUsing(using);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
            this.parseOptions(stmt);
        }
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        if (this.lexer.nextIf(Token.PARTITION)) {
            this.accept(Token.BY);
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.HASH)) {
                SQLPartitionByHash hashPartition = new SQLPartitionByHash();
                if (this.lexer.nextIf(Token.LPAREN)) {
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("expect identifier. " + this.lexer.info());
                    }
                    while (true) {
                        hashPartition.addColumn(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    this.acceptIdentifier("PARTITIONS");
                    hashPartition.setPartitionsCount(this.acceptInteger());
                    return hashPartition;
                }
                this.acceptIdentifier("PARTITIONS");
                int numPartitions = this.acceptInteger();
                hashPartition.setPartitionsCount(numPartitions);
                return hashPartition;
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.RANGE)) {
                return this.partitionByRange();
            }
        }
        return null;
    }

    private SQLPartitionByRange partitionByRange() {
        SQLPartitionByRange rangePartition = new SQLPartitionByRange();
        this.accept(Token.LPAREN);
        while (true) {
            rangePartition.addColumn(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.accept(Token.LPAREN);
        while (this.lexer.token() != Token.RPAREN) {
            rangePartition.addPartition(this.getExprParser().parsePartition());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return rangePartition;
    }

    @Override
    public ImpalaExprParser getExprParser() {
        return (ImpalaExprParser)this.exprParser;
    }
}

