/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.utils;

import com.gccloud.common.utils.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class ElasticsearchDsService {
    public static List<Map<String, Object>> query(String host, int port, String username, String password, String uri, String dsl) throws IOException {
        RestClient restClient;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, "http")}).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider)).build();
        } else {
            restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, "http")}).build();
        }
        Request request = new Request("POST", uri);
        request.setJsonEntity(dsl);
        Response response = restClient.performRequest(request);
        if (response.getStatusLine().getStatusCode() != 200) {
            return result;
        }
        HttpEntity entity = response.getEntity();
        StringBuilder json = new StringBuilder();
        InputStream content = entity.getContent();
        byte[] bytes = new byte[1024];
        int len = 0;
        while ((len = content.read(bytes)) != -1) {
            json.append(new String(bytes, 0, len));
        }
        JSONObject jsonObject = JSON.parseObject((String)json.toString());
        JSONObject hits = jsonObject.getJSONObject("hits");
        if (hits == null) {
            return result;
        }
        JSONArray jsonArray = hits.getJSONArray("hits");
        if (jsonArray == null) {
            return result;
        }
        for (Object o : jsonArray) {
            JSONObject source = ((JSONObject)o).getJSONObject("_source");
            result.add(source.toMap());
        }
        return result;
    }
}

