/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.cache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;
import org.beetl.core.cache.ContextBuffer;
import org.jetbrains.annotations.NotNull;

public class ContextLocalBuffers {
    private final ArrayBlockingQueue<ContextBuffer> queue;
    private final int bufferMax;
    ThreadLocal<ContextBuffer> local = ThreadLocal.withInitial(new Supplier<ContextBuffer>(){

        @Override
        public ContextBuffer get() {
            return new ContextBuffer(256);
        }
    });

    public ContextLocalBuffers(int num, int bufferMax) {
        if (num != 0) {
            this.bufferMax = bufferMax;
            this.queue = new ArrayBlockingQueue(num);
            for (int i = 0; i < num; ++i) {
                ContextBuffer buffer = new ContextBuffer(bufferMax, true);
                this.queue.add(buffer);
            }
        } else {
            this.queue = null;
            this.bufferMax = bufferMax;
        }
    }

    @NotNull
    public ContextBuffer getContextLocalBuffer() {
        if (this.queue == null) {
            return this.local.get();
        }
        ContextBuffer buffer = this.queue.poll();
        return buffer == null ? new ContextBuffer(this.bufferMax, false) : buffer;
    }

    public void putContextLocalBuffer(@NotNull ContextBuffer buffer) {
        if (!buffer.inner) {
            return;
        }
        if (this.queue != null) {
            this.queue.add(buffer);
        }
    }
}

