/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder;

import com.ly.doc.builder.DocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import java.util.Objects;

public class AdocDocBuilder {
    private static final String API_EXTENSION = "Api.adoc";
    private static final String INDEX_DOC = "index.adoc";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        AdocDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        config.setParamsDataToTree(false);
        config.setAdoc(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder).getApiDatas();
        if (config.isAllInOne()) {
            String docName = builderTemplate.allInOneDocName(config, INDEX_DOC, ".adoc");
            apiDocList = docBuildTemplate.handleApiGroup(apiDocList, config);
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.adoc", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.adoc", "ErrorCodeList.adoc", javaProjectBuilder);
            builderTemplate.buildDirectoryDataDoc(config, javaProjectBuilder, "Dictionary.md", "Dictionary.adoc");
        }
    }
}

