/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder;

import com.ly.doc.constants.DocGlobalConstants;
import com.ly.doc.constants.DocLanguage;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.constants.TemplateVariable;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDocDict;
import com.ly.doc.model.ApiErrorCode;
import com.ly.doc.model.RevisionLog;
import com.ly.doc.utils.BeetlTemplateUtil;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.Resource;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;

public class BaseDocBuilderTemplate {
    public static long NOW = System.currentTimeMillis();

    public void checkAndInit(ApiConfig config, boolean checkOutPath) {
        this.checkAndInitForGetApiData(config);
        if (StringUtil.isEmpty((String)config.getOutPath()) && checkOutPath) {
            throw new RuntimeException("doc output path can't be null or empty");
        }
        ApiConfig.setInstance(config);
    }

    public void checkAndInitForGetApiData(ApiConfig config) {
        if (Objects.isNull(config)) {
            throw new NullPointerException("ApiConfig can't be null");
        }
        System.setProperty("randomMock", String.valueOf(config.isRandomMock()));
        if (Objects.nonNull((Object)config.getLanguage())) {
            System.setProperty("smart-doc_language", config.getLanguage().getCode());
        } else {
            config.setLanguage(DocLanguage.CHINESE);
            System.setProperty("smart-doc_language", DocLanguage.CHINESE.getCode());
        }
        if (Objects.isNull(config.getRevisionLogs())) {
            String strTime = DateTimeUtil.long2Str((long)NOW, (String)"yyyy-MM-dd HH:mm:ss");
            config.setRevisionLogs(RevisionLog.builder().setRevisionTime(strTime).setAuthor("@" + System.getProperty("user.name")).setVersion("v" + strTime).setRemarks("Created by smart-doc").setStatus("auto"));
        }
        if (StringUtil.isEmpty((String)config.getFramework())) {
            config.setFramework(FrameworkEnum.SPRING.getFramework());
        }
        if (StringUtil.isEmpty((String)config.getAuthor())) {
            config.setAuthor(System.getProperty("user.name"));
        }
        if (Objects.isNull(config.getReplace())) {
            config.setReplace(Boolean.TRUE);
        }
    }

    public Map<String, String> setDirectoryLanguageVariable(ApiConfig config, Template mapper) {
        HashMap<String, String> titleMap = new HashMap<String, String>(16);
        if (Objects.nonNull((Object)config.getLanguage())) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                mapper.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
                mapper.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
                titleMap.put(TemplateVariable.ERROR_LIST_TITLE.getVariable(), "\u9519\u8bef\u7801\u5217\u8868");
                titleMap.put(TemplateVariable.DICT_LIST_TITLE.getVariable(), "\u6570\u636e\u5b57\u5178");
            } else {
                mapper.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
                mapper.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"Data Dictionaries");
                titleMap.put(TemplateVariable.ERROR_LIST_TITLE.getVariable(), "Error Code List");
                titleMap.put(TemplateVariable.DICT_LIST_TITLE.getVariable(), "Data Dictionaries");
            }
        } else {
            mapper.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            mapper.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
            titleMap.put(TemplateVariable.ERROR_LIST_TITLE.getVariable(), "\u9519\u8bef\u7801\u5217\u8868");
            titleMap.put(TemplateVariable.DICT_LIST_TITLE.getVariable(), "\u6570\u636e\u5b57\u5178");
        }
        return titleMap;
    }

    public void setCssCDN(ApiConfig config, Template template) {
        if (DocLanguage.CHINESE.equals((Object)config.getLanguage())) {
            template.binding(TemplateVariable.CSS_CND.getVariable(), (Object)"https://fonts.googleapis.cnpmjs.org");
        } else {
            template.binding(TemplateVariable.CSS_CND.getVariable(), (Object)"https://fonts.googleapis.com");
        }
    }

    public void bindingCommonVariable(ApiConfig config, JavaProjectBuilder javaProjectBuilder, Template template, boolean apiDocListEmpty) {
        int codeIndex;
        String strTime = DateTimeUtil.long2Str((long)NOW, (String)"yyyy-MM-dd HH:mm:ss");
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config, javaProjectBuilder);
        template.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), errorCodeList);
        template.binding(TemplateVariable.VERSION_LIST.getVariable(), config.getRevisionLogs());
        template.binding(TemplateVariable.DEPENDENCY_LIST.getVariable(), config.getRpcApiDependencies());
        template.binding(TemplateVariable.VERSION.getVariable(), (Object)NOW);
        template.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)strTime);
        template.binding(TemplateVariable.PROJECT_NAME.getVariable(), (Object)config.getProjectName());
        List<ApiDocDict> apiDocDictList = DocUtil.buildDictionary(config, javaProjectBuilder);
        template.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
        int n = codeIndex = apiDocListEmpty ? 1 : apiDocDictList.size();
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            template.binding(TemplateVariable.ERROR_CODE_ORDER.getVariable(), (Object)(++codeIndex));
        }
        if (CollectionUtil.isNotEmpty(apiDocDictList)) {
            template.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(++codeIndex));
        }
        this.setDirectoryLanguageVariable(config, template);
        this.setCssCDN(config, template);
    }

    public String allInOneDocName(ApiConfig apiConfig, String fileName, String suffix) {
        String allInOneName = apiConfig.getAllInOneDocFileName();
        if (StringUtils.isNotEmpty((CharSequence)apiConfig.getAllInOneDocFileName())) {
            if (allInOneName.endsWith(suffix)) {
                return allInOneName;
            }
            return allInOneName + suffix;
        }
        if (StringUtil.isNotEmpty((String)fileName) && fileName.endsWith(suffix)) {
            return fileName;
        }
        return fileName + suffix;
    }

    public void copyJQueryAndCss(ApiConfig config) {
        Template indexCssTemplate = BeetlTemplateUtil.getByName("css/AllInOne.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
        BaseDocBuilderTemplate.copyJarFile("css/font.css", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "font.css");
        BaseDocBuilderTemplate.copyJarFile("js/jquery.min.js", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "jquery.min.js");
        BaseDocBuilderTemplate.copyJarFile("js/highlight.min.js", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "highlight.min.js");
        BaseDocBuilderTemplate.copyJarFile("css/font.css", config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "font.css");
    }

    public static void copyJarFile(String source, String target) {
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader("/template/");
        Resource resource = resourceLoader.getResource(source);
        try (FileWriter fileWriter = new FileWriter(target, false);
             Reader reader = resource.openReader();){
            int temp;
            char[] c = new char[0x100000];
            int len = 0;
            while ((temp = reader.read()) != -1) {
                c[len] = (char)temp;
                ++len;
            }
            reader.close();
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(c, 0, len);
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

