/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder;

import com.ly.doc.builder.DocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.DocGlobalConstants;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.utils.BeetlTemplateUtil;
import com.power.common.util.FileUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.Template;

public class HtmlApiDocBuilder {
    private static final String ERROR_CODE_HTML = "error.html";
    private static final String DICT_HTML = "dict.html";
    private static String INDEX_HTML = "index.html";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        HtmlApiDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder).getApiDatas();
        builderTemplate.copyJQueryAndCss(config);
        if (config.isAllInOne()) {
            apiDocList = docBuildTemplate.handleApiGroup(apiDocList, config);
            if (config.isCreateDebugPage()) {
                INDEX_HTML = "debug-all.html";
                if (StringUtils.isNotEmpty((CharSequence)config.getAllInOneDocFileName())) {
                    INDEX_HTML = config.getAllInOneDocFileName();
                }
                builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "debug-all.html", INDEX_HTML);
                Template mockJs = BeetlTemplateUtil.getByName("js/debug.js");
                FileUtil.nioWriteFile((String)mockJs.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "debug.js"));
            } else {
                if (StringUtils.isNotEmpty((CharSequence)config.getAllInOneDocFileName())) {
                    INDEX_HTML = config.getAllInOneDocFileName();
                }
                builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.html", INDEX_HTML);
            }
            builderTemplate.buildSearchJs(config, javaProjectBuilder, apiDocList, "js/search_all.js.btl");
        } else {
            String indexAlias;
            if (config.isCreateDebugPage()) {
                indexAlias = "debug";
                HtmlApiDocBuilder.buildDoc(builderTemplate, apiDocList, config, javaProjectBuilder, "html/debug.html", indexAlias);
                Template mockJs = BeetlTemplateUtil.getByName("js/debug.js");
                FileUtil.nioWriteFile((String)mockJs.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "debug.js"));
            } else {
                indexAlias = "api";
                HtmlApiDocBuilder.buildDoc(builderTemplate, apiDocList, config, javaProjectBuilder, "html/index.html", indexAlias);
            }
            builderTemplate.buildErrorCodeDoc(config, javaProjectBuilder, apiDocList, "html/error.html", ERROR_CODE_HTML, indexAlias);
            builderTemplate.buildDirectoryDataDoc(config, javaProjectBuilder, apiDocList, "html/dict.html", DICT_HTML, indexAlias);
            builderTemplate.buildSearchJs(config, javaProjectBuilder, apiDocList, "js/search.js.btl");
        }
    }

    private static void buildDoc(DocBuilderTemplate builderTemplate, List<ApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String indexHtml) {
        FileUtil.mkdirs((String)config.getOutPath());
        int index = 0;
        for (ApiDoc doc : apiDocList) {
            if (index == 0) {
                doc.setAlias(indexHtml);
            }
            builderTemplate.buildDoc(apiDocList, config, javaProjectBuilder, template, doc.getAlias() + ".html", doc, indexHtml);
            ++index;
        }
    }
}

