/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder;

import com.ly.doc.builder.DocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.torna.Apis;
import com.ly.doc.model.torna.TornaApi;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.utils.TornaUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class TornaBuilder {
    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        TornaBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setParamsDataToTree(true);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.FALSE);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        ApiSchema apiSchema = docBuildTemplate.getApiData(configBuilder);
        List<ApiDoc> apiDocList = docBuildTemplate.handleApiGroup(apiSchema.getApiDatas(), config);
        TornaBuilder.buildTorna(apiDocList, config, javaProjectBuilder);
    }

    public static void buildTorna(List<ApiDoc> apiDocs, ApiConfig apiConfig, JavaProjectBuilder builder) {
        TornaApi tornaApi = new TornaApi();
        tornaApi.setAuthor(apiConfig.getAuthor());
        tornaApi.setIsReplace(BooleanUtils.toInteger((boolean)apiConfig.getReplace()));
        ArrayList<Apis> groupApiList = new ArrayList<Apis>();
        for (ApiDoc groupApi : apiDocs) {
            Apis api;
            ArrayList<Apis> apisList = new ArrayList<Apis>();
            List<ApiDoc> childrenApiDocs = groupApi.getChildrenApiDocs();
            for (ApiDoc a : childrenApiDocs) {
                api = new Apis();
                api.setName(StringUtils.isBlank((CharSequence)a.getDesc()) ? a.getName() : a.getDesc());
                api.setItems(TornaUtil.buildApis(a.getList(), TornaUtil.setDebugEnv(apiConfig, tornaApi)));
                api.setIsFolder("1");
                api.setAuthor(a.getAuthor());
                api.setOrderIndex(a.getOrder());
                apisList.add(api);
            }
            api = new Apis();
            api.setName(StringUtils.isBlank((CharSequence)groupApi.getDesc()) ? groupApi.getName() : groupApi.getDesc());
            api.setAuthor(tornaApi.getAuthor());
            api.setOrderIndex(groupApi.getOrder());
            api.setIsFolder("1");
            api.setItems(apisList);
            groupApiList.add(api);
        }
        tornaApi.setCommonErrorCodes(TornaUtil.buildErrorCode(apiConfig, builder));
        tornaApi.setApis(groupApiList.size() == 1 && "default".equals(((Apis)groupApiList.get(0)).getName()) ? ((Apis)groupApiList.get(0)).getItems() : groupApiList);
        TornaUtil.pushToTorna(tornaApi, apiConfig, builder);
    }
}

