/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder;

import com.ly.doc.builder.DocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.DocGlobalConstants;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.template.IDocBuildTemplate;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.beetl.core.Template;

public class WordDocBuilder {
    private static final String TEMPLATE_DOCX = "template/word/template.docx";
    private static final String BUILD_DOCX = "index.docx";
    private static final String BUILD_ERROR_DOCX = "error.docx";
    private static final String BUILD_DICT_DOCX = "dict.docx";

    public static void buildApiDoc(ApiConfig config) throws Exception {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        WordDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) throws Exception {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        ApiSchema apiSchema = docBuildTemplate.getApiData(configBuilder);
        List<ApiDoc> apiDocList = apiSchema.getApiDatas();
        if (config.isAllInOne()) {
            String version = config.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)"yyyyMMddHHmm");
            String docName = builderTemplate.allInOneDocName(config, "AllInOne" + version + ".docx", ".docx");
            apiDocList = docBuildTemplate.handleApiGroup(apiDocList, config);
            String outPath = config.getOutPath();
            FileUtil.mkdirs((String)outPath);
            Template tpl = builderTemplate.buildAllRenderDocTemplate(apiDocList, config, javaProjectBuilder, "word/AllInOneWordTemplate.xml", null, null);
            WordDocBuilder.copyAndReplaceDocx(tpl.render(), outPath + DocGlobalConstants.FILE_SEPARATOR + docName);
        } else {
            FileUtil.mkdir((String)config.getOutPath());
            for (ApiDoc doc : apiDocList) {
                Template template = builderTemplate.buildApiDocTemplate(doc, config, "word/index.xml");
                WordDocBuilder.copyAndReplaceDocx(template.render(), config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + doc.getName() + BUILD_DOCX);
            }
            Template errorCodeDocTemplate = builderTemplate.buildErrorCodeDocTemplate(config, "word/error.xml", javaProjectBuilder);
            WordDocBuilder.copyAndReplaceDocx(errorCodeDocTemplate.render(), config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + BUILD_ERROR_DOCX);
            Template directoryDataDocTemplate = builderTemplate.buildDirectoryDataDocTemplate(config, javaProjectBuilder, "word/dict.xml");
            WordDocBuilder.copyAndReplaceDocx(directoryDataDocTemplate.render(), config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + BUILD_DICT_DOCX);
        }
    }

    public static void copyAndReplaceDocx(String content, String docxOutputPath) throws Exception {
        ZipEntry entry;
        InputStream resourceAsStream = WordDocBuilder.class.getClassLoader().getResourceAsStream(TEMPLATE_DOCX);
        Objects.requireNonNull(resourceAsStream, "word template docx is not found");
        ZipInputStream zipInputStream = new ZipInputStream(resourceAsStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(Paths.get(docxOutputPath, new String[0]), new OpenOption[0]));
        while ((entry = zipInputStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            zipOutputStream.putNextEntry(new ZipEntry(entryName));
            if ("word/document.xml".equals(entryName)) {
                byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
                zipOutputStream.write(bytes, 0, bytes.length);
            } else {
                int len;
                byte[] buffer = new byte[1024];
                while ((len = zipInputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
            }
            zipOutputStream.closeEntry();
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
        zipOutputStream.close();
    }
}

