/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.javadoc;

import com.ly.doc.builder.javadoc.JavadocDocBuilderTemplate;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.javadoc.JavadocApiDoc;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class JavadocAdocBuilder {
    private static final String API_EXTENSION = "JavadocApi.adoc";
    private static final String INDEX_DOC = "javadoc-index.adoc";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        JavadocAdocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setAdoc(true);
        JavadocDocBuilderTemplate builderTemplate = new JavadocDocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        List<JavadocApiDoc> apiDocList = builderTemplate.getJavadocApiDoc(config, javaProjectBuilder);
        if (config.isAllInOne()) {
            String docName = builderTemplate.allInOneDocName(config, INDEX_DOC, ".adoc");
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "javadoc/JavadocAllInOne.adoc", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "javadoc/Javadoc.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.adoc", "ErrorCodeList.adoc", javaProjectBuilder);
        }
    }
}

