/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.javadoc;

import com.ly.doc.builder.BaseDocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.DocGlobalConstants;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.constants.TemplateVariable;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDocDict;
import com.ly.doc.model.ApiErrorCode;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.JavadocJavaMethod;
import com.ly.doc.model.javadoc.JavadocApiAllData;
import com.ly.doc.model.javadoc.JavadocApiDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.utils.BeetlTemplateUtil;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beetl.core.Template;

public class JavadocDocBuilderTemplate
extends BaseDocBuilderTemplate {
    private static final String DEPENDENCY_TITLE = "Add dependency";

    @Override
    public void checkAndInit(ApiConfig config, boolean checkOutPath) {
        config.setFramework(FrameworkEnum.JAVADOC.getFramework());
        super.checkAndInit(config, checkOutPath);
        config.setOutPath(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "javadoc");
    }

    public void buildApiDoc(List<JavadocApiDoc> apiDocList, ApiConfig config, String template, String fileExtension) {
        FileUtil.mkdirs((String)config.getOutPath());
        for (JavadocApiDoc apiDoc : apiDocList) {
            Template mapper = BeetlTemplateUtil.getByName(template);
            mapper.binding(TemplateVariable.NAME.getVariable(), (Object)apiDoc.getName());
            mapper.binding(TemplateVariable.DESC.getVariable(), (Object)apiDoc.getDesc());
            mapper.binding(TemplateVariable.LIST.getVariable(), apiDoc.getList());
            mapper.binding(TemplateVariable.AUTHOR.getVariable(), (Object)apiDoc.getAuthor());
            mapper.binding(TemplateVariable.VERSION.getVariable(), (Object)apiDoc.getVersion());
            FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + apiDoc.getShortName() + fileExtension));
        }
    }

    public void buildAllInOne(List<JavadocApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName) {
        String outPath = config.getOutPath();
        FileUtil.mkdirs((String)outPath);
        Template tpl = BeetlTemplateUtil.getByName(template);
        tpl.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        super.bindingCommonVariable(config, javaProjectBuilder, tpl, apiDocList.isEmpty());
        FileUtil.nioWriteFile((String)tpl.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildSearchJs(List<JavadocApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName) {
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config, javaProjectBuilder);
        Template tpl = BeetlTemplateUtil.getByName(template);
        ArrayList<JavadocApiDoc> apiDocs = new ArrayList<JavadocApiDoc>();
        JavadocApiDoc apiDoc = new JavadocApiDoc();
        apiDoc.setAlias(DEPENDENCY_TITLE);
        apiDoc.setOrder(1);
        apiDoc.setDesc(DEPENDENCY_TITLE);
        apiDoc.setList(new ArrayList<JavadocJavaMethod>(0));
        apiDocs.add(apiDoc);
        for (JavadocApiDoc apiDoc1 : apiDocList) {
            apiDoc1.setOrder(apiDocs.size() + 1);
            apiDocs.add(apiDoc1);
        }
        Map<String, String> titleMap = this.setDirectoryLanguageVariable(config, tpl);
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            JavadocApiDoc apiDoc1;
            apiDoc1 = new JavadocApiDoc();
            apiDoc1.setOrder(apiDocs.size() + 1);
            apiDoc1.setDesc(titleMap.get(TemplateVariable.ERROR_LIST_TITLE.getVariable()));
            apiDoc1.setList(new ArrayList<JavadocJavaMethod>(0));
            apiDocs.add(apiDoc1);
        }
        List<ApiDocDict> apiDocDictList = DocUtil.buildDictionary(config, javaProjectBuilder);
        tpl.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
        tpl.binding(TemplateVariable.DIRECTORY_TREE.getVariable(), apiDocs);
        FileUtil.nioWriteFile((String)tpl.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildErrorCodeDoc(ApiConfig config, String template, String outPutFileName, JavaProjectBuilder javaProjectBuilder) {
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config, javaProjectBuilder);
        Template mapper = BeetlTemplateUtil.getByName(template);
        mapper.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
        FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public JavadocApiAllData getApiData(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        JavadocApiAllData apiAllData = new JavadocApiAllData();
        apiAllData.setLanguage(config.getLanguage().getCode());
        apiAllData.setProjectName(config.getProjectName());
        apiAllData.setProjectId(DocUtil.generateId(config.getProjectName()));
        apiAllData.setApiDocList(this.listOfApiData(config, javaProjectBuilder));
        apiAllData.setErrorCodeList(DocUtil.errorCodeDictToList(config, javaProjectBuilder));
        apiAllData.setRevisionLogs(config.getRevisionLogs());
        apiAllData.setApiDocDictList(DocUtil.buildDictionary(config, javaProjectBuilder));
        return apiAllData;
    }

    private List<JavadocApiDoc> listOfApiData(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        this.checkAndInitForGetApiData(config);
        config.setMd5EncryptedHtmlName(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        ApiSchema apiSchema = docBuildTemplate.getApiData(configBuilder);
        return apiSchema.getApiDatas();
    }

    public List<JavadocApiDoc> getJavadocApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setShowJavaType(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        return docBuildTemplate.getApiData(configBuilder).getApiDatas();
    }
}

