/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.javadoc;

import com.ly.doc.builder.javadoc.JavadocDocBuilderTemplate;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.javadoc.JavadocApiDoc;
import com.power.common.util.DateTimeUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class JavadocMarkdownBuilder {
    private static final String API_EXTENSION = "Api.md";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        JavadocMarkdownBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig apiConfig, JavaProjectBuilder javaProjectBuilder) {
        apiConfig.setAdoc(Boolean.FALSE);
        JavadocDocBuilderTemplate builderTemplate = new JavadocDocBuilderTemplate();
        builderTemplate.checkAndInit(apiConfig, Boolean.TRUE);
        List<JavadocApiDoc> apiDocList = builderTemplate.getJavadocApiDoc(apiConfig, javaProjectBuilder);
        if (apiConfig.isAllInOne()) {
            String version = apiConfig.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)"yyyyMMddHHmm");
            String docName = builderTemplate.allInOneDocName(apiConfig, "javadoc-all" + version, ".md");
            builderTemplate.buildAllInOne(apiDocList, apiConfig, javaProjectBuilder, "javadoc/JavadocAllInOne.md", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, apiConfig, "javadoc/Javadoc.md", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(apiConfig, "ErrorCodeList.md", "ErrorCodeList.md", javaProjectBuilder);
        }
    }
}

