/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.openapi;

import com.ly.doc.builder.DocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.ComponentTypeEnum;
import com.ly.doc.constants.Methods;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiExceptionStatus;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.DocMapping;
import com.ly.doc.model.TagDoc;
import com.ly.doc.model.openapi.OpenApiTag;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.OpenApiSchemaUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractOpenApiBuilder {
    private String componentKey;
    protected static final Map<String, String> STRING_COMPONENT = new HashMap<String, String>();

    public String getComponentKey() {
        return this.componentKey;
    }

    public void setComponentKey(String componentKey) {
        this.componentKey = componentKey;
    }

    abstract String getModuleName();

    abstract void openApiCreate(ApiConfig var1, ApiSchema<ApiDoc> var2);

    abstract Map<String, Object> buildPathUrlsRequest(ApiConfig var1, ApiMethodDoc var2, ApiDoc var3, List<ApiExceptionStatus> var4);

    abstract Map<String, Object> buildResponsesBody(ApiConfig var1, ApiMethodDoc var2);

    abstract List<Map<String, Object>> buildParameters(ApiMethodDoc var1);

    abstract Map<String, Object> getStringParams(ApiParam var1, boolean var2);

    public abstract Map<String, Object> buildComponentsSchema(ApiSchema<ApiDoc> var1);

    public Map<String, Object> buildPaths(ApiConfig apiConfig, ApiSchema<ApiDoc> apiSchema, Set<OpenApiTag> tags) {
        LinkedHashMap<String, Object> pathMap = new LinkedHashMap<String, Object>(500);
        List<ApiDoc> apiDocs = apiSchema.getApiDatas();
        for (ApiDoc apiDoc : apiDocs) {
            if (CollectionUtil.isEmpty(apiDoc.getList())) continue;
            for (ApiMethodDoc methodDoc : apiDoc.getList()) {
                String[] paths;
                for (String path : paths = methodDoc.getPath().split(";")) {
                    path = path.trim();
                    Map<String, Object> request = this.buildPathUrls(apiConfig, methodDoc, methodDoc.getClazzDoc(), apiSchema.getApiExceptionStatuses());
                    if (!pathMap.containsKey(path)) {
                        pathMap.put(path, request);
                        continue;
                    }
                    Map oldRequest = (Map)pathMap.get(path);
                    oldRequest.putAll(request);
                }
            }
        }
        for (Map.Entry entry : DocMapping.TAG_DOC.entrySet()) {
            String tag = (String)entry.getKey();
            tags.addAll(((TagDoc)entry.getValue()).getClazzDocs().stream().map(doc -> OpenApiTag.of(doc.getName(), doc.getDesc())).collect(Collectors.toSet()));
        }
        return pathMap;
    }

    public Map<String, Object> buildPathUrls(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc, List<ApiExceptionStatus> apiExceptionStatuses) {
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put(apiMethodDoc.getType().toLowerCase(), this.buildPathUrlsRequest(apiConfig, apiMethodDoc, apiDoc, apiExceptionStatuses));
        return request;
    }

    public Map<String, Object> buildContent(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        String contentType = apiMethodDoc.getContentType();
        if (isRep) {
            contentType = "*/*";
        }
        content.put(contentType, this.buildContentBody(apiConfig, apiMethodDoc, isRep));
        return content;
    }

    public Map<String, Object> buildContentBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        if (Objects.nonNull(apiMethodDoc.getReturnSchema()) && isRep) {
            content.put("schema", apiMethodDoc.getReturnSchema());
        } else if (!isRep && Objects.nonNull(apiMethodDoc.getRequestSchema())) {
            content.put("schema", apiMethodDoc.getRequestSchema());
        } else {
            content.put("schema", this.buildBodySchema(apiMethodDoc, isRep));
        }
        if ("#/definitions/".equals(this.componentKey) && !isRep) {
            content.put("name", apiMethodDoc.getName());
        }
        if ("#/components/schemas/".equals(this.componentKey) && (!isRep && apiConfig.isRequestExample() || isRep && apiConfig.isResponseExample())) {
            content.put("examples", AbstractOpenApiBuilder.buildBodyExample(apiMethodDoc, isRep));
        }
        return content;
    }

    public Map<String, Object> buildBodySchema(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        HashMap<String, String> innerScheme = new HashMap<String, String>(10);
        if (isRep) {
            String responseRef = this.componentKey + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getResponseParams());
            if (apiMethodDoc.getIsResponseArray() == 1) {
                schema.put("type", "array");
                innerScheme.put("$ref", responseRef);
                schema.put("items", innerScheme);
            } else if (CollectionUtil.isNotEmpty(apiMethodDoc.getResponseParams())) {
                schema.put("$ref", responseRef);
            }
            return schema;
        }
        String randomName = ComponentTypeEnum.getRandomName(ApiConfig.getInstance().getComponentType(), apiMethodDoc);
        if (Methods.POST.getValue().equals(apiMethodDoc.getType()) && (apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded") || apiMethodDoc.getContentType().equals("multipart/form-data"))) {
            schema.put("type", "object");
            Map<String, Object> propertiesAndRequirments = this.buildProperties(apiMethodDoc.getRequestParams(), new HashMap<String, Object>(), Boolean.FALSE);
            schema.put("properties", propertiesAndRequirments.get("properties"));
            schema.put("required", propertiesAndRequirments.get("required"));
            return schema;
        }
        String requestRef = apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded") ? this.componentKey + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getQueryParams()) : this.componentKey + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getRequestParams());
        if (CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams())) {
            if (apiMethodDoc.getIsRequestArray() == 1) {
                schema.put("type", "array");
                innerScheme.put("$ref", requestRef);
                schema.put("items", innerScheme);
            } else {
                schema.put("$ref", requestRef);
            }
        }
        return schema;
    }

    public static Map<String, Object> buildBodyExample(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("json", AbstractOpenApiBuilder.buildExampleData(apiMethodDoc, isRep));
        return content;
    }

    public static Map<String, Object> buildExampleData(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("summary", "test data");
        if (!isRep) {
            content.put("value", StringUtil.isEmpty((String)apiMethodDoc.getRequestExample().getJsonBody()) ? apiMethodDoc.getRequestExample().getExampleBody() : apiMethodDoc.getRequestExample().getJsonBody());
        } else {
            content.put("value", apiMethodDoc.getResponseUsage());
        }
        return content;
    }

    public Map<String, Object> buildParametersSchema(ApiParam apiParam) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        schema.put("type", openApiType);
        if ("file".equals(openApiType)) {
            schema.put("format", "binary");
            schema.put("type", "string");
        } else if ("object".equals(openApiType)) {
            if ("enum".equals(apiParam.getType())) {
                schema.put("enum", apiParam.getEnumValues());
            }
        } else if ("array".equals(openApiType)) {
            if (CollectionUtil.isNotEmpty(apiParam.getEnumValues())) {
                schema.put("type", "string");
                schema.put("items", apiParam.getEnumValues());
            } else {
                schema.put("type", "array");
                HashMap<String, String> map = new HashMap<String, String>(4);
                map.put("type", "string");
                map.put("format", "string");
                schema.put("items", map);
            }
        } else {
            schema.put("format", apiParam.getType());
            if ("enum".equals(apiParam.getType())) {
                schema.put("enum", apiParam.getEnumValues());
            }
        }
        return schema;
    }

    public static Map<String, Object> buildParametersSchema(ApiReqParam header) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(header.getType());
        schema.put("type", openApiType);
        schema.put("format", openApiType);
        return schema;
    }

    public Map<String, Object> buildResponses(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, List<ApiExceptionStatus> apiExceptionStatuses) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>(8);
        response.put("200", this.buildResponsesBody(apiConfig, apiMethodDoc));
        if (CollectionUtil.isNotEmpty(apiExceptionStatuses)) {
            for (ApiExceptionStatus apiExceptionStatus : apiExceptionStatuses) {
                response.put(apiExceptionStatus.getStatus(), this.buildEexcetionResponsesBody(apiConfig, apiExceptionStatus));
            }
        }
        return response;
    }

    public Map<String, Object> buildEexcetionResponsesBody(ApiConfig apiConfig, ApiExceptionStatus apiExceptionStatus) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(8);
        responseBody.put("description", apiExceptionStatus.getDesc());
        HashMap content = new HashMap(8);
        HashMap mediaTypeContent = new HashMap(8);
        HashMap<String, String> schema = new HashMap<String, String>(8);
        String responseRef = this.componentKey + OpenApiSchemaUtil.getClassNameFromParams(apiExceptionStatus.getExceptionResponseParams());
        if (CollectionUtil.isNotEmpty(apiExceptionStatus.getExceptionResponseParams())) {
            schema.put("$ref", responseRef);
        }
        mediaTypeContent.put("schema", schema);
        if ("#/components/schemas/".equals(this.componentKey) && apiConfig.isResponseExample()) {
            HashMap json = new HashMap(8);
            HashMap<String, String> jsonData = new HashMap<String, String>(8);
            jsonData.put("summary", "response example");
            jsonData.put("value", apiExceptionStatus.getResponseUsage());
            json.put("json", jsonData);
            mediaTypeContent.put("examples", json);
        }
        content.put("*/*", mediaTypeContent);
        responseBody.put("content", content);
        return responseBody;
    }

    public Map<String, Object> buildProperties(List<ApiParam> apiParam, Map<String, Object> component, boolean isResp) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> propertiesData = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> requiredList = new ArrayList<String>();
        if (apiParam != null) {
            int paramsSize = apiParam.size();
            for (ApiParam param : apiParam) {
                if (param.isRequired()) {
                    requiredList.add(param.getField());
                }
                if (param.getType().equals("map") && StringUtil.isEmpty((String)param.getClassName()) || param.isQueryParam() || param.isPathParam()) continue;
                String field = param.getField();
                propertiesData.put(field, this.buildPropertiesData(param, component, isResp));
            }
            if (!propertiesData.isEmpty()) {
                properties.put("properties", propertiesData);
            }
            if (!CollectionUtil.isEmpty(requiredList)) {
                properties.put("required", requiredList);
            }
            return properties;
        }
        return new HashMap<String, Object>();
    }

    private Map<String, Object> buildPropertiesData(ApiParam apiParam, Map<String, Object> component, boolean isResp) {
        HashMap<String, Object> propertiesData = new HashMap<String, Object>();
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        propertiesData.put("description", apiParam.getDesc());
        if (StringUtil.isNotEmpty((String)apiParam.getValue())) {
            propertiesData.put("example", apiParam.getValue());
        }
        if (!"object".equals(openApiType)) {
            propertiesData.put("type", openApiType);
            propertiesData.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
            if ("enum".equals(apiParam.getType())) {
                propertiesData.put("enum", apiParam.getEnumValues());
            }
        }
        if ("map".equals(apiParam.getType())) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(map data)");
        }
        if ("array".equals(apiParam.getType())) {
            HashMap<String, String> arrayRef;
            propertiesData.put("type", "array");
            if (CollectionUtil.isNotEmpty(apiParam.getChildren())) {
                if (!apiParam.isSelfReferenceLoop()) {
                    arrayRef = new HashMap(4);
                    String childSchemaName = OpenApiSchemaUtil.getClassNameFromParams(apiParam.getChildren());
                    if (childSchemaName.contains("NO_BODY_PARAM")) {
                        propertiesData.put("type", "object");
                        propertiesData.put("description", apiParam.getDesc() + "(object)");
                    } else {
                        component.put(childSchemaName, this.buildProperties(apiParam.getChildren(), component, isResp));
                        arrayRef.put("$ref", this.componentKey + childSchemaName);
                        propertiesData.put("items", arrayRef);
                    }
                }
            } else {
                arrayRef = new HashMap<String, String>(4);
                arrayRef.put("type", "string");
                propertiesData.put("items", arrayRef);
            }
        }
        if ("file".equals(apiParam.getType())) {
            propertiesData.put("type", "string");
            propertiesData.put("format", "binary");
        }
        if ("object".equals(apiParam.getType())) {
            propertiesData.put("description", apiParam.getDesc() + "(object)");
            if (CollectionUtil.isNotEmpty(apiParam.getChildren())) {
                if (!apiParam.isSelfReferenceLoop()) {
                    String childSchemaName = OpenApiSchemaUtil.getClassNameFromParams(apiParam.getChildren());
                    if (childSchemaName.contains("NO_BODY_PARAM")) {
                        propertiesData.put("type", "object");
                    } else {
                        component.put(childSchemaName, this.buildProperties(apiParam.getChildren(), component, isResp));
                        propertiesData.put("$ref", this.componentKey + childSchemaName);
                    }
                }
            } else {
                propertiesData.put("type", "object");
            }
        }
        if (apiParam.getExtensions() != null && !apiParam.getExtensions().isEmpty()) {
            apiParam.getExtensions().entrySet().forEach(e -> propertiesData.put("x-" + (String)e.getKey(), e.getValue()));
        }
        return propertiesData;
    }

    public Map<String, Object> buildComponentData(ApiSchema<ApiDoc> apiSchema) {
        HashMap<String, Object> component = new HashMap<String, Object>(16);
        component.put("defaultPrimitive", STRING_COMPONENT);
        apiSchema.getApiDatas().forEach(entrypoint -> {
            List<ApiMethodDoc> apiMethodDocs = entrypoint.getList();
            apiMethodDocs.forEach(method -> {
                String requestSchema = OpenApiSchemaUtil.getClassNameFromParams(method.getRequestParams());
                List<ApiParam> requestParams = method.getRequestParams();
                Map<String, Object> prop = this.buildProperties(requestParams, component, false);
                component.put(requestSchema, prop);
                List<ApiParam> responseParams = method.getResponseParams();
                String responseSchemaName = OpenApiSchemaUtil.getClassNameFromParams(method.getResponseParams());
                component.put(responseSchemaName, this.buildProperties(responseParams, component, true));
            });
        });
        if (Objects.nonNull(apiSchema.getApiExceptionStatuses())) {
            apiSchema.getApiExceptionStatuses().forEach(e -> {
                List<ApiParam> responseParams = e.getExceptionResponseParams();
                String responseSchemaName = OpenApiSchemaUtil.getClassNameFromParams(e.getExceptionResponseParams());
                component.put(responseSchemaName, this.buildProperties(responseParams, component, true));
            });
        }
        component.remove("NO_BODY_PARAM");
        return component;
    }

    public ApiSchema<ApiDoc> getOpenApiDocs(ApiConfig config, JavaProjectBuilder projectBuilder) {
        config.setShowJavaType(false);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        config.setParamsDataToTree(true);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        return docBuildTemplate.getApiData(configBuilder);
    }

    static {
        STRING_COMPONENT.put("type", "string");
        STRING_COMPONENT.put("format", "string");
    }
}

