/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.openapi;

import com.ly.doc.builder.openapi.AbstractOpenApiBuilder;
import com.ly.doc.constants.Methods;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiExceptionStatus;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.TagDoc;
import com.ly.doc.model.openapi.OpenApiTag;
import com.ly.doc.utils.JsonUtil;
import com.ly.doc.utils.OpenApiSchemaUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OpenApiBuilder
extends AbstractOpenApiBuilder {
    private static final OpenApiBuilder INSTANCE = new OpenApiBuilder();

    @Override
    String getModuleName() {
        return "#/components/schemas/";
    }

    public static void buildOpenApi(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        OpenApiBuilder.buildOpenApi(config, javaProjectBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        ApiSchema<ApiDoc> apiSchema = INSTANCE.getOpenApiDocs(config, projectBuilder);
        INSTANCE.openApiCreate(config, apiSchema);
    }

    @Override
    public void openApiCreate(ApiConfig config, ApiSchema<ApiDoc> apiSchema) {
        this.setComponentKey(this.getModuleName());
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>(8);
        json.put("openapi", "3.1.0");
        json.put("info", OpenApiBuilder.buildInfo(config));
        json.put("servers", OpenApiBuilder.buildServers(config));
        HashSet<OpenApiTag> tags = new HashSet<OpenApiTag>();
        json.put("tags", tags);
        json.put("paths", this.buildPaths(config, apiSchema, tags));
        json.put("components", this.buildComponentsSchema(apiSchema));
        String filePath = config.getOutPath();
        filePath = filePath + "/openapi.json";
        String data = JsonUtil.toPrettyJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "Project Name is Null." : apiConfig.getProjectName());
        infoMap.put("version", "v1.0.0");
        return infoMap;
    }

    private static List<Map<String, Object>> buildServers(ApiConfig config) {
        ArrayList<Map<String, Object>> serverList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> serverMap = new HashMap<String, String>(8);
        serverMap.put("url", config.getServerUrl() == null ? "" : config.getServerUrl());
        serverList.add(serverMap);
        return serverList;
    }

    @Override
    public Map<String, Object> buildPathUrlsRequest(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc, List<ApiExceptionStatus> apiExceptionStatuses) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        if (!Objects.equals(apiMethodDoc.getDesc(), apiMethodDoc.getDetail())) {
            request.put("description", apiMethodDoc.getDetail());
        }
        request.put("tags", apiMethodDoc.getTagRefs().stream().map(TagDoc::getTag).toArray());
        request.put("requestBody", this.buildRequestBody(apiConfig, apiMethodDoc));
        request.put("parameters", this.buildParameters(apiMethodDoc));
        request.put("responses", this.buildResponses(apiConfig, apiMethodDoc, apiExceptionStatuses));
        request.put("deprecated", apiMethodDoc.isDeprecated());
        List<String> paths = OpenApiSchemaUtil.getPatternResult("[A-Za-z0-9_{}]*", apiMethodDoc.getPath());
        paths.add(apiMethodDoc.getType());
        String operationId = paths.stream().filter(StringUtils::isNotEmpty).collect(Collectors.joining("-"));
        request.put("operationId", operationId);
        if (apiMethodDoc.getExtensions() != null) {
            apiMethodDoc.getExtensions().entrySet().forEach(e -> request.put("x-" + (String)e.getKey(), e.getValue()));
        }
        return request;
    }

    private Map<String, Object> buildRequestBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        boolean isPost;
        HashMap<String, Object> requestBody = new HashMap<String, Object>(8);
        boolean bl = isPost = apiMethodDoc.getType().equals(Methods.POST.getValue()) || apiMethodDoc.getType().equals(Methods.PUT.getValue()) || apiMethodDoc.getType().equals(Methods.PATCH.getValue());
        if (isPost) {
            requestBody.put("content", this.buildContent(apiConfig, apiMethodDoc, false));
            return requestBody;
        }
        return null;
    }

    @Override
    public Map<String, Object> buildResponsesBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "OK");
        responseBody.put("content", this.buildContent(apiConfig, apiMethodDoc, true));
        return responseBody;
    }

    @Override
    List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        List<ApiParam> children;
        Map<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            parameters = this.getStringParams(apiParam, apiParam.isHasItems());
            parameters.put("in", "path");
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
            if (apiParam.isHasItems()) {
                parameters = this.getStringParams(apiParam, false);
                HashMap<String, Object> arrayMap = new HashMap<String, Object>(16);
                arrayMap.put("type", "array");
                arrayMap.put("items", this.getStringParams(apiParam, apiParam.isHasItems()));
                parameters.put("schema", arrayMap);
                parametersList.add(parameters);
                continue;
            }
            parameters = this.getStringParams(apiParam, false);
            children = apiParam.getChildren();
            if (!CollectionUtil.isEmpty(children)) continue;
            parametersList.add(parameters);
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqParam header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", header.getName());
                parameters.put("required", header.isRequired());
                parameters.put("description", header.getDesc());
                parameters.put("example", header.getValue());
                parameters.put("schema", OpenApiBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    @Override
    Map<String, Object> getStringParams(ApiParam apiParam, boolean hasItems) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(20);
        if (StringUtils.isNotEmpty((CharSequence)apiParam.getValue())) {
            parameters.put("example", apiParam.getValue());
        }
        if (!hasItems) {
            parameters.put("name", apiParam.getField());
            parameters.put("description", apiParam.getDesc());
            parameters.put("required", apiParam.isRequired());
            parameters.put("in", "query");
            parameters.put("schema", this.buildParametersSchema(apiParam));
        } else {
            if ("object".equals(apiParam.getType()) || "array".equals(apiParam.getType()) && apiParam.isHasItems()) {
                parameters.put("type", "object");
                parameters.put("description", "(complex POJO please use @RequestBody)");
            } else {
                String desc = apiParam.getDesc();
                if (desc.contains("file")) {
                    parameters.put("type", "file");
                } else if (desc.contains("string")) {
                    parameters.put("type", "string");
                } else {
                    parameters.put("type", "integer");
                }
            }
            parameters.putAll(this.buildParametersSchema(apiParam));
        }
        if (apiParam.getExtensions() != null && !apiParam.getExtensions().isEmpty()) {
            apiParam.getExtensions().entrySet().forEach(e -> parameters.put("x-" + (String)e.getKey(), e.getValue()));
        }
        return parameters;
    }

    @Override
    public Map<String, Object> buildComponentsSchema(ApiSchema<ApiDoc> apiSchema) {
        HashMap<String, Object> schemas = new HashMap<String, Object>(4);
        schemas.put("schemas", this.buildComponentData(apiSchema));
        return schemas;
    }
}

