/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.openapi;

import com.ly.doc.builder.openapi.AbstractOpenApiBuilder;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiExceptionStatus;
import com.ly.doc.model.ApiGroup;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.openapi.OpenApiTag;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JsonUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SwaggerBuilder
extends AbstractOpenApiBuilder {
    private static final SwaggerBuilder INSTANCE = new SwaggerBuilder();

    public static void buildOpenApi(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        SwaggerBuilder.buildOpenApi(config, javaProjectBuilder);
    }

    public static void buildOpenApi(ApiConfig config, JavaProjectBuilder projectBuilder) {
        ApiSchema<ApiDoc> apiSchema = INSTANCE.getOpenApiDocs(config, projectBuilder);
        INSTANCE.openApiCreate(config, apiSchema);
    }

    @Override
    String getModuleName() {
        return "#/definitions/";
    }

    @Override
    public void openApiCreate(ApiConfig config, ApiSchema<ApiDoc> apiSchema) {
        this.setComponentKey(this.getModuleName());
        HashMap<String, Object> json = new HashMap<String, Object>(8);
        json.put("swagger", "2.0");
        json.put("info", SwaggerBuilder.buildInfo(config));
        json.put("host", config.getServerUrl() == null ? "127.0.0.1" : config.getServerUrl());
        json.put("basePath", StringUtils.isNotBlank((CharSequence)config.getPathPrefix()) ? config.getPathPrefix() : "/");
        HashSet<OpenApiTag> tags = new HashSet<OpenApiTag>();
        json.put("tags", tags);
        json.put("paths", this.buildPaths(config, apiSchema, tags));
        json.put("definitions", this.buildComponentsSchema(apiSchema));
        String filePath = config.getOutPath();
        filePath = filePath + "/openapi.json";
        String data = JsonUtil.toPrettyJson(json);
        FileUtil.nioWriteFile((String)data, (String)filePath);
    }

    private static Map<String, Object> buildInfo(ApiConfig apiConfig) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>(8);
        infoMap.put("title", apiConfig.getProjectName() == null ? "Project Name is Null." : apiConfig.getProjectName());
        infoMap.put("version", "1.0.0");
        return infoMap;
    }

    @Deprecated
    private static List<Map<String, String>> buildTags(ApiConfig config) {
        ArrayList<Map<String, String>> tagList = new ArrayList<Map<String, String>>();
        List<ApiGroup> groups = config.getGroups();
        for (ApiGroup group : groups) {
            HashMap<String, String> tagMap = new HashMap<String, String>(4);
            tagMap.put("name", group.getName());
            tagMap.put("description", group.getApis());
            tagList.add(tagMap);
        }
        return tagList;
    }

    @Override
    public Map<String, Object> buildPathUrlsRequest(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc, List<ApiExceptionStatus> apiExceptionStatuses) {
        HashMap<String, Object> request = new HashMap<String, Object>(20);
        request.put("summary", apiMethodDoc.getDesc());
        request.put("description", apiMethodDoc.getDetail());
        request.put("tags", Arrays.asList(apiDoc.getName(), apiDoc.getDesc(), apiMethodDoc.getGroup()).stream().filter(StringUtil::isNotEmpty).toArray(String[]::new));
        List<Map<String, Object>> parameters = this.buildParameters(apiMethodDoc);
        if (CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams())) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("in", "body");
            parameter.putAll(this.buildContentBody(apiConfig, apiMethodDoc, false));
            parameters.add(parameter);
        }
        if (this.hasFile(parameters)) {
            ArrayList<String> formData = new ArrayList<String>();
            formData.add("multipart/form-data");
            request.put("consumes", formData);
        }
        request.put("parameters", parameters);
        request.put("responses", this.buildResponses(apiConfig, apiMethodDoc, apiExceptionStatuses));
        request.put("deprecated", apiMethodDoc.isDeprecated());
        String operationId = apiMethodDoc.getUrl().replace(apiMethodDoc.getServerUrl(), "");
        request.put("operationId", apiMethodDoc.getName() + "_" + apiMethodDoc.getMethodId() + "UsingOn" + apiMethodDoc.getType());
        return request;
    }

    private boolean hasFile(List<Map<String, Object>> parameters) {
        for (Map<String, Object> param : parameters) {
            if (!"formData".equals(param.get("in"))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> buildResponsesBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>(10);
        responseBody.put("description", "OK");
        if (CollectionUtil.isNotEmpty(apiMethodDoc.getResponseParams()) || Objects.nonNull(apiMethodDoc.getReturnSchema())) {
            responseBody.putAll(this.buildContentBody(apiConfig, apiMethodDoc, true));
        }
        return responseBody;
    }

    @Override
    List<Map<String, Object>> buildParameters(ApiMethodDoc apiMethodDoc) {
        Map<String, Object> parameters;
        ArrayList<Map<String, Object>> parametersList = new ArrayList<Map<String, Object>>();
        for (ApiParam apiParam : apiMethodDoc.getPathParams()) {
            parameters = this.getStringParams(apiParam, false);
            parameters.put("type", DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType()));
            parameters.put("in", "path");
            parametersList.add(parameters);
        }
        for (ApiParam apiParam : apiMethodDoc.getQueryParams()) {
            if (apiParam.getType().equals("array") || apiParam.isHasItems()) {
                parameters = this.getStringParams(apiParam, false);
                parameters.put("type", "array");
                parameters.put("items", this.getStringParams(apiParam, true));
                parametersList.add(parameters);
                continue;
            }
            parameters = this.getStringParams(apiParam, false);
            parameters.put("type", DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType()));
            parametersList.add(parameters);
        }
        if (!CollectionUtil.isEmpty(apiMethodDoc.getRequestHeaders())) {
            for (ApiReqParam header : apiMethodDoc.getRequestHeaders()) {
                parameters = new HashMap<String, Object>(20);
                parameters.put("name", header.getName());
                parameters.put("type", DocUtil.javaTypeToOpenApiTypeConvert(header.getType()));
                parameters.put("description", header.getDesc());
                parameters.put("required", header.isRequired());
                parameters.put("example", header.getValue());
                parameters.put("schema", SwaggerBuilder.buildParametersSchema(header));
                parameters.put("in", "header");
                parametersList.add(parameters);
            }
        }
        return parametersList;
    }

    @Override
    Map<String, Object> getStringParams(ApiParam apiParam, boolean hasItems) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(20);
        if (!hasItems) {
            if ("file".equalsIgnoreCase(apiParam.getType())) {
                parameters.put("in", "formData");
            } else {
                parameters.put("in", "query");
            }
            parameters.put("name", apiParam.getField());
            parameters.put("description", apiParam.getDesc());
            parameters.put("required", apiParam.isRequired());
            parameters.put("type", apiParam.getType());
        } else if ("object".equals(apiParam.getType()) || "array".equals(apiParam.getType()) && apiParam.isHasItems()) {
            parameters.put("type", "object(complex POJO please use @RequestBody)");
        } else {
            String desc = apiParam.getDesc();
            if (desc.contains("file")) {
                parameters.put("type", "file");
            } else if (desc.contains("string")) {
                parameters.put("type", "string");
            } else {
                parameters.put("type", "integer");
            }
        }
        return parameters;
    }

    @Override
    public Map<String, Object> buildComponentsSchema(ApiSchema<ApiDoc> apiSchema) {
        return this.buildComponentData(apiSchema);
    }
}

