/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.rpc;

import com.ly.doc.builder.rpc.RpcDocBuilderTemplate;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.rpc.RpcApiDoc;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class RpcAdocBuilder {
    private static final String API_EXTENSION = "RpcApi.adoc";
    private static final String INDEX_DOC = "rpc-index.adoc";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        RpcAdocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setAdoc(true);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        List<RpcApiDoc> apiDocList = builderTemplate.getRpcApiDoc(config, javaProjectBuilder);
        if (config.isAllInOne()) {
            String docName = builderTemplate.allInOneDocName(config, INDEX_DOC, ".adoc");
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "dubbo/DubboAllInOne.adoc", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "dubbo/Dubbo.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.adoc", "ErrorCodeList.adoc", javaProjectBuilder);
        }
    }
}

