/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.rpc;

import com.ly.doc.builder.BaseDocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.DocGlobalConstants;
import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.constants.TemplateVariable;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDocDict;
import com.ly.doc.model.ApiErrorCode;
import com.ly.doc.model.RpcJavaMethod;
import com.ly.doc.model.rpc.RpcApiAllData;
import com.ly.doc.model.rpc.RpcApiDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.utils.BeetlTemplateUtil;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.FileUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beetl.core.Template;

public class RpcDocBuilderTemplate
extends BaseDocBuilderTemplate {
    private static final String DEPENDENCY_TITLE = "Add dependency";

    @Override
    public void checkAndInit(ApiConfig config, boolean checkOutPath) {
        if (StringUtil.isEmpty((String)config.getFramework())) {
            config.setFramework(FrameworkEnum.DUBBO.getFramework());
        }
        super.checkAndInit(config, checkOutPath);
        config.setOutPath(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "rpc");
    }

    public void buildApiDoc(List<RpcApiDoc> apiDocList, ApiConfig config, String template, String fileExtension) {
        FileUtil.mkdirs((String)config.getOutPath());
        for (RpcApiDoc rpcDoc : apiDocList) {
            Template mapper = BeetlTemplateUtil.getByName(template);
            mapper.binding(TemplateVariable.DESC.getVariable(), (Object)rpcDoc.getDesc());
            mapper.binding(TemplateVariable.NAME.getVariable(), (Object)rpcDoc.getName());
            mapper.binding(TemplateVariable.LIST.getVariable(), rpcDoc.getList());
            mapper.binding(TemplateVariable.AUTHOR.getVariable(), (Object)rpcDoc.getAuthor());
            mapper.binding(TemplateVariable.PROTOCOL.getVariable(), (Object)rpcDoc.getProtocol());
            mapper.binding(TemplateVariable.VERSION.getVariable(), (Object)rpcDoc.getVersion());
            mapper.binding(TemplateVariable.URI.getVariable(), (Object)rpcDoc.getUri());
            FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + rpcDoc.getShortName() + fileExtension));
        }
    }

    public void buildAllInOne(List<RpcApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName) {
        String outPath = config.getOutPath();
        String rpcConfig = config.getRpcConsumerConfig();
        String rpcConfigConfigContent = null;
        if (Objects.nonNull(rpcConfig)) {
            rpcConfigConfigContent = FileUtil.getFileContent((String)rpcConfig);
        }
        FileUtil.mkdirs((String)outPath);
        Template tpl = BeetlTemplateUtil.getByName(template);
        tpl.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        tpl.binding(TemplateVariable.DEPENDENCY_LIST.getVariable(), config.getRpcApiDependencies());
        tpl.binding(TemplateVariable.RPC_CONSUMER_CONFIG.getVariable(), (Object)rpcConfigConfigContent);
        super.bindingCommonVariable(config, javaProjectBuilder, tpl, apiDocList.isEmpty());
        FileUtil.nioWriteFile((String)tpl.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildSearchJs(List<RpcApiDoc> apiDocList, ApiConfig config, JavaProjectBuilder javaProjectBuilder, String template, String outPutFileName) {
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config, javaProjectBuilder);
        Template tpl = BeetlTemplateUtil.getByName(template);
        ArrayList<RpcApiDoc> apiDocs = new ArrayList<RpcApiDoc>();
        RpcApiDoc apiDoc = new RpcApiDoc();
        apiDoc.setAlias(DEPENDENCY_TITLE);
        apiDoc.setOrder(1);
        apiDoc.setDesc(DEPENDENCY_TITLE);
        apiDoc.setList(new ArrayList<RpcJavaMethod>(0));
        apiDocs.add(apiDoc);
        for (RpcApiDoc apiDoc1 : apiDocList) {
            apiDoc1.setOrder(apiDocs.size() + 1);
            apiDocs.add(apiDoc1);
        }
        Map<String, String> titleMap = this.setDirectoryLanguageVariable(config, tpl);
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            RpcApiDoc apiDoc1;
            apiDoc1 = new RpcApiDoc();
            apiDoc1.setOrder(apiDocs.size() + 1);
            apiDoc1.setDesc(titleMap.get(TemplateVariable.ERROR_LIST_TITLE.getVariable()));
            apiDoc1.setList(new ArrayList<RpcJavaMethod>(0));
            apiDocs.add(apiDoc1);
        }
        List<ApiDocDict> apiDocDictList = DocUtil.buildDictionary(config, javaProjectBuilder);
        tpl.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
        tpl.binding(TemplateVariable.DIRECTORY_TREE.getVariable(), apiDocs);
        FileUtil.nioWriteFile((String)tpl.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public void buildErrorCodeDoc(ApiConfig config, String template, String outPutFileName, JavaProjectBuilder javaProjectBuilder) {
        List<ApiErrorCode> errorCodeList = DocUtil.errorCodeDictToList(config, javaProjectBuilder);
        Template mapper = BeetlTemplateUtil.getByName(template);
        mapper.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
        FileUtil.nioWriteFile((String)mapper.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + outPutFileName));
    }

    public RpcApiAllData getApiData(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        RpcApiAllData apiAllData = new RpcApiAllData();
        apiAllData.setProjectId(DocUtil.generateId(config.getProjectName()));
        apiAllData.setLanguage(config.getLanguage().getCode());
        apiAllData.setProjectName(config.getProjectName());
        apiAllData.setApiDocList(this.listOfApiData(config, javaProjectBuilder));
        apiAllData.setErrorCodeList(DocUtil.errorCodeDictToList(config, javaProjectBuilder));
        apiAllData.setRevisionLogs(config.getRevisionLogs());
        apiAllData.setApiDocDictList(DocUtil.buildDictionary(config, javaProjectBuilder));
        apiAllData.setDependencyList(config.getRpcApiDependencies());
        return apiAllData;
    }

    private List<RpcApiDoc> listOfApiData(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        this.checkAndInitForGetApiData(config);
        config.setMd5EncryptedHtmlName(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        return docBuildTemplate.getApiData(configBuilder).getApiDatas();
    }

    public List<RpcApiDoc> getRpcApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setShowJavaType(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework(), config.getClassLoader());
        Objects.requireNonNull(docBuildTemplate, "doc build template is null");
        return docBuildTemplate.getApiData(configBuilder).getApiDatas();
    }
}

