/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.rpc;

import com.ly.doc.builder.rpc.RpcDocBuilderTemplate;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.rpc.RpcApiDoc;
import com.power.common.util.DateTimeUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class RpcMarkdownBuilder {
    private static final String API_EXTENSION = "Api.md";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        RpcMarkdownBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig apiConfig, JavaProjectBuilder javaProjectBuilder) {
        apiConfig.setAdoc(Boolean.FALSE);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(apiConfig, Boolean.TRUE);
        List<RpcApiDoc> apiDocList = builderTemplate.getRpcApiDoc(apiConfig, javaProjectBuilder);
        if (apiConfig.isAllInOne()) {
            String version = apiConfig.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)"yyyyMMddHHmm");
            String docName = builderTemplate.allInOneDocName(apiConfig, "rpc-all" + version, ".md");
            builderTemplate.buildAllInOne(apiDocList, apiConfig, javaProjectBuilder, "dubbo/DubboAllInOne.md", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, apiConfig, "dubbo/Dubbo.md", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(apiConfig, "ErrorCodeList.md", "ErrorCodeList.md", javaProjectBuilder);
        }
    }
}

