/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.builder.websocket;

import com.ly.doc.builder.DocBuilderTemplate;
import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.factory.BuildTemplateFactory;
import com.ly.doc.helper.JavaProjectBuilderHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.template.IWebSocketDocBuildTemplate;
import com.power.common.util.DateTimeUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class WebSocketMarkdownBuilder {
    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        WebSocketMarkdownBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, Boolean.TRUE);
        config.setAdoc(false);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IWebSocketDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getWebSocketDocBuildTemplate(config.getFramework(), config.getClassLoader());
        List<WebSocketDoc> webSocketDocList = docBuildTemplate.getWebSocketData(configBuilder);
        if (null == webSocketDocList || webSocketDocList.isEmpty()) {
            return;
        }
        String version = config.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)"yyyyMMddHHmm");
        String docName = builderTemplate.allInOneDocName(config, "WebSocket" + version + ".md", ".md");
        builderTemplate.buildWebSocket(webSocketDocList, config, javaProjectBuilder, "WebSocket.md", docName);
    }
}

