/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.constants;

import com.power.common.util.StringUtil;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum FrameworkEnum {
    DUBBO("dubbo", "com.ly.doc.template.RpcDocBuildTemplate"),
    JAVADOC("javadoc", "com.ly.doc.template.JavadocDocBuildTemplate"),
    SPRING("spring", "com.ly.doc.template.SpringBootDocBuildTemplate"),
    SOLON("solon", "com.ly.doc.template.SolonDocBuildTemplate"),
    JAX_RS("JAX-RS", "com.ly.doc.template.JAXRSDocBuildTemplate");

    private final String framework;
    private final String className;

    private FrameworkEnum(String framework, String className) {
        this.framework = framework;
        this.className = className;
    }

    public static String getClassNameByFramework(String framework) {
        String className = "";
        if (StringUtil.isEmpty((String)framework)) {
            return className;
        }
        for (FrameworkEnum frameworkEnum : FrameworkEnum.values()) {
            if (!frameworkEnum.framework.equalsIgnoreCase(framework)) continue;
            className = frameworkEnum.className;
            break;
        }
        return className;
    }

    public static String allFramework() {
        return Arrays.stream(FrameworkEnum.values()).map(FrameworkEnum::getFramework).collect(Collectors.joining(","));
    }

    public String getFramework() {
        return this.framework;
    }

    public String getClassName() {
        return this.className;
    }
}

