/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.factory;

import com.ly.doc.constants.FrameworkEnum;
import com.ly.doc.model.IDoc;
import com.ly.doc.model.WebSocketDoc;
import com.ly.doc.template.IDocBuildTemplate;
import com.ly.doc.template.IWebSocketDocBuildTemplate;
import java.util.ServiceLoader;

public class BuildTemplateFactory {
    public static <T extends IDoc> IDocBuildTemplate<T> getDocBuildTemplate(String framework, ClassLoader classLoader) {
        ServiceLoader<IDocBuildTemplate> loader = ServiceLoader.load(IDocBuildTemplate.class, classLoader);
        for (IDocBuildTemplate template : loader) {
            if (!template.supportsFramework(framework)) continue;
            return template;
        }
        throw new RuntimeException("The framework=>" + framework + " is not found , smart-doc currently supported framework name can only be set in [" + FrameworkEnum.allFramework() + "].");
    }

    public static <T extends WebSocketDoc> IWebSocketDocBuildTemplate<T> getWebSocketDocBuildTemplate(String framework, ClassLoader classLoader) {
        ServiceLoader<IWebSocketDocBuildTemplate> loader = ServiceLoader.load(IWebSocketDocBuildTemplate.class, classLoader);
        for (IWebSocketDocBuildTemplate template : loader) {
            if (!template.supportsFramework(framework)) continue;
            return template;
        }
        throw new RuntimeException("The framework=>" + framework + " is not found , smart-doc currently supported framework name can only be set in [" + FrameworkEnum.allFramework() + "].");
    }
}

