/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.filter;

import com.ly.doc.filter.BoxReturnFilter;
import com.ly.doc.filter.DefaultReturnFilter;
import com.ly.doc.filter.ReturnTypeFilter;
import com.ly.doc.filter.WebFluxReturnFilter;
import com.ly.doc.model.ApiReturn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReturnTypeProcessor {
    private List<ReturnTypeFilter> filters = new ArrayList<ReturnTypeFilter>();
    private String typeName;

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public ApiReturn process() {
        this.filters.add(new WebFluxReturnFilter());
        this.filters.add(new BoxReturnFilter());
        this.filters.add(new DefaultReturnFilter());
        for (ReturnTypeFilter filter : this.filters) {
            ApiReturn apiReturn = filter.doFilter(this.typeName);
            if (!Objects.nonNull(apiReturn)) continue;
            return apiReturn;
        }
        return null;
    }
}

