/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.handler;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.annotation.HeaderAnnotation;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaFieldUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface IHeaderHandler {
    default public List<ApiReqParam> handle(JavaMethod method, ProjectDocConfigBuilder projectBuilder) {
        Map<String, String> constantsMap = projectBuilder.getConstantsMap();
        ArrayList<ApiReqParam> mappingHeaders = new ArrayList<ApiReqParam>();
        List annotations = method.getAnnotations();
        HeaderAnnotation headerAnnotation = this.getHeaderAnnotation();
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getValue();
            Object headersObject = annotation.getNamedParameter("headers");
            if (!this.isMapping(annotationName) || Objects.isNull(headersObject)) continue;
            String mappingHeader = StringUtil.removeQuotes((String)headersObject.toString());
            if (!mappingHeader.startsWith("[")) {
                this.processMappingHeaders(mappingHeader, mappingHeaders);
                continue;
            }
            LinkedList headers = (LinkedList)headersObject;
            for (String str : headers) {
                String header = StringUtil.removeQuotes((String)str);
                if (header.startsWith("!")) continue;
                this.processMappingHeaders(header, mappingHeaders);
            }
        }
        ArrayList<ApiReqParam> reqHeaders = new ArrayList<ApiReqParam>();
        block2: for (JavaParameter javaParameter : method.getParameters()) {
            List javaAnnotations = javaParameter.getAnnotations();
            String className = method.getDeclaringClass().getCanonicalName();
            Map<String, String> paramMap = DocUtil.getCommentsByTag(method, "param", className);
            String paramName = javaParameter.getName();
            JavaType javaType = javaParameter.getType();
            String simpleTypeName = javaType.getValue();
            for (JavaAnnotation annotation : javaAnnotations) {
                String annotationName = annotation.getType().getValue();
                if (!headerAnnotation.getAnnotationName().equals(annotationName)) continue;
                ApiReqParam apiReqHeader = new ApiReqParam();
                Map requestHeaderMap = annotation.getNamedParameterMap();
                if (requestHeaderMap.get(headerAnnotation.getValueProp()) != null) {
                    ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
                    String attrValue = DocUtil.handleRequestHeaderValue(classLoader, annotation);
                    String constValue = ((String)requestHeaderMap.get(headerAnnotation.getValueProp())).replaceAll("\"", "");
                    if (StringUtil.isEmpty((String)attrValue)) {
                        String value = constantsMap.get(constValue);
                        if (value != null) {
                            apiReqHeader.setName(value.toString());
                        } else {
                            apiReqHeader.setName(constValue);
                        }
                    } else {
                        apiReqHeader.setName(attrValue);
                    }
                } else {
                    apiReqHeader.setName(paramName);
                }
                StringBuilder desc = new StringBuilder();
                String comments = paramMap.get(paramName);
                desc.append(DocUtil.paramCommentResolve(comments));
                String mockValue = JavaFieldUtil.createMockValue(paramMap, paramName, javaType.getGenericCanonicalName(), simpleTypeName);
                apiReqHeader.setValue(mockValue);
                if (requestHeaderMap.get(headerAnnotation.getDefaultValueProp()) != null) {
                    apiReqHeader.setValue(StringUtil.removeQuotes((String)((String)requestHeaderMap.get(headerAnnotation.getDefaultValueProp()))));
                    desc.append("(defaultValue: ").append(StringUtil.removeQuotes((String)((String)requestHeaderMap.get(headerAnnotation.getDefaultValueProp())))).append(")");
                }
                apiReqHeader.setDesc(desc.toString());
                if (requestHeaderMap.get(headerAnnotation.getRequiredProp()) != null) {
                    apiReqHeader.setRequired(!Boolean.FALSE.toString().equals(requestHeaderMap.get(headerAnnotation.getRequiredProp())));
                } else {
                    apiReqHeader.setRequired(true);
                }
                String typeName = javaParameter.getType().getValue().toLowerCase();
                apiReqHeader.setType(DocClassUtil.processTypeNameForParams(typeName));
                reqHeaders.add(apiReqHeader);
                continue block2;
            }
        }
        return Stream.of(mappingHeaders, reqHeaders).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    default public void processMappingHeaders(String header, List<ApiReqParam> mappingHeaders) {
        if (header.contains("!=")) {
            String headerName = header.substring(0, header.indexOf("!"));
            ApiReqParam apiReqHeader = ApiReqParam.builder().setName(headerName).setRequired(true).setValue(null).setDesc("header condition").setType("string");
            mappingHeaders.add(apiReqHeader);
        } else {
            String headerName;
            String headerValue = null;
            if (header.contains("=")) {
                int index = header.indexOf("=");
                headerName = header.substring(0, index);
                headerValue = header.substring(index + 1);
            } else {
                headerName = header;
            }
            ApiReqParam apiReqHeader = ApiReqParam.builder().setName(headerName).setRequired(true).setValue(headerValue).setDesc("header condition").setType("string");
            mappingHeaders.add(apiReqHeader);
        }
    }

    public boolean isMapping(String var1);

    public HeaderAnnotation getHeaderAnnotation();
}

