/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.handler;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JaxrsHeaderHandler {
    public List<ApiReqParam> handle(JavaMethod method, ProjectDocConfigBuilder projectBuilder) {
        Map<String, String> constantsMap = projectBuilder.getConstantsMap();
        ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
        ArrayList<ApiReqParam> apiReqHeaders = new ArrayList<ApiReqParam>();
        List parameters = method.getParameters();
        for (JavaParameter javaParameter : parameters) {
            List annotations = javaParameter.getAnnotations();
            String paramName = javaParameter.getName();
            ApiReqParam apiReqHeader = new ApiReqParam();
            String defaultValue = "";
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getFullyQualifiedName();
                if ("jakarta.ws.rs.DefaultValue".equals(annotationName) || "javax.ws.rs.DefaultValue".equals(annotationName)) {
                    defaultValue = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(classLoader, annotation));
                    defaultValue = DocUtil.handleConstants(constantsMap, defaultValue);
                }
                apiReqHeader.setValue(defaultValue);
                if (!"jakarta.ws.rs.HeaderParam".equals(annotationName) && !"javax.ws.rs.HeaderParam".equals(annotationName)) continue;
                String name = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(classLoader, annotation));
                name = DocUtil.handleConstants(constantsMap, name);
                apiReqHeader.setName(name);
                String typeName = javaParameter.getType().getValue().toLowerCase();
                apiReqHeader.setType(DocClassUtil.processTypeNameForParams(typeName));
                String className = method.getDeclaringClass().getCanonicalName();
                Map<String, String> paramMap = DocUtil.getCommentsByTag(method, "param", className);
                String paramComments = paramMap.get(paramName);
                apiReqHeader.setDesc(this.getComments(defaultValue, paramComments));
                apiReqHeaders.add(apiReqHeader);
            }
        }
        return apiReqHeaders;
    }

    private String getComments(String defaultValue, String paramComments) {
        if (Objects.nonNull(paramComments)) {
            StringBuilder desc = new StringBuilder();
            desc.append(paramComments);
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                desc.append("(defaultValue: ").append(defaultValue).append(")");
            }
            return desc.toString();
        }
        return "";
    }
}

