/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.handler;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.Methods;
import com.ly.doc.function.RequestMappingFunc;
import com.ly.doc.handler.IRequestMappingHandler;
import com.ly.doc.handler.IWebSocketRequestHandler;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.annotation.MappingAnnotation;
import com.ly.doc.model.request.RequestMapping;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpringMVCRequestMappingHandler
implements IRequestMappingHandler,
IWebSocketRequestHandler {
    @Override
    public RequestMapping handle(ProjectDocConfigBuilder projectBuilder, String controllerBaseUrl, JavaMethod method, FrameworkAnnotations frameworkAnnotations, RequestMappingFunc requestMappingFunc) {
        if (Objects.nonNull(method.getTagByName("ignore"))) {
            return null;
        }
        List<JavaAnnotation> annotations = this.getAnnotations(method);
        String methodType = null;
        String shortUrl = null;
        String mediaType = null;
        boolean deprecated = Objects.nonNull(method.getTagByName("deprecated"));
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : annotations) {
            MappingAnnotation mappingAnnotation;
            String annotationName = annotation.getType().getName();
            if ("Deprecated".equals(annotationName = JavaClassUtil.getClassSimpleName(annotationName))) {
                deprecated = true;
            }
            if (Objects.isNull(mappingAnnotation = mappingAnnotationMap.get(annotationName))) continue;
            Object consumes = annotation.getNamedParameter("consumes");
            if (Objects.nonNull(consumes)) {
                mediaType = consumes.toString();
            }
            if (CollectionUtil.isNotEmpty(mappingAnnotation.getPathProps())) {
                ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
                shortUrl = DocUtil.getPathUrl(classLoader, annotation, mappingAnnotation.getPathProps().toArray(new String[0]));
            }
            if (StringUtil.isNotEmpty((String)mappingAnnotation.getMethodType())) {
                methodType = mappingAnnotation.getMethodType();
                continue;
            }
            Object nameParam = annotation.getNamedParameter(mappingAnnotation.getMethodProp());
            if (Objects.nonNull(nameParam)) {
                methodType = nameParam.toString();
                methodType = DocUtil.handleHttpMethod(methodType);
                continue;
            }
            methodType = Methods.GET.getValue();
        }
        RequestMapping requestMapping = RequestMapping.builder().setMediaType(mediaType).setMethodType(methodType).setDeprecated(deprecated).setShortUrl(shortUrl);
        requestMapping = this.formatMappingData(projectBuilder, controllerBaseUrl, requestMapping);
        requestMappingFunc.process(method.getDeclaringClass(), requestMapping);
        return requestMapping;
    }
}

