/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.helper;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.helper.GitHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.IDoc;
import com.ly.doc.model.IMethod;
import com.ly.doc.model.dependency.ApiDependency;
import com.ly.doc.model.dependency.DependencyTree;
import com.ly.doc.model.dependency.FileDiff;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jgit.diff.DiffEntry;

public class DocBuildHelper {
    private JavaProjectBuilder projectBuilder;
    private String codePath;
    private DependencyTree dependencyTree;
    private final GitHelper gitHelper = GitHelper.create();
    private Set<FileDiff> fileDiffList = Collections.emptySet();

    private DocBuildHelper() {
    }

    public static DocBuildHelper create(ProjectDocConfigBuilder configBuilder) {
        ApiConfig apiConfig = configBuilder.getApiConfig();
        String baseDir = apiConfig.getBaseDir();
        String codePath = apiConfig.getCodePath();
        if (StringUtil.isEmpty((String)baseDir)) {
            throw new RuntimeException("ERROR: The baseDir can't be empty.");
        }
        if (StringUtil.isEmpty((String)codePath)) {
            throw new RuntimeException("ERROR: The codePath can't be empty.");
        }
        DocBuildHelper helper = new DocBuildHelper();
        helper.projectBuilder = configBuilder.getJavaProjectBuilder();
        helper.codePath = codePath;
        if (helper.gitHelper.isGitRepo()) {
            helper.dependencyTree = DependencyTree.detect(baseDir, apiConfig.isIncrement());
        }
        return helper;
    }

    public DependencyTree getDependencyTree() {
        return this.dependencyTree;
    }

    private void writeDependencyTree(List<ApiDependency> dependencyTree) {
        if (this.gitHelper.notGitRepo()) {
            return;
        }
        String commitId = this.gitHelper.getLatestCommitId();
        if (dependencyTree == null) {
            dependencyTree = Collections.emptyList();
        }
        List<ApiDependency> mergedDependencyTree = this.mergeDependencyTree(dependencyTree);
        this.dependencyTree.setConfig(commitId, mergedDependencyTree);
        DependencyTree.write(this.dependencyTree);
    }

    private List<ApiDependency> mergeDependencyTree(List<ApiDependency> newDependencyTree) {
        if (Objects.isNull(this.dependencyTree.getDependencyTree())) {
            return new ArrayList<ApiDependency>();
        }
        ArrayList<ApiDependency> oldDependencyTree = new ArrayList<ApiDependency>(this.dependencyTree.getDependencyTree());
        List deletedClazz = this.fileDiffList.stream().filter(item -> "/dev/null".equals(item.getNewQualifiedName())).map(FileDiff::getOldQualifiedName).distinct().collect(Collectors.toList());
        List newDependencyApiClasses = newDependencyTree.stream().map(ApiDependency::getClazz).distinct().collect(Collectors.toList());
        List deprecatedClazz = this.fileDiffList.stream().filter(FileDiff::isEntryPoint).map(FileDiff::getNewQualifiedName).filter(item -> {
            boolean contains = newDependencyApiClasses.contains(item);
            if (contains) {
                return false;
            }
            try {
                JavaClass cls = this.projectBuilder.getClassByName(item);
                List clsImplements = cls.getImplements();
                if (CollectionUtil.isNotEmpty((Collection)clsImplements) && !cls.isInterface()) {
                    return clsImplements.stream().map(JavaType::getCanonicalName).noneMatch(newDependencyApiClasses::contains);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }).collect(Collectors.toList());
        oldDependencyTree.removeIf(dependency -> deletedClazz.contains(dependency.getClazz()) || deprecatedClazz.contains(dependency.getClazz()) || deprecatedClazz.stream().anyMatch(deprecate -> dependency.getDerivedClazz().contains(deprecate)));
        oldDependencyTree.replaceAll(dependency -> {
            String docClazz = dependency.getClazz();
            ApiDependency apiDependency = newDependencyTree.stream().filter(newDependency -> docClazz.equals(newDependency.getClazz())).findFirst().orElse((ApiDependency)dependency);
            newDependencyTree.removeIf(newDependency -> newDependency.equals(apiDependency));
            return apiDependency;
        });
        if (CollectionUtil.isNotEmpty(newDependencyTree)) {
            oldDependencyTree.addAll(newDependencyTree);
        }
        return oldDependencyTree;
    }

    public Set<FileDiff> getChangedFilesFromVCS(Predicate<String> isEntryPoint) {
        String commitId = this.dependencyTree.getCommitId();
        ArrayList<DiffEntry> diff = new ArrayList<DiffEntry>(this.gitHelper.getDiff(commitId));
        HashSet<String> uncommitted = new HashSet<String>(this.gitHelper.getUncommitted());
        HashSet<String> untracked = new HashSet<String>(this.gitHelper.getUntracked());
        if (CollectionUtil.isEmpty(diff) && CollectionUtil.isEmpty(uncommitted) && CollectionUtil.isEmpty(untracked)) {
            return Collections.emptySet();
        }
        Set<FileDiff> fileDiffList = this.getChangedFiles(diff, uncommitted, untracked);
        this.populateRelatedClazzAndMarkEntryPoint(fileDiffList, isEntryPoint);
        this.fileDiffList = fileDiffList;
        return fileDiffList;
    }

    private Set<FileDiff> getChangedFiles(List<DiffEntry> diff, Set<String> uncommitted, Set<String> untracked) {
        diff.removeIf(item -> !this.isSupportedSourceCodeType(item.getNewPath()));
        uncommitted.removeIf(item -> !this.isSupportedSourceCodeType((String)item));
        untracked.removeIf(item -> !this.isSupportedSourceCodeType((String)item));
        HashSet<FileDiff> diffList = new HashSet<FileDiff>(diff.size() + uncommitted.size() + untracked.size());
        diff.forEach(entry -> {
            FileDiff fileDiff = new FileDiff();
            String changeType = entry.getChangeType().name();
            fileDiff.setChangeType(FileDiff.ChangeType.valueOf(changeType));
            fileDiff.setOldQualifiedName(this.toQualifiedName(entry.getOldPath()));
            fileDiff.setNewQualifiedName(this.toQualifiedName(entry.getNewPath()));
            diffList.add(fileDiff);
        });
        uncommitted.forEach(path -> {
            FileDiff fileDiff = new FileDiff();
            fileDiff.setChangeType(FileDiff.ChangeType.UNCOMMITTED);
            fileDiff.setNewQualifiedName(this.toQualifiedName((String)path));
            diffList.add(fileDiff);
        });
        untracked.forEach(path -> {
            FileDiff fileDiff = new FileDiff();
            fileDiff.setChangeType(FileDiff.ChangeType.UNTRACKED);
            fileDiff.setNewQualifiedName(this.toQualifiedName((String)path));
            diffList.add(fileDiff);
        });
        return diffList;
    }

    private String toQualifiedName(String relativePath) {
        if ("/dev/null".equals(relativePath)) {
            return relativePath;
        }
        int index = relativePath.indexOf(this.codePath);
        if (index < 0) {
            return relativePath;
        }
        String filePath = relativePath.substring(index + this.codePath.length() + 1);
        if (StringUtil.isEmpty((String)filePath)) {
            return relativePath;
        }
        if (this.isSupportedSourceCodeType(filePath)) {
            int lastIndex = filePath.lastIndexOf(".");
            filePath = filePath.substring(0, lastIndex);
        }
        return filePath.replace(File.separator, ".");
    }

    private boolean isSupportedSourceCodeType(String path) {
        return path.endsWith(".java") || path.endsWith(".kt") || path.endsWith(".groovy") || path.endsWith(".scala");
    }

    private void populateRelatedClazzAndMarkEntryPoint(Set<FileDiff> diffList, Predicate<String> isEntryPoint) {
        List<ApiDependency> oldDependencyTree = this.dependencyTree.getDependencyTree();
        if (CollectionUtil.isEmpty(oldDependencyTree)) {
            return;
        }
        oldDependencyTree.forEach(dependency -> {
            String clazz = dependency.getClazz();
            Optional<FileDiff> matchClazzOptional = diffList.stream().filter(item -> {
                boolean equals = clazz.equals(item.getNewQualifiedName());
                if (equals) {
                    return true;
                }
                List<String> derivedClazz = dependency.getDerivedClazz();
                if (CollectionUtil.isEmpty(derivedClazz)) {
                    return false;
                }
                return dependency.getDerivedClazz().contains(item.getNewQualifiedName());
            }).findFirst();
            if (matchClazzOptional.isPresent()) {
                matchClazzOptional.get().setEntryPoint(true);
                return;
            }
            dependency.getApis().forEach(apiInfo -> {
                boolean matchArgs = apiInfo.getArgs().stream().anyMatch(item -> diffList.stream().anyMatch(diff -> item.equals(diff.getNewQualifiedName())));
                boolean matchReturns = apiInfo.getReturns().stream().anyMatch(item -> diffList.stream().anyMatch(diff -> item.equals(diff.getNewQualifiedName())));
                if (matchArgs || matchReturns) {
                    FileDiff fileDiff = new FileDiff();
                    fileDiff.setChangeType(FileDiff.ChangeType.RELATED);
                    fileDiff.setNewQualifiedName(clazz);
                    fileDiff.setEntryPoint(true);
                    diffList.add(fileDiff);
                }
            });
        });
        diffList.stream().filter(item -> !item.isEntryPoint()).forEach(item -> {
            boolean isEntry = isEntryPoint.test(item.getNewQualifiedName());
            item.setEntryPoint(isEntry);
        });
    }

    public <T extends IDoc> void rebuildDependencyTree(List<T> apiList) {
        List<ApiDependency> dependencyTree = this.buildDependencyTree(apiList);
        this.writeDependencyTree(dependencyTree);
    }

    private <T extends IDoc> List<ApiDependency> buildDependencyTree(List<T> apiList) {
        if (CollectionUtil.isEmpty(apiList)) {
            return Collections.emptyList();
        }
        ArrayList<ApiDependency> dependencyTree = new ArrayList<ApiDependency>(apiList.size());
        for (IDoc apiDoc : apiList) {
            String docClass = apiDoc.getDocClass();
            List<IMethod> docMethods = apiDoc.getMethods();
            ArrayList<ApiDependency.ApiInfo> apiInfoList = new ArrayList<ApiDependency.ApiInfo>(docMethods.size());
            List<String> derivedClazz = docMethods.stream().map(IMethod::getDeclaringClass).filter(Objects::nonNull).map(JavaType::getFullyQualifiedName).distinct().collect(Collectors.toList());
            ApiDependency apiDependency = new ApiDependency(docClass, derivedClazz, apiInfoList);
            dependencyTree.add(apiDependency);
            for (IMethod docMethod : docMethods) {
                String methodName = docMethod.getMethodName();
                List<String> argsClasses = docMethod.getArgsClasses();
                List<String> returnClasses = docMethod.getReturnClasses();
                ApiDependency.ApiInfo apiInfo = new ApiDependency.ApiInfo(methodName, argsClasses, returnClasses);
                apiInfoList.add(apiInfo);
            }
        }
        return dependencyTree;
    }

    public boolean notGitRepo() {
        return this.gitHelper.notGitRepo();
    }
}

