/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.helper;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.helper.BaseHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.CustomField;
import com.ly.doc.model.DocJavaField;
import com.ly.doc.model.FormData;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.JavaFieldUtil;
import com.ly.doc.utils.ParamUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FormDataBuildHelper
extends BaseHelper {
    public static List<FormData> getFormData(String className, Map<String, String> registryClasses, int counter, ProjectDocConfigBuilder builder, String pre, Set<String> groupClasses) {
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ApiConfig apiConfig = builder.getApiConfig();
        ClassLoader classLoader = builder.getApiConfig().getClassLoader();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        if (counter > apiConfig.getRecursionLimit()) {
            return formDataList;
        }
        if (registryClasses.containsKey(className) && counter > registryClasses.size()) {
            return formDataList;
        }
        registryClasses.put(className, className);
        ++counter;
        boolean skipTransientField = apiConfig.isSkipTransientField();
        boolean requestFieldToUnderline = apiConfig.isRequestFieldToUnderline();
        boolean responseFieldToUnderline = apiConfig.isResponseFieldToUnderline();
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = builder.getJavaProjectBuilder().getClassByName(simpleName);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>(), builder.getApiConfig().getClassLoader());
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            FormData formData = new FormData();
            formData.setKey(pre);
            formData.setType("text");
            formData.setValue(StringUtil.removeQuotes((String)RandomUtil.randomValueByType((String)className)));
            formDataList.add(formData);
            return formDataList;
        }
        if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            String gicName = globGicName[0];
            if (JavaClassValidateUtil.isArray(gicName)) {
                gicName = gicName.substring(0, gicName.indexOf("["));
            }
            if (JavaClassValidateUtil.isPrimitive(gicName)) {
                pre = pre.substring(0, pre.lastIndexOf("."));
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicName, registryClasses, counter, builder, pre + "[]", groupClasses));
        }
        int n = 0;
        block0: for (DocJavaField docField : fields) {
            JavaField field = docField.getJavaField();
            String fieldName = field.getName();
            String subTypeName = docField.getTypeFullyQualifiedName();
            String fieldGicName = docField.getTypeGenericCanonicalName();
            JavaClass javaClass = field.getType();
            if (field.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName) || field.isTransient() && skipTransientField) continue;
            List<JavaAnnotation> javaAnnotations = docField.getAnnotations();
            for (JavaAnnotation annotation : javaAnnotations) {
                String simpleAnnotationName = annotation.getType().getValue();
                if (!"Null".equals(simpleAnnotationName)) continue;
                if (CollectionUtil.isEmpty(groupClasses)) continue block0;
                Set<String> groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                for (String javaClassName : groupClassList) {
                    if (!groupClasses.contains(javaClassName)) continue;
                    continue block0;
                }
            }
            if (responseFieldToUnderline || requestFieldToUnderline) {
                fieldName = StringUtil.camelToUnderline((String)fieldName);
            }
            Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field, docField);
            String typeSimpleName = field.getType().getSimpleName();
            if (JavaClassValidateUtil.isMap(subTypeName)) continue;
            String comment = docField.getComment() + JavaFieldUtil.getJsrComment(apiConfig.isShowValidation(), classLoader, javaAnnotations);
            if (JavaClassValidateUtil.isFile(fieldGicName)) {
                FormData formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("file");
                if (fieldGicName.contains("[]") || fieldGicName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    formData.setType("file");
                }
                formData.setDescription(comment);
                formData.setValue("");
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                String fieldValue = FormDataBuildHelper.getFieldValueFromMock(tagsMap);
                if (StringUtil.isEmpty((String)fieldValue)) {
                    fieldValue = DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                }
                CustomField.Key key = CustomField.Key.create(docField.getDeclaringClassName(), fieldName);
                CustomField customRequestField = builder.getCustomReqFieldMap().get(key);
                if (Objects.nonNull(customRequestField) && Objects.nonNull(customRequestField.getValue()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName())) {
                    fieldValue = String.valueOf(customRequestField.getValue());
                }
                FormData formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("text");
                formData.setValue(fieldValue);
                formData.setDescription(comment);
                formDataList.add(formData);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                    value = ParamUtil.formatMockValue(tagsMap.get("mock"));
                }
                FormData formData = new FormData();
                formData.setKey(pre + fieldName);
                formData.setType("text");
                formData.setValue(StringUtil.removeQuotes((String)String.valueOf(value)));
                formData.setDescription(comment);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isCollection(subTypeName) || JavaClassValidateUtil.isArray(subTypeName)) {
                String gNameTemp = field.getType().getGenericCanonicalName();
                String[] gNameArr = DocClassUtil.getSimpleGicName(gNameTemp);
                if (gNameArr.length == 0) continue;
                String gName = DocClassUtil.getSimpleGicName(gNameTemp)[0];
                if (JavaClassValidateUtil.isPrimitive(gName)) {
                    String fieldValue = FormDataBuildHelper.getFieldValueFromMock(tagsMap);
                    if (StringUtil.isEmpty((String)fieldValue)) {
                        fieldValue = DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                        fieldValue = fieldValue + "," + fieldValue;
                    }
                    FormData formData = new FormData();
                    formData.setKey(pre + fieldName);
                    formData.setType("text");
                    formData.setValue(fieldValue);
                    formData.setDescription(comment);
                    formDataList.add(formData);
                    continue;
                }
                if (simpleName.equals(gName)) continue;
                if (gName.length() == 1) {
                    String gicName;
                    int len = globGicName.length;
                    if (len <= 0 || JavaClassValidateUtil.isPrimitive(gicName = globGicName[n]) || simpleName.equals(gicName)) continue;
                    formDataList.addAll(FormDataBuildHelper.getFormData(gicName, registryClasses, counter, builder, pre + fieldName + "[0].", groupClasses));
                    continue;
                }
                formDataList.addAll(FormDataBuildHelper.getFormData(gName, registryClasses, counter, builder, pre + fieldName + "[0].", groupClasses));
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(javaClass.getGenericFullyQualifiedName(), registryClasses, counter, builder, pre + fieldName + ".", groupClasses));
        }
        return formDataList;
    }
}

