/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.helper;

import com.power.common.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class GitHelper {
    private Repository repository;

    private GitHelper() {
    }

    public static GitHelper create() {
        GitHelper helper = new GitHelper();
        helper.repository = helper.findRepo();
        return helper;
    }

    public List<DiffEntry> getDiff(String commitId) {
        List list;
        if (StringUtil.isEmpty((String)commitId) || this.notGitRepo()) {
            return Collections.emptyList();
        }
        Git git = new Git(this.repository);
        try {
            ObjectId commitObjectId = this.repository.resolve(commitId);
            RevCommit commit = new RevWalk(this.repository).parseCommit((AnyObjectId)commitObjectId);
            ObjectId treeId = commit.getTree().getId();
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            try (ObjectReader reader = this.repository.newObjectReader();){
                oldTreeIter.reset(reader, (AnyObjectId)treeId);
            }
            ObjectId currentTreeId = this.repository.resolve("HEAD^{tree}");
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            try (ObjectReader reader = this.repository.newObjectReader();){
                newTreeIter.reset(reader, (AnyObjectId)currentTreeId);
            }
            list = git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).call();
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GitAPIException e) {
                throw new RuntimeException(e);
            }
        }
        git.close();
        return list;
    }

    public Set<String> getUncommitted() {
        Set set;
        if (this.notGitRepo()) {
            return Collections.emptySet();
        }
        Git git = new Git(this.repository);
        try {
            set = git.status().call().getUncommittedChanges();
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (GitAPIException e) {
                throw new RuntimeException(e);
            }
        }
        git.close();
        return set;
    }

    public Set<String> getUntracked() {
        Set set;
        if (this.notGitRepo()) {
            return Collections.emptySet();
        }
        Git git = new Git(this.repository);
        try {
            set = git.status().call().getUntracked();
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (GitAPIException e) {
                throw new RuntimeException(e);
            }
        }
        git.close();
        return set;
    }

    public String getLatestCommitId() {
        if (this.notGitRepo()) {
            return "";
        }
        try {
            ObjectId objectId = this.repository.resolve("HEAD");
            if (null == objectId) {
                return "";
            }
            return objectId.getName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Repository findRepo() {
        try {
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            System.err.println("WARN: When detecting git repository, got exception:" + e.getMessage() + " Ignore it if this is not a git repository");
            return null;
        }
    }

    public boolean notGitRepo() {
        return this.repository == null;
    }

    public boolean isGitRepo() {
        return !this.notGitRepo();
    }

    public String getWorkDir() {
        return this.repository.getWorkTree().getAbsolutePath();
    }
}

