/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.helper;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.extension.json.PropertyNameHelper;
import com.ly.doc.extension.json.PropertyNamingStrategies;
import com.ly.doc.helper.BaseHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDataDictionary;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.CustomField;
import com.ly.doc.model.DocJavaField;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.JavaFieldUtil;
import com.ly.doc.utils.ParamUtil;
import com.power.common.model.EnumDictionary;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParamsBuildHelper
extends BaseHelper {
    public static List<ApiParam> buildParams(String className, String pre, int level, String isRequired, boolean isResp, Map<String, String> registryClasses, ProjectDocConfigBuilder projectBuilder, Set<String> groupClasses, int pid, boolean jsonRequest, AtomicInteger atomicInteger) {
        HashMap<String, String> genericMap = new HashMap<String, String>(10);
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        int nextLevel = level + 1;
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (level > apiConfig.getRecursionLimit()) {
            return paramList;
        }
        if (registryClasses.containsKey(className) && level > registryClasses.size()) {
            return paramList;
        }
        boolean skipTransientField = apiConfig.isSkipTransientField();
        boolean isShowJavaType = projectBuilder.getApiConfig().getShowJavaType();
        boolean requestFieldToUnderline = projectBuilder.getApiConfig().isRequestFieldToUnderline();
        boolean responseFieldToUnderline = projectBuilder.getApiConfig().isResponseFieldToUnderline();
        boolean displayActualType = projectBuilder.getApiConfig().isDisplayActualType();
        registryClasses.put(className, className);
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = projectBuilder.getClassByName(simpleName);
        if (Objects.isNull(globGicName) || globGicName.length < 1) {
            JavaClass superJavaClass;
            JavaClass javaClass = superJavaClass = cls != null ? cls.getSuperJavaClass() : null;
            if (superJavaClass != null && !"Object".equals(superJavaClass.getSimpleName())) {
                globGicName = DocClassUtil.getSimpleGicName(superJavaClass.getGenericFullyQualifiedName());
            }
        }
        PropertyNamingStrategies.NamingBase fieldNameConvert = null;
        if (Objects.nonNull(cls)) {
            List clsAnnotation = cls.getAnnotations();
            fieldNameConvert = PropertyNameHelper.translate(clsAnnotation);
        }
        JavaClassUtil.genericParamMap(genericMap, cls, globGicName);
        List<DocJavaField> fields = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>(), classLoader);
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            String processedType = ParamsBuildHelper.processFieldTypeName(isShowJavaType, simpleName);
            paramList.addAll(ParamsBuildHelper.primitiveReturnRespComment(processedType, atomicInteger, pid));
        } else if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            if (!JavaClassValidateUtil.isCollection(globGicName[0])) {
                String gName;
                String gNameTemp = globGicName[0];
                String string = gName = JavaClassValidateUtil.isArray(gNameTemp) ? gNameTemp.substring(0, gNameTemp.indexOf("[")) : globGicName[0];
                if (JavaClassValidateUtil.isPrimitive(gName)) {
                    String processedType = isShowJavaType ? JavaFieldUtil.convertToSimpleTypeName(simpleName) : DocClassUtil.processTypeNameForParams(gName);
                    ApiParam param = ApiParam.of().setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, pid + 1)).setField(pre + " -").setType("array[" + processedType + "]").setPid(pid).setDesc("array of " + processedType).setVersion("-").setRequired(Boolean.parseBoolean(isRequired));
                    paramList.add(param);
                } else {
                    if (JavaClassValidateUtil.isArray(gNameTemp)) {
                        gNameTemp = gNameTemp.substring(0, gNameTemp.indexOf("["));
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(gNameTemp, pre, nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest, atomicInteger));
                }
            }
        } else if (JavaClassValidateUtil.isMap(simpleName)) {
            paramList.addAll(ParamsBuildHelper.buildMapParam(globGicName, pre, level, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest, nextLevel, atomicInteger));
        } else if ("java.lang.Object".equals(className)) {
            ApiParam param = ApiParam.of().setClassName(className).setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, pid + 1)).setField(pre + "any object").setType("object").setPid(pid).setDesc("any object.").setVersion("-").setRequired(Boolean.parseBoolean(isRequired));
            paramList.add(param);
        } else if (JavaClassValidateUtil.isReactor(simpleName)) {
            if (globGicName.length > 0) {
                paramList.addAll(ParamsBuildHelper.buildParams(globGicName[0], pre, nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest, atomicInteger));
            }
        } else {
            Map<String, String> ignoreFields = JavaClassUtil.getClassJsonIgnoreFields(cls);
            block0: for (DocJavaField docField : fields) {
                int fieldPid;
                String processedType;
                ApiParam param;
                boolean needToUnderline;
                JavaField field = docField.getJavaField();
                String maxLength = JavaFieldUtil.getParamMaxLength(field.getAnnotations());
                StringBuilder comment = new StringBuilder();
                comment.append(docField.getComment());
                if (field.isTransient() && skipTransientField) continue;
                String fieldName = docField.getFieldName();
                if (Objects.nonNull(fieldNameConvert)) {
                    fieldName = fieldNameConvert.translate(fieldName);
                }
                if (ignoreFields.containsKey(fieldName)) continue;
                String subTypeName = docField.getTypeFullyQualifiedName();
                boolean bl = needToUnderline = responseFieldToUnderline && isResp || requestFieldToUnderline && !isResp;
                if (needToUnderline) {
                    fieldName = StringUtil.camelToUnderline((String)fieldName);
                }
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = docField.getTypeGenericCanonicalName();
                List<JavaAnnotation> javaAnnotations = docField.getAnnotations();
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field, docField);
                String since = "-";
                if (tagsMap.containsKey("since")) {
                    since = tagsMap.get("since");
                }
                Map<String, String> extensions = DocUtil.getCommentsByTag(field.getTagsByName("extension"), "extension");
                HashMap<String, Object> extensionParams = new HashMap<String, Object>();
                if (extensions != null && !extensions.isEmpty()) {
                    extensions.forEach((k, v) -> extensionParams.put((String)k, DocUtil.detectTagValue(v)));
                }
                boolean strRequired = false;
                CustomField.Key key = CustomField.Key.create(docField.getDeclaringClassName(), fieldName);
                CustomField customResponseField = CustomField.nameEquals(key, projectBuilder.getCustomRespFieldMap());
                CustomField customRequestField = CustomField.nameEquals(key, projectBuilder.getCustomReqFieldMap());
                if (customResponseField != null && JavaClassUtil.isTargetChildClass(docField.getDeclaringClassName(), customResponseField.getOwnerClassName()) && customResponseField.isIgnore() && isResp || customRequestField != null && JavaClassUtil.isTargetChildClass(docField.getDeclaringClassName(), customRequestField.getOwnerClassName()) && customRequestField.isIgnore() && !isResp) continue;
                String fieldJsonFormatType = null;
                String fieldJsonFormatValue = null;
                boolean toStringSerializer = false;
                for (JavaAnnotation annotation : javaAnnotations) {
                    Set<String> groupClassList;
                    if ("JsonSerialize".equals(annotation.getType().getSimpleName()) && "ToStringSerializer.class".equals(annotation.getNamedParameter("using"))) {
                        toStringSerializer = true;
                        continue;
                    }
                    if (JavaClassValidateUtil.isIgnoreFieldJson(annotation, isResp)) continue block0;
                    String simpleAnnotationName = annotation.getType().getValue();
                    if ("JSONField".equals(simpleAnnotationName)) {
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if ("JsonProperty".equals(simpleAnnotationName) || "SerializedName".equals(simpleAnnotationName)) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                        continue;
                    }
                    if ("Null".equals(simpleAnnotationName) && !isResp) {
                        if (CollectionUtil.isEmpty(groupClasses)) continue block0;
                        groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                        for (String javaClass : groupClassList) {
                            if (!groupClasses.contains(javaClass)) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (JavaClassValidateUtil.isJSR303Required(simpleAnnotationName) && !isResp) {
                        groupClassList = JavaClassUtil.getParamGroupJavaClass(annotation);
                        boolean hasGroup = groupClassList.stream().anyMatch(groupClasses::contains);
                        if (hasGroup) {
                            strRequired = true;
                            continue;
                        }
                        if (!CollectionUtil.isEmpty(groupClasses)) continue;
                        strRequired = false;
                        continue;
                    }
                    if (!"JsonFormat".equals(simpleAnnotationName)) continue;
                    fieldJsonFormatType = DocUtil.processFieldTypeNameByJsonFormat(isShowJavaType, subTypeName, annotation);
                    fieldJsonFormatValue = DocUtil.getJsonFormatString(field, annotation);
                }
                comment.append(JavaFieldUtil.getJsrComment(apiConfig.isShowValidation(), classLoader, javaAnnotations));
                String fieldValue = ParamsBuildHelper.getFieldValueFromMock(tagsMap);
                if (Objects.nonNull(customResponseField) && isResp && Objects.nonNull(customResponseField.getValue()) && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName())) {
                    fieldValue = String.valueOf(customResponseField.getValue());
                }
                if (Objects.nonNull(customRequestField) && !isResp && Objects.nonNull(customRequestField.getValue()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName())) {
                    fieldValue = String.valueOf(customRequestField.getValue());
                }
                if (customRequestField != null && !isResp && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && customRequestField.isRequire()) {
                    strRequired = true;
                }
                if (null != customRequestField && StringUtil.isNotEmpty((String)customRequestField.getDesc()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && !isResp) {
                    comment = new StringBuilder(customRequestField.getDesc());
                }
                if (null != customResponseField && StringUtil.isNotEmpty((String)customResponseField.getDesc()) && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName()) && isResp) {
                    comment = new StringBuilder(customResponseField.getDesc());
                }
                if (null != customRequestField && StringUtil.isNotEmpty((String)customRequestField.getReplaceName()) && JavaClassUtil.isTargetChildClass(simpleName, customRequestField.getOwnerClassName()) && !isResp) {
                    fieldName = customRequestField.getReplaceName();
                }
                if (null != customResponseField && StringUtil.isNotEmpty((String)customResponseField.getReplaceName()) && JavaClassUtil.isTargetChildClass(simpleName, customResponseField.getOwnerClassName()) && isResp) {
                    fieldName = customResponseField.getReplaceName();
                }
                fieldName = fieldName.trim();
                if (JavaClassValidateUtil.isFile(fieldGicName)) {
                    param = ApiParam.of().setField(pre + fieldName).setType("file").setClassName(className).setPid(pid).setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, paramList.size() + pid + 1)).setMaxLength(maxLength).setDesc(comment.toString()).setRequired(strRequired).setVersion(since).setExtensions(extensionParams);
                    if (fieldGicName.contains("[]") || fieldGicName.endsWith(">")) {
                        param.setType("file");
                        param.setDesc(comment.append("(array of file)").toString());
                        param.setHasItems(true);
                    }
                    paramList.add(param);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    if (StringUtil.isEmpty((String)fieldValue)) {
                        fieldValue = StringUtil.isNotEmpty(fieldJsonFormatValue) ? fieldJsonFormatValue : StringUtil.removeQuotes((String)DocUtil.getValByTypeAndFieldName(subTypeName, field.getName()));
                    }
                    param = ApiParam.of().setClassName(className).setField(pre + fieldName).setPid(pid).setMaxLength(maxLength).setValue(fieldValue);
                    param.setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, paramList.size() + param.getPid() + 1));
                    String processedType2 = isResp && toStringSerializer ? "string" : (StringUtil.isNotEmpty((String)fieldJsonFormatType) ? fieldJsonFormatType : ParamsBuildHelper.processFieldTypeName(isShowJavaType, subTypeName));
                    param.setType(processedType2);
                    param.setExtensions(extensionParams);
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, comment.toString(), since, strRequired);
                    JavaClass enumClass = ParamUtil.handleSeeEnum(param, field, projectBuilder, jsonRequest, tagsMap, fieldJsonFormatValue);
                    if (!Objects.nonNull(enumClass)) continue;
                    String enumClassComment = "";
                    if (StringUtil.isNotEmpty((String)enumClass.getComment())) {
                        enumClassComment = enumClass.getComment();
                    }
                    comment = new StringBuilder(StringUtils.isEmpty((CharSequence)comment.toString()) ? enumClassComment : comment.toString());
                    String enumComment = ParamsBuildHelper.handleEnumComment(enumClass, projectBuilder);
                    param.setDesc(comment + enumComment);
                    continue;
                }
                String appendComment = "";
                if (displayActualType) {
                    if (globGicName.length > 0) {
                        String gicName;
                        String string = gicName = genericMap.get(subTypeName) != null ? (String)genericMap.get(subTypeName) : globGicName[0];
                        if (!simpleName.equals(gicName)) {
                            appendComment = " (ActualType: " + JavaClassUtil.getClassSimpleName(gicName) + ")";
                        }
                    }
                    if (Objects.nonNull(docField.getActualJavaType())) {
                        appendComment = " (ActualType: " + JavaClassUtil.getClassSimpleName(docField.getActualJavaType()) + ")";
                    }
                }
                StringBuilder preBuilder = new StringBuilder();
                for (int j = 0; j < level; ++j) {
                    preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                preBuilder.append("\u2514\u2500");
                ApiParam param2 = ApiParam.of().setField(pre + fieldName).setClassName(className).setPid(pid).setMaxLength(maxLength);
                param2.setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, paramList.size() + param2.getPid() + 1));
                param2.setExtensions(extensionParams);
                if (fieldGicName.length() == 1) {
                    String gicName = "java.lang.Object";
                    if (Objects.nonNull(genericMap.get(typeSimpleName))) {
                        gicName = (String)genericMap.get(subTypeName);
                    } else if (globGicName.length > 0) {
                        gicName = globGicName[0];
                    }
                    processedType = JavaClassValidateUtil.isPrimitive(gicName) ? DocClassUtil.processTypeNameForParams(gicName) : DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                } else {
                    processedType = StringUtil.isNotEmpty((String)fieldJsonFormatType) ? fieldJsonFormatType : ParamsBuildHelper.processFieldTypeName(isShowJavaType, subTypeName);
                }
                param2.setType(processedType);
                JavaClass javaClass = field.getType();
                if (javaClass.isEnum()) {
                    comment.append(ParamsBuildHelper.handleEnumComment(javaClass, projectBuilder));
                    ParamUtil.handleSeeEnum(param2, field, projectBuilder, jsonRequest, tagsMap, fieldJsonFormatValue);
                    ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName) || JavaClassValidateUtil.isArray(subTypeName)) {
                    String gName;
                    String[] gNameArr;
                    if (isShowJavaType) {
                        param2.setType(JavaFieldUtil.convertToSimpleTypeName(docField.getTypeGenericFullyQualifiedName()));
                    } else {
                        param2.setType("array");
                    }
                    if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                        param2.setValue(fieldValue);
                    }
                    if (globGicName.length > 0 && "java.util.List".equals(fieldGicName)) {
                        fieldGicName = fieldGicName + "<T>";
                    }
                    if (JavaClassValidateUtil.isArray(subTypeName)) {
                        fieldGicName = fieldGicName.substring(0, fieldGicName.lastIndexOf("["));
                        fieldGicName = "java.util.List<" + fieldGicName + ">";
                    }
                    if ((gNameArr = DocClassUtil.getSimpleGicName(fieldGicName)).length == 0) continue;
                    if (gNameArr.length > 0) {
                        gName = DocClassUtil.getSimpleGicName(fieldGicName)[0];
                        JavaClass javaClass1 = projectBuilder.getJavaProjectBuilder().getClassByName(gName);
                        comment.append(ParamsBuildHelper.handleEnumComment(javaClass1, projectBuilder));
                    }
                    if (JavaClassValidateUtil.isPrimitive(gName = gNameArr[0])) {
                        String builder = DocUtil.jsonValueByType(gName) + "," + DocUtil.jsonValueByType(gName);
                        if (StringUtil.isEmpty((String)fieldValue)) {
                            param2.setValue(DocUtil.handleJsonStr(builder));
                        } else {
                            param2.setValue(fieldValue);
                        }
                        ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                        continue;
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                    int n = fieldPid = Optional.ofNullable(atomicInteger).isPresent() ? param2.getId() : paramList.size() + pid;
                    if (!simpleName.equals(gName)) {
                        JavaClass arraySubClass = projectBuilder.getJavaProjectBuilder().getClassByName(gName);
                        if (arraySubClass.isEnum()) {
                            Object value = JavaClassUtil.getEnumValue(arraySubClass, Boolean.FALSE);
                            param2.setValue("[\"" + value + "\"]").setEnumInfo(JavaClassUtil.getEnumInfo(arraySubClass, projectBuilder)).setEnumValues(JavaClassUtil.getEnumValues(arraySubClass));
                            continue;
                        }
                        if (gName.length() == 1) {
                            String gicName;
                            int len = globGicName.length;
                            if (len < 1 || JavaClassValidateUtil.isPrimitive(gicName = genericMap.get(gName) != null ? (String)genericMap.get(gName) : globGicName[0]) || simpleName.equals(gicName)) continue;
                            paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                            continue;
                        }
                        paramList.addAll(ParamsBuildHelper.buildParams(gName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                        continue;
                    }
                    param2.setSelfReferenceLoop(true);
                    continue;
                }
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    String valType;
                    if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                        param2.setType("map");
                        param2.setValue(fieldValue);
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                    fieldPid = Optional.ofNullable(atomicInteger).isPresent() ? param2.getId() : paramList.size() + pid;
                    String string = valType = DocClassUtil.getMapKeyValueType(fieldGicName).length == 0 ? fieldGicName : DocClassUtil.getMapKeyValueType(fieldGicName)[1];
                    if (JavaClassValidateUtil.isMap(fieldGicName) || "java.lang.Object".equals(valType)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, fieldPid + 1)).setPid(fieldPid).setClassName(className).setMaxLength(maxLength).setType("object").setDesc("any object.").setVersion("-").setExtensions(extensionParams);
                        paramList.add(param1);
                        continue;
                    }
                    if (JavaClassValidateUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = (String)genericMap.get(valType);
                        if (JavaClassValidateUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(valType, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                    continue;
                }
                if ("java.lang.Object".equals(fieldGicName)) {
                    if (StringUtil.isEmpty((String)param2.getDesc())) {
                        param2.setDesc("any object.");
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                    continue;
                }
                if (fieldGicName.length() == 1) {
                    ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                    int n = fieldPid = Optional.ofNullable(atomicInteger).isPresent() ? param2.getId() : paramList.size() + pid;
                    if (simpleName.equals(className)) continue;
                    if (globGicName.length > 0) {
                        String gicName = genericMap.get(subTypeName) != null ? (String)genericMap.get(subTypeName) : globGicName[0];
                        String simple = DocClassUtil.getSimpleName(gicName);
                        if (JavaClassValidateUtil.isArray(gicName)) {
                            param2.setType("array");
                        }
                        if (JavaClassValidateUtil.isPrimitive(simple)) continue;
                        if (gicName.contains("<")) {
                            if (JavaClassValidateUtil.isCollection(simple)) {
                                param2.setType("array");
                                String gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                if (JavaClassValidateUtil.isPrimitive(gName)) continue;
                                paramList.addAll(ParamsBuildHelper.buildParams(gName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                                continue;
                            }
                            paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                            continue;
                        }
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(subTypeName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
                    continue;
                }
                if (simpleName.equals(subTypeName)) {
                    ApiParam param1 = ApiParam.of().setField(pre + fieldName).setPid(pid).setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, paramList.size() + pid + 1)).setClassName(subTypeName).setMaxLength(maxLength).setType("object").setDesc(comment.append(" $ref... self").toString()).setVersion("-").setExtensions(extensionParams);
                    paramList.add(param1);
                    continue;
                }
                ParamsBuildHelper.commonHandleParam(paramList, param2, isRequired, comment + appendComment, since, strRequired);
                fieldGicName = DocUtil.formatFieldTypeGicName(genericMap, fieldGicName);
                fieldPid = Optional.ofNullable(atomicInteger).isPresent() ? param2.getId() : paramList.size() + pid;
                paramList.addAll(ParamsBuildHelper.buildParams(fieldGicName, preBuilder.toString(), nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, fieldPid, jsonRequest, atomicInteger));
            }
        }
        return paramList;
    }

    private static List<ApiParam> buildMapParam(String[] globGicName, String pre, int level, String isRequired, boolean isResp, Map<String, String> registryClasses, ProjectDocConfigBuilder projectBuilder, Set<String> groupClasses, int pid, boolean jsonRequest, int nextLevel, AtomicInteger atomicInteger) {
        if (globGicName.length != 2) {
            return Collections.emptyList();
        }
        String mapKeySimpleName = DocClassUtil.getSimpleName(globGicName[0]);
        String valueSimpleName = DocClassUtil.getSimpleName(globGicName[1]);
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (JavaClassValidateUtil.isPrimitive(mapKeySimpleName)) {
            boolean isShowJavaType = projectBuilder.getApiConfig().getShowJavaType();
            String valueSimpleNameType = ParamsBuildHelper.processFieldTypeName(isShowJavaType, valueSimpleName);
            ApiParam apiParam = ApiParam.of().setField(pre + "mapKey").setType(valueSimpleNameType).setClassName(valueSimpleName).setDesc(Optional.ofNullable(projectBuilder.getClassByName(valueSimpleName)).map(JavaAnnotatedElement::getComment).orElse("A map key.")).setVersion("-").setPid(pid).setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, ++pid));
            paramList.add(apiParam);
        }
        if (JavaClassValidateUtil.isPrimitive(valueSimpleName)) {
            return paramList;
        }
        StringBuilder preBuilder = new StringBuilder();
        for (int j = 0; j < level; ++j) {
            preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        preBuilder.append("\u2514\u2500");
        paramList.addAll(ParamsBuildHelper.buildParams(globGicName[1], preBuilder.toString(), ++nextLevel, isRequired, isResp, registryClasses, projectBuilder, groupClasses, pid, jsonRequest, atomicInteger));
        return paramList;
    }

    public static String dictionaryListComment(List<EnumDictionary> enumDataDict) {
        return enumDataDict.stream().map(apiDataDictionary -> apiDataDictionary.getName() + "-(\"" + apiDataDictionary.getValue() + "\",\"" + apiDataDictionary.getDesc() + "\")").collect(Collectors.joining(","));
    }

    public static List<ApiParam> primitiveReturnRespComment(String typeName, AtomicInteger atomicInteger, int pid) {
        String comments = "Return " + typeName + ".";
        ApiParam apiParam = ApiParam.of().setClassName(typeName).setId(ParamsBuildHelper.atomicOrDefault(atomicInteger, pid + 1)).setField("-").setPid(pid).setType(typeName).setDesc(comments).setVersion("-");
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        paramList.add(apiParam);
        return paramList;
    }

    private static void commonHandleParam(List<ApiParam> paramList, ApiParam param, String isRequired, String comment, String since, boolean strRequired) {
        if (StringUtil.isEmpty((String)isRequired)) {
            param.setDesc(comment).setVersion(since);
        } else {
            param.setDesc(comment).setVersion(since).setRequired(strRequired);
        }
        paramList.add(param);
    }

    private static String handleEnumComment(JavaClass javaClass, ProjectDocConfigBuilder projectBuilder) {
        String comment = "";
        if (!javaClass.isEnum()) {
            return comment;
        }
        String enumComments = javaClass.getComment();
        if (Boolean.TRUE.equals(projectBuilder.getApiConfig().getInlineEnum())) {
            ApiDataDictionary dataDictionary = projectBuilder.getApiConfig().getDataDictionary(javaClass.getCanonicalName());
            if (Objects.isNull(dataDictionary)) {
                comment = comment + "<br/>[Enum: " + JavaClassUtil.getEnumParams(javaClass) + "]";
            } else {
                Class<?> enumClass = dataDictionary.getEnumClass();
                if (enumClass.isInterface()) {
                    ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
                    try {
                        enumClass = classLoader.loadClass(javaClass.getFullyQualifiedName());
                    }
                    catch (ClassNotFoundException e) {
                        return comment;
                    }
                }
                comment = comment + "<br/>[Enum: " + ParamsBuildHelper.dictionaryListComment(dataDictionary.getEnumDataDict(enumClass)) + "]";
            }
        } else {
            if (StringUtil.isNotEmpty((String)enumComments)) {
                comment = comment + "<br/>(See: " + enumComments + ")";
            }
            comment = StringUtil.removeQuotes((String)comment);
        }
        return comment;
    }

    private static int atomicOrDefault(AtomicInteger atomicInteger, int defaultVal) {
        if (null != atomicInteger) {
            return atomicInteger.incrementAndGet();
        }
        return defaultVal;
    }

    private static String processFieldTypeName(boolean isShowJavaType, String fieldTypeName) {
        if (isShowJavaType) {
            return JavaFieldUtil.convertToSimpleTypeName(fieldTypeName);
        }
        return DocClassUtil.processTypeNameForParams(fieldTypeName.toLowerCase());
    }
}

