/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.model;

import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.TagDoc;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DocMapping {
    public static Map<String, TagDoc> TAG_DOC = new ConcurrentHashMap<String, TagDoc>(64);

    public static void tagDocPut(String tag, ApiDoc apiDoc, ApiMethodDoc methodDoc) {
        if (StringUtils.isBlank((CharSequence)tag)) {
            return;
        }
        TagDoc tagDoc = TAG_DOC.computeIfAbsent(tag, TagDoc::new);
        if (Objects.nonNull(apiDoc)) {
            apiDoc.getTagRefs().add(tagDoc);
            tagDoc.getClazzDocs().add(apiDoc);
        }
        if (Objects.nonNull(methodDoc)) {
            methodDoc.getTagRefs().add(tagDoc);
            tagDoc.getMethodDocs().add(methodDoc);
        }
    }

    public static void init() {
        TAG_DOC = new ConcurrentHashMap<String, TagDoc>(64);
    }
}

