/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.model.dependency;

import com.ly.doc.model.dependency.ApiDependency;
import com.ly.doc.utils.JsonUtil;
import com.power.common.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DependencyTree {
    private static final String CONFIG_NAME = ".smart-doc-dependency.json";
    private transient boolean increment;
    private transient File configFile;
    private String schema = "v1";
    private String commitId;
    private List<ApiDependency> dependencyTree;

    private DependencyTree() {
    }

    public static DependencyTree detect(String baseDir, boolean isIncrement) {
        if (!isIncrement) {
            DependencyTree dependencyTree = new DependencyTree();
            dependencyTree.setIncrement(false);
            return dependencyTree;
        }
        File configFile = new File(baseDir + File.separator + CONFIG_NAME);
        boolean fileNoExists = !configFile.exists();
        DependencyTree dependencyTree = fileNoExists ? Support.create(configFile) : Support.load(configFile);
        return dependencyTree;
    }

    public static void write(DependencyTree dependencyTree) {
        if (dependencyTree.isIncrement()) {
            Support.writeFile(dependencyTree);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public List<ApiDependency> getDependencyTree() {
        return this.dependencyTree;
    }

    public void setConfig(String commitId, List<ApiDependency> dependencyTree) {
        this.commitId = commitId;
        this.dependencyTree = dependencyTree;
    }

    public boolean isIncrement() {
        return this.increment;
    }

    public void setIncrement(boolean increment) {
        this.increment = increment;
    }

    private static class Support {
        private Support() {
        }

        private static DependencyTree create(File configFile) {
            if (!configFile.exists()) {
                try {
                    Files.createFile(configFile.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            DependencyTree instance = new DependencyTree();
            instance.configFile = configFile;
            instance.setConfig("", Collections.emptyList());
            Support.writeFile(instance);
            return instance;
        }

        private static DependencyTree load(File configFile) {
            if (configFile == null || !configFile.exists()) {
                return null;
            }
            String content = Support.readFile(configFile);
            DependencyTree instance = JsonUtil.toObject(content, DependencyTree.class);
            instance.configFile = configFile;
            return instance;
        }

        private static void writeFile(DependencyTree instance) {
            List<ApiDependency> distinctDependency = instance.getDependencyTree().stream().distinct().collect(Collectors.toList());
            instance.setConfig(instance.getCommitId(), distinctDependency);
            String content = JsonUtil.toPrettyJson(instance);
            FileUtil.writeFileNotAppend((String)content, (String)instance.configFile.getAbsolutePath());
        }

        private static String readFile(File configFile) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(configFile));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                return builder.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

