/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.model.postman;

import com.ly.doc.model.postman.request.ParamBean;
import com.power.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlBean {
    private String raw;
    private String protocol;
    private List<String> path;
    private List<String> host;
    private String port;
    private List<ParamBean> query;
    private List<ParamBean> variable;

    public UrlBean() {
    }

    public UrlBean(String serverUrl) {
        String port;
        ArrayList<String> hosts;
        String protocol;
        if (StringUtil.isEmpty((String)serverUrl)) {
            return;
        }
        Pattern pattern = Pattern.compile("(https?://)?([^:^/]*)?(:[a-zA-Z-z0-9|^{{\\}}$]*)?(.*)?");
        Matcher matcher = pattern.matcher(serverUrl);
        if (matcher.find()) {
            protocol = matcher.group(1);
            if (StringUtil.isNotEmpty((String)protocol)) {
                protocol = protocol.substring(0, protocol.indexOf(":"));
            }
            String domain = matcher.group(2);
            hosts = new ArrayList<String>();
            hosts.add(domain);
            port = matcher.group(3);
            if (StringUtil.isNotEmpty((String)port)) {
                port = port.replace(":", "");
            }
        } else {
            throw new RuntimeException("ServerUrl must contain http or https protocol.");
        }
        String uri = matcher.group(4);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(uri);
        this.protocol = protocol;
        this.host = hosts;
        this.port = port;
        this.path = paths;
    }

    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public List<ParamBean> getQuery() {
        return this.query;
    }

    public void setQuery(List<ParamBean> query) {
        this.query = query;
    }

    public List<ParamBean> getVariable() {
        return this.variable;
    }

    public void setVariable(List<ParamBean> variable) {
        this.variable = variable;
    }

    public List<String> getHost() {
        return this.host;
    }

    public void setHost(List<String> host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

