/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.helper.ParamsBuildHelper;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReturn;
import com.ly.doc.model.DocJavaMethod;
import com.ly.doc.model.DocJavaParameter;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.utils.ApiParamTreeUtil;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.OpenApiSchemaUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface IBaseDocBuildTemplate {
    default public String paramCommentResolve(String comment) {
        if (StringUtil.isEmpty((String)comment)) {
            comment = "No comments found.";
        } else if (comment.contains("|")) {
            comment = comment.substring(0, comment.indexOf("|"));
        }
        return comment;
    }

    default public List<ApiParam> buildReturnApiParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder projectBuilder) {
        String typeName;
        String responseBodyAdvice;
        JavaMethod method = docJavaMethod.getJavaMethod();
        if (method.getReturns().isVoid() && Objects.isNull(projectBuilder.getApiConfig().getResponseBodyAdvice())) {
            return new ArrayList<ApiParam>(0);
        }
        DocletTag downloadTag = method.getTagByName("download");
        if (Objects.nonNull(downloadTag)) {
            return new ArrayList<ApiParam>(0);
        }
        String returnTypeGenericCanonicalName = method.getReturnType().getGenericCanonicalName();
        if (Objects.nonNull(projectBuilder.getApiConfig().getResponseBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreResponseBodyAdvice")) && !returnTypeGenericCanonicalName.startsWith(responseBodyAdvice = projectBuilder.getApiConfig().getResponseBodyAdvice().getClassName())) {
            returnTypeGenericCanonicalName = new StringBuffer().append(responseBodyAdvice).append("<").append(returnTypeGenericCanonicalName).append(">").toString();
        }
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        ApiReturn apiReturn = DocClassUtil.processReturnType(returnTypeGenericCanonicalName);
        String returnType = apiReturn.getGenericCanonicalName();
        if (Objects.nonNull(actualTypesMap)) {
            for (Map.Entry<String, JavaType> entry : actualTypesMap.entrySet()) {
                returnType = returnType.replace(entry.getKey(), entry.getValue().getCanonicalName());
            }
        }
        if (this.ignoreReturnObject(typeName = apiReturn.getSimpleName(), projectBuilder.getApiConfig().getIgnoreRequestParams())) {
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isPrimitive(typeName)) {
            docJavaMethod.setReturnSchema(OpenApiSchemaUtil.primaryTypeSchema(typeName));
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isCollection(typeName)) {
            if (returnType.contains("<")) {
                String gicName = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    docJavaMethod.setReturnSchema(OpenApiSchemaUtil.arrayTypeSchema(gicName));
                    return new ArrayList<ApiParam>(0);
                }
                return ParamsBuildHelper.buildParams(gicName, "", 0, null, Boolean.TRUE, new HashMap<String, String>(16), projectBuilder, null, 0, Boolean.FALSE, null);
            }
            return new ArrayList<ApiParam>(0);
        }
        if (JavaClassValidateUtil.isMap(typeName)) {
            String[] keyValue = DocClassUtil.getMapKeyValueType(returnType);
            if (keyValue.length == 0) {
                return new ArrayList<ApiParam>(0);
            }
            return ParamsBuildHelper.buildParams(returnType, "", 0, null, Boolean.TRUE, new HashMap<String, String>(16), projectBuilder, null, 0, Boolean.FALSE, null);
        }
        if (StringUtil.isNotEmpty((String)returnType)) {
            return ParamsBuildHelper.buildParams(returnType, "", 0, null, Boolean.TRUE, new HashMap<String, String>(16), projectBuilder, null, 0, Boolean.FALSE, null);
        }
        return new ArrayList<ApiParam>(0);
    }

    default public void convertParamsDataToTree(ApiMethodDoc apiMethodDoc) {
        apiMethodDoc.setPathParams(ApiParamTreeUtil.apiParamToTree(apiMethodDoc.getPathParams()));
        apiMethodDoc.setQueryParams(ApiParamTreeUtil.apiParamToTree(apiMethodDoc.getQueryParams()));
        apiMethodDoc.setRequestParams(ApiParamTreeUtil.apiParamToTree(apiMethodDoc.getRequestParams()));
    }

    default public List<DocJavaParameter> getJavaParameterList(ProjectDocConfigBuilder builder, DocJavaMethod docJavaMethod, FrameworkAnnotations frameworkAnnotations) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        Map<String, String> replacementMap = builder.getReplaceClassMap();
        Map<String, String> paramTagMap = docJavaMethod.getParamTagMap();
        List parameterList = javaMethod.getParameters();
        if (parameterList.isEmpty()) {
            return new ArrayList<DocJavaParameter>(0);
        }
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        ArrayList<DocJavaParameter> apiJavaParameterList = new ArrayList<DocJavaParameter>(parameterList.size());
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        for (JavaParameter parameter : parameterList) {
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName)) continue;
            DocJavaParameter apiJavaParameter = new DocJavaParameter();
            apiJavaParameter.setJavaParameter(parameter);
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            apiJavaParameter.setTypeValue(javaType.getValue());
            String genericCanonicalName = javaType.getGenericCanonicalName();
            String fullyQualifiedName = javaType.getFullyQualifiedName();
            apiJavaParameter.setFullyQualifiedName(fullyQualifiedName);
            String genericFullyQualifiedName = javaType.getGenericFullyQualifiedName();
            String commentClass = paramTagMap.get(paramName);
            if (Objects.nonNull(commentClass) && commentClass.contains("ignore")) continue;
            String rewriteClassName = this.getRewriteClassName(replacementMap, genericFullyQualifiedName, commentClass);
            if (JavaClassValidateUtil.isClassName(rewriteClassName)) {
                genericCanonicalName = rewriteClassName;
                genericFullyQualifiedName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(genericCanonicalName, builder.getApiConfig().getIgnoreRequestParams())) continue;
            genericFullyQualifiedName = DocClassUtil.rewriteRequestParam(genericFullyQualifiedName);
            genericCanonicalName = DocClassUtil.rewriteRequestParam(genericCanonicalName);
            List annotations = parameter.getAnnotations();
            apiJavaParameter.setAnnotations(annotations);
            for (JavaAnnotation annotation : annotations) {
                String requestBodyAdvice;
                String annotationName = annotation.getType().getValue();
                if (!Objects.nonNull(frameworkAnnotations) || !frameworkAnnotations.getRequestBodyAnnotation().getAnnotationName().equals(annotationName) || !Objects.nonNull(builder.getApiConfig().getRequestBodyAdvice()) || !Objects.isNull(javaMethod.getTagByName("ignoreRequestBodyAdvice"))) continue;
                genericFullyQualifiedName = requestBodyAdvice = builder.getApiConfig().getRequestBodyAdvice().getClassName();
                genericCanonicalName = requestBodyAdvice + "<" + genericCanonicalName + ">";
            }
            if ((JavaClassValidateUtil.isCollection(genericFullyQualifiedName) || JavaClassValidateUtil.isArray(genericFullyQualifiedName)) && JavaClassValidateUtil.isCollection(genericCanonicalName)) {
                genericCanonicalName = genericCanonicalName + "<T>";
            }
            apiJavaParameter.setGenericCanonicalName(genericCanonicalName);
            apiJavaParameter.setGenericFullyQualifiedName(genericFullyQualifiedName);
            apiJavaParameterList.add(apiJavaParameter);
        }
        return apiJavaParameterList;
    }

    default public String getRewriteClassName(Map<String, String> replacementMap, String fullTypeName, String commentClass) {
        if (Objects.nonNull(commentClass) && !"No comments found.".equals(commentClass)) {
            String[] comments = commentClass.split("\\|");
            if (comments.length < 1) {
                return replacementMap.get(fullTypeName);
            }
            String rewriteClassName = comments[comments.length - 1];
            if (JavaClassValidateUtil.isClassName(rewriteClassName)) {
                return rewriteClassName;
            }
        }
        return replacementMap.get(fullTypeName);
    }

    default public Set<String> ignoreParamsSets(JavaMethod method) {
        HashSet<String> ignoreSets = new HashSet<String>();
        DocletTag ignoreParam = method.getTagByName("ignoreParams");
        if (Objects.nonNull(ignoreParam)) {
            String[] igParams = ignoreParam.getValue().split(" ");
            Collections.addAll(ignoreSets, igParams);
        }
        return ignoreSets;
    }

    default public String getMethodReturnType(JavaMethod javaMethod, Map<String, JavaType> actualTypesMap) {
        String[] arrays;
        JavaType returnType = javaMethod.getReturnType();
        String simpleReturn = this.replaceTypeName(returnType.getCanonicalName(), actualTypesMap, Boolean.TRUE);
        String returnClass = this.replaceTypeName(returnType.getGenericCanonicalName(), actualTypesMap, Boolean.TRUE);
        returnClass = returnClass.replace(simpleReturn, JavaClassUtil.getClassSimpleName(simpleReturn));
        for (String str : arrays = DocClassUtil.getSimpleGicName(returnClass)) {
            String[] generics;
            if (str.contains("[")) {
                str = str.substring(0, str.indexOf("["));
            }
            for (String generic : generics = str.split("[<,]")) {
                if (generic.contains("extends")) {
                    String className = generic.substring(generic.lastIndexOf(" ") + 1);
                    returnClass = returnClass.replace(className, JavaClassUtil.getClassSimpleName(className));
                }
                if (generic.length() == 1 || generic.contains("extends")) continue;
                returnClass = returnClass.replaceAll(generic, JavaClassUtil.getClassSimpleName(generic));
            }
        }
        return returnClass;
    }

    default public String replaceTypeName(String type, Map<String, JavaType> actualTypesMap, boolean simple) {
        if (Objects.isNull(actualTypesMap)) {
            return type;
        }
        for (Map.Entry<String, JavaType> entry : actualTypesMap.entrySet()) {
            if (!type.contains(entry.getKey())) continue;
            if (simple) {
                return type.replace(entry.getKey(), entry.getValue().getGenericValue());
            }
            return type.replace(entry.getKey(), entry.getValue().getGenericFullyQualifiedName());
        }
        return type;
    }

    public boolean ignoreReturnObject(String var1, List<String> var2);
}

