/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.helper.DocBuildHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiGroup;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.dependency.FileDiff;
import com.ly.doc.utils.DocPathUtil;
import com.ly.doc.utils.DocUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public interface IDocBuildBaseTemplate {
    public boolean supportsFramework(String var1);

    default public void preRender(DocBuildHelper docBuildHelper) {
    }

    default public List<ApiDoc> handleApiGroup(List<ApiDoc> apiDocList, ApiConfig apiConfig) {
        if (CollectionUtil.isEmpty(apiDocList) || apiConfig == null) {
            return apiDocList;
        }
        List<ApiGroup> groups = apiConfig.getGroups();
        ArrayList<ApiDoc> finalApiDocs = new ArrayList<ApiDoc>();
        ApiDoc defaultGroup = ApiDoc.buildGroupApiDoc("default");
        AtomicInteger order = new AtomicInteger(1);
        finalApiDocs.add(defaultGroup);
        if (CollectionUtil.isEmpty(groups)) {
            defaultGroup.setOrder(order.getAndIncrement());
            defaultGroup.getChildrenApiDocs().addAll(apiDocList);
            return finalApiDocs;
        }
        HashMap hasInsert = new HashMap(16);
        for (ApiGroup group2 : groups) {
            ApiDoc groupApiDoc = ApiDoc.buildGroupApiDoc(group2.getName());
            finalApiDocs.add(groupApiDoc);
            for (ApiDoc doc : apiDocList) {
                if (hasInsert.containsKey(doc.getAlias()) || !DocUtil.isMatch(group2.getApis(), doc.getPackageName() + "." + doc.getName())) continue;
                hasInsert.put(doc.getAlias(), null);
                groupApiDoc.getChildrenApiDocs().add(doc);
                doc.setOrder(groupApiDoc.getChildrenApiDocs().size());
                doc.setGroup(group2.getName());
                if (StringUtil.isEmpty((String)group2.getPaths())) continue;
                List<ApiMethodDoc> methodDocs = doc.getList().stream().filter(l -> DocPathUtil.matches(l.getPath(), group2.getPaths(), null)).collect(Collectors.toList());
                doc.setList(methodDocs);
            }
        }
        for (ApiDoc doc : apiDocList) {
            String key = doc.getAlias();
            if (hasInsert.containsKey(key)) continue;
            defaultGroup.getChildrenApiDocs().add(doc);
            doc.setOrder(defaultGroup.getChildrenApiDocs().size());
            hasInsert.put(doc.getAlias(), null);
        }
        if (CollectionUtil.isEmpty(defaultGroup.getChildrenApiDocs())) {
            finalApiDocs.remove(defaultGroup);
        }
        finalApiDocs.forEach(group -> group.setOrder(order.getAndIncrement()));
        return finalApiDocs;
    }

    default public Collection<JavaClass> getCandidateClasses(ProjectDocConfigBuilder docBuilder, DocBuildHelper docBuildHelper) {
        ApiConfig apiConfig = docBuilder.getApiConfig();
        JavaProjectBuilder javaProjectBuilder = docBuilder.getJavaProjectBuilder();
        if (!apiConfig.isIncrement()) {
            return javaProjectBuilder.getClasses();
        }
        if (docBuildHelper.notGitRepo() || StringUtil.isEmpty((String)docBuildHelper.getDependencyTree().getCommitId())) {
            return javaProjectBuilder.getClasses();
        }
        Set<FileDiff> fileDiffList = docBuildHelper.getChangedFilesFromVCS(s -> this.isEntryPoint(javaProjectBuilder, (String)s));
        if (CollectionUtil.isEmpty(fileDiffList)) {
            return Collections.emptyList();
        }
        ArrayList<JavaClass> result = new ArrayList<JavaClass>(fileDiffList.size());
        fileDiffList.forEach(item -> {
            try {
                JavaClass javaClass = javaProjectBuilder.getClassByName(item.getNewQualifiedName());
                result.add(javaClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return result;
    }

    public FrameworkAnnotations registeredAnnotations();

    default public boolean isEntryPoint(JavaProjectBuilder javaProjectBuilder, String javaClassName) {
        if (StringUtil.isEmpty((String)javaClassName)) {
            return false;
        }
        JavaClass javaClass = null;
        try {
            javaClass = javaProjectBuilder.getClassByName(javaClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (javaClass == null) {
            return false;
        }
        return this.isEntryPoint(javaClass, this.registeredAnnotations());
    }

    default public boolean skipClass(ApiConfig apiConfig, JavaClass javaClass, FrameworkAnnotations frameworkAnnotations) {
        if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), javaClass)) {
            return true;
        }
        if (StringUtil.isNotEmpty((String)apiConfig.getPackageExcludeFilters()) && DocUtil.isMatch(apiConfig.getPackageExcludeFilters(), javaClass)) {
            return true;
        }
        DocletTag ignoreTag = javaClass.getTagByName("ignore");
        return !this.isEntryPoint(javaClass, frameworkAnnotations) || Objects.nonNull(ignoreTag);
    }

    public boolean isEntryPoint(JavaClass var1, FrameworkAnnotations var2);
}

