/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.helper.ParamsBuildHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.DocJavaMethod;
import com.ly.doc.model.JavadocJavaMethod;
import com.ly.doc.template.IBaseDocBuildTemplate;
import com.ly.doc.utils.ApiParamTreeUtil;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.JavaFieldUtil;
import com.power.common.util.StringUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public interface IJavadocDocTemplate
extends IBaseDocBuildTemplate {
    public boolean addMethodModifiers();

    default public JavadocJavaMethod convertToJavadocJavaMethod(ApiConfig apiConfig, JavaMethod method, Map<String, JavaType> actualTypesMap) {
        JavaClass cls = method.getDeclaringClass();
        JavadocJavaMethod javadocJavaMethod = new JavadocJavaMethod();
        javadocJavaMethod.setJavaMethod(method);
        javadocJavaMethod.setName(method.getName());
        javadocJavaMethod.setActualTypesMap(actualTypesMap);
        String methodDefine = this.methodDefinition(method, actualTypesMap);
        String scapeMethod = methodDefine.replaceAll("<", "&lt;");
        scapeMethod = scapeMethod.replaceAll(">", "&gt;");
        javadocJavaMethod.setMethodDefinition(methodDefine);
        javadocJavaMethod.setEscapeMethodDefinition(scapeMethod);
        javadocJavaMethod.setDesc(DocUtil.getEscapeAndCleanComment(method.getComment()));
        String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
        if (StringUtil.isEmpty((String)apiNoteValue)) {
            apiNoteValue = method.getComment();
        }
        String version = DocUtil.getNormalTagComments(method, "since", cls.getName());
        javadocJavaMethod.setVersion(version);
        javadocJavaMethod.setDetail(apiNoteValue != null ? apiNoteValue : "");
        String authorValue = DocUtil.getNormalTagComments(method, "author", cls.getName());
        if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
            javadocJavaMethod.setAuthor(authorValue);
        }
        List annotations = method.getAnnotations();
        for (JavaAnnotation annotation : annotations) {
            String annotationName = annotation.getType().getName();
            if (!"Deprecated".equals(annotationName)) continue;
            javadocJavaMethod.setDeprecated(true);
        }
        if (Objects.nonNull(method.getTagByName("deprecated"))) {
            javadocJavaMethod.setDeprecated(true);
        }
        return javadocJavaMethod;
    }

    default public String methodDefinition(JavaMethod method, Map<String, JavaType> actualTypesMap) {
        StringBuilder methodBuilder = new StringBuilder();
        if (this.addMethodModifiers()) {
            method.getModifiers().forEach(item -> methodBuilder.append((String)item).append(" "));
        }
        String returnType = this.getMethodReturnType(method, actualTypesMap);
        methodBuilder.append(returnType).append(" ");
        ArrayList<String> params = new ArrayList<String>();
        List parameters = method.getParameters();
        for (JavaParameter parameter : parameters) {
            String typeName = this.replaceTypeName(parameter.getType().getGenericValue(), actualTypesMap, Boolean.TRUE);
            params.add(typeName + " " + parameter.getName());
        }
        methodBuilder.append(method.getName()).append("(").append(String.join((CharSequence)", ", params)).append(")");
        return methodBuilder.toString();
    }

    default public List<? extends JavadocJavaMethod> getParentsClassMethods(ApiConfig apiConfig, JavaClass cls) {
        ArrayList<? extends JavadocJavaMethod> docJavaMethods = new ArrayList<JavadocJavaMethod>();
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            for (JavaMethod method : parentMethodList) {
                docJavaMethods.add(this.convertToJavadocJavaMethod(apiConfig, method, actualTypesMap));
            }
            docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, parentClass));
        }
        return docJavaMethods;
    }

    default public List<? extends JavadocJavaMethod> getInterfaceMethods(ApiConfig apiConfig, JavaClass cls) {
        ArrayList<? extends JavadocJavaMethod> docJavaMethods = new ArrayList<JavadocJavaMethod>();
        for (JavaClass javaInterface : cls.getInterfaces()) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(javaInterface);
            List interfaceMethodList = javaInterface.getMethods();
            for (JavaMethod method : interfaceMethodList) {
                docJavaMethods.add(this.convertToJavadocJavaMethod(apiConfig, method, actualTypesMap));
            }
            docJavaMethods.addAll(this.getInterfaceMethods(apiConfig, javaInterface));
        }
        return docJavaMethods;
    }

    default public List<ApiParam> requestParams(JavaMethod javaMethod, ProjectDocConfigBuilder builder, AtomicInteger atomicInteger, Map<String, JavaType> actualTypesMap) {
        boolean isStrict = builder.getApiConfig().isStrict();
        boolean isShowJavaType = builder.getApiConfig().getShowJavaType();
        boolean isShowValidation = builder.getApiConfig().isShowValidation();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = DocUtil.getCommentsByTag(javaMethod, "param", className);
        List parameterList = javaMethod.getParameters();
        if (parameterList.isEmpty()) {
            return null;
        }
        ClassLoader classLoader = builder.getApiConfig().getClassLoader();
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        for (JavaParameter parameter : parameterList) {
            ApiParam param;
            String[] gicNameArr;
            boolean required = false;
            String paramName = parameter.getName();
            String typeName = this.replaceTypeName(parameter.getType().getGenericCanonicalName(), actualTypesMap, Boolean.FALSE);
            String simpleName = this.replaceTypeName(parameter.getType().getValue(), actualTypesMap, Boolean.FALSE).toLowerCase();
            String fullTypeName = this.replaceTypeName(parameter.getType().getFullyQualifiedName(), actualTypesMap, Boolean.FALSE);
            String paramPre = paramName + ".";
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            StringBuilder comment = new StringBuilder(this.paramCommentResolve(paramTagMap.get(paramName)));
            String mockValue = JavaFieldUtil.createMockValue(paramTagMap, paramName, typeName, typeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            for (JavaAnnotation a : annotations) {
                if (!JavaClassValidateUtil.isJSR303Required(a.getType().getValue())) continue;
                required = true;
            }
            comment.append(JavaFieldUtil.getJsrComment(isShowValidation, classLoader, annotations));
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                String gicName;
                if (JavaClassValidateUtil.isCollection(typeName)) {
                    typeName = typeName + "<T>";
                }
                if (JavaClassValidateUtil.isArray(gicName = (gicNameArr = DocClassUtil.getSimpleGicName(typeName))[0])) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String processedType = isShowJavaType ? JavaClassUtil.getClassSimpleName(typeName) : DocClassUtil.processTypeNameForParams(simpleName);
                    ApiParam param2 = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setDesc(comment + "   (children type : " + gicName + ")").setRequired(required).setType(processedType);
                    paramList.add(param2);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, atomicInteger));
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                param = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setType(JavaClassUtil.getClassSimpleName(typeName)).setDesc(comment.toString()).setRequired(required).setMaxLength(JavaFieldUtil.getParamMaxLength(parameter.getAnnotations())).setValue(mockValue).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setType(typeName).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, atomicInteger));
                continue;
            }
            if (javaClass.isEnum()) {
                param = ApiParam.of().setId(atomicInteger.incrementAndGet()).setField(paramName).setType("enum").setRequired(required).setDesc(comment.toString()).setVersion("-");
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, paramPre, 0, "true", Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, atomicInteger));
        }
        return paramList;
    }

    default public List<? extends JavadocJavaMethod> buildServiceMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        List methods = cls.getMethods();
        ArrayList<JavadocJavaMethod> methodDocList = new ArrayList<JavadocJavaMethod>(methods.size());
        Set<String> filterMethods = DocUtil.findFilterMethods(clazName);
        boolean needAllMethods = filterMethods.contains("*");
        for (JavaMethod method : methods) {
            if (method.isPrivate() || Objects.nonNull(method.getTagByName("ignore"))) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            if (!needAllMethods && !filterMethods.contains(method.getName())) continue;
            JavadocJavaMethod apiMethodDoc = this.convertToJavadocJavaMethod(apiConfig, method, null);
            methodDocList.add(apiMethodDoc);
        }
        methodDocList.addAll(this.getParentsClassMethods(apiConfig, cls));
        if (cls.isInterface() || cls.isAbstract()) {
            methodDocList.addAll(this.getInterfaceMethods(apiConfig, cls));
        }
        int methodOrder = 0;
        ArrayList<JavadocJavaMethod> javadocJavaMethods = new ArrayList<JavadocJavaMethod>(methodDocList.size());
        for (JavadocJavaMethod method : methodDocList) {
            method.setOrder(++methodOrder);
            String methodUid = DocUtil.generateId(clazName + method.getName() + methodOrder);
            method.setMethodId(methodUid);
            List<ApiParam> requestParams = this.requestParams(method.getJavaMethod(), projectBuilder, new AtomicInteger(0), method.getActualTypesMap());
            List<ApiParam> responseParams = this.buildReturnApiParams(DocJavaMethod.builder().setJavaMethod(method.getJavaMethod()).setActualTypesMap(method.getActualTypesMap()), projectBuilder);
            if (apiConfig.isParamsDataToTree()) {
                method.setRequestParams(ApiParamTreeUtil.apiParamToTree(requestParams));
                method.setResponseParams(ApiParamTreeUtil.apiParamToTree(responseParams));
            } else {
                method.setRequestParams(requestParams);
                method.setResponseParams(responseParams);
            }
            javadocJavaMethods.add(method);
        }
        return javadocJavaMethods;
    }
}

