/*
 * Decompiled with CFR 0.152.
 */
package com.ly.doc.template;

import com.ly.doc.builder.ProjectDocConfigBuilder;
import com.ly.doc.constants.ApiReqParamInTypeEnum;
import com.ly.doc.constants.MediaType;
import com.ly.doc.constants.Methods;
import com.ly.doc.handler.IHeaderHandler;
import com.ly.doc.handler.IRequestMappingHandler;
import com.ly.doc.helper.FormDataBuildHelper;
import com.ly.doc.helper.JsonBuildHelper;
import com.ly.doc.helper.ParamsBuildHelper;
import com.ly.doc.model.ApiConfig;
import com.ly.doc.model.ApiDoc;
import com.ly.doc.model.ApiExceptionStatus;
import com.ly.doc.model.ApiMethodDoc;
import com.ly.doc.model.ApiMethodReqParam;
import com.ly.doc.model.ApiParam;
import com.ly.doc.model.ApiReqParam;
import com.ly.doc.model.ApiSchema;
import com.ly.doc.model.DocJavaMethod;
import com.ly.doc.model.DocJavaParameter;
import com.ly.doc.model.DocMapping;
import com.ly.doc.model.ExceptionAdviceMethod;
import com.ly.doc.model.FormData;
import com.ly.doc.model.annotation.EntryAnnotation;
import com.ly.doc.model.annotation.ExceptionAdviceAnnotation;
import com.ly.doc.model.annotation.FrameworkAnnotations;
import com.ly.doc.model.annotation.MappingAnnotation;
import com.ly.doc.model.request.ApiRequestExample;
import com.ly.doc.model.request.CurlRequest;
import com.ly.doc.model.request.RequestMapping;
import com.ly.doc.template.IBaseDocBuildTemplate;
import com.ly.doc.utils.ApiParamTreeUtil;
import com.ly.doc.utils.CurlUtil;
import com.ly.doc.utils.DocClassUtil;
import com.ly.doc.utils.DocUtil;
import com.ly.doc.utils.HttpStatusUtil;
import com.ly.doc.utils.JavaClassUtil;
import com.ly.doc.utils.JavaClassValidateUtil;
import com.ly.doc.utils.JavaFieldUtil;
import com.ly.doc.utils.JsonUtil;
import com.ly.doc.utils.OpenApiSchemaUtil;
import com.ly.doc.utils.RequestExampleUtil;
import com.ly.doc.utils.TornaUtil;
import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public interface IRestDocTemplate
extends IBaseDocBuildTemplate {
    public static final Logger log = Logger.getLogger(IRestDocTemplate.class.getName());
    public static final AtomicInteger ATOMIC_INTEGER = new AtomicInteger(1);

    default public ApiSchema<ApiDoc> processApiData(ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations, List<ApiReqParam> configApiReqParams, IRequestMappingHandler baseMappingHandler, IHeaderHandler headerHandler, Collection<JavaClass> javaClasses) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        List<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        boolean setCustomOrder = false;
        int maxOrder = 0;
        ApiSchema<ApiDoc> apiSchema = new ApiSchema<ApiDoc>();
        for (JavaClass cls : javaClasses) {
            List<ApiMethodDoc> apiMethodDocs;
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls) || StringUtil.isNotEmpty((String)apiConfig.getPackageExcludeFilters()) && DocUtil.isMatch(apiConfig.getPackageExcludeFilters(), cls)) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.isEntryPoint(cls, frameworkAnnotations) || Objects.nonNull(ignoreTag)) continue;
            int order = 0;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
                maxOrder = Math.max(maxOrder, order);
            }
            if (CollectionUtil.isEmpty(apiMethodDocs = this.buildEntryPointMethod(cls, apiConfig, projectBuilder, frameworkAnnotations, configApiReqParams, baseMappingHandler, headerHandler))) continue;
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        apiDocList = this.handleTagsApiDoc(apiDocList);
        apiSchema.setApiExceptionStatuses(this.buildExceptionStatus(projectBuilder, javaClasses, frameworkAnnotations));
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
            apiSchema.setApiDatas(apiDocList);
            return apiSchema;
        }
        if (setCustomOrder) {
            ATOMIC_INTEGER.getAndAdd(maxOrder);
            ArrayList<ApiDoc> tempList = new ArrayList<ApiDoc>(apiDocList);
            tempList.forEach(p -> {
                if (p.getOrder() == 0) {
                    p.setOrder(ATOMIC_INTEGER.getAndAdd(1));
                }
            });
            apiSchema.setApiDatas(tempList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).collect(Collectors.toList()));
        } else {
            apiDocList.stream().peek(p -> p.setOrder(ATOMIC_INTEGER.getAndAdd(1))).collect(Collectors.toList());
            apiSchema.setApiDatas(apiDocList);
        }
        return apiSchema;
    }

    default public String createDocRenderHeaders(List<ApiReqParam> headers, boolean isAdoc) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isEmpty(headers)) {
            headers = new ArrayList<ApiReqParam>(0);
        }
        for (ApiReqParam header : headers) {
            builder.append("|").append(header.getName()).append("|").append(header.getType()).append("|").append(header.isRequired()).append("|").append(header.getDesc()).append("|").append(header.getSince()).append("|\n");
        }
        return builder.toString();
    }

    default public void handleApiDoc(JavaClass cls, List<ApiDoc> apiDocList, List<ApiMethodDoc> apiMethodDocs, int order, boolean isUseMD5) {
        String controllerName = cls.getName();
        ApiDoc apiDoc = new ApiDoc();
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        apiDoc.setOrder(order);
        apiDoc.setName(controllerName);
        apiDoc.setAuthor(classAuthor);
        apiDoc.setAlias(controllerName);
        apiDoc.setFolder(true);
        apiDoc.setPackageName(cls.getPackage().getName());
        List classTags = cls.getTagsByName("tag");
        Set tagSet = classTags.stream().map(DocletTag::getValue).map(StringUtils::trim).collect(Collectors.toCollection(LinkedHashSet::new));
        String[] tags = tagSet.toArray(new String[0]);
        apiDoc.setTags(tags);
        if (isUseMD5) {
            String name = DocUtil.generateId(apiDoc.getName());
            apiDoc.setAlias(name);
        }
        String desc = DocUtil.getEscapeAndCleanComment(cls.getComment());
        apiDoc.setDesc(desc);
        apiDoc.setList(apiMethodDocs);
        apiDocList.add(apiDoc);
        tagSet.add(StringUtils.trim((String)apiDoc.getName()));
        for (String tag : tagSet) {
            DocMapping.tagDocPut(tag, apiDoc, null);
            for (ApiMethodDoc methodDoc : apiMethodDocs) {
                DocMapping.tagDocPut(tag, null, methodDoc);
            }
        }
        for (ApiMethodDoc methodDoc : apiMethodDocs) {
            Object[] docTags = methodDoc.getTags();
            methodDoc.setClazzDoc(apiDoc);
            if (ArrayUtils.isEmpty((Object[])docTags)) continue;
            for (Object tag : docTags) {
                DocMapping.tagDocPut((String)tag, null, methodDoc);
            }
        }
    }

    default public void mappingParamToApiParam(String str, List<ApiParam> paramList, Map<String, String> mappingParams) {
        String paramValue;
        String paramName;
        String param = StringUtil.removeQuotes((String)str);
        String description = "Parameter condition.";
        if (param.contains("=")) {
            int index = param.indexOf("=");
            paramName = param.substring(0, index);
            paramValue = param.substring(index + 1);
            description = description + " [" + paramName + "=" + paramValue + "]";
        } else {
            paramName = param;
            paramValue = DocUtil.getValByTypeAndFieldName("string", paramName, Boolean.TRUE);
        }
        String type = ValidateUtil.isPositiveInteger((String)paramValue) ? "int32" : "string";
        ApiParam apiParam = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setQueryParam(true).setValue(paramValue).setType(type).setDesc(description).setRequired(true).setVersion("-");
        paramList.add(apiParam);
        mappingParams.put(paramName, null);
    }

    default public void mappingParamProcess(String str, Map<String, String> pathParamsMap) {
        String param = StringUtil.removeQuotes((String)str);
        if (param.contains("=")) {
            int index = param.indexOf("=");
            String paramName = param.substring(0, index);
            String paramValue = param.substring(index + 1);
            pathParamsMap.put(paramName, paramValue);
        } else {
            String paramName = param;
            pathParamsMap.put(paramName, DocUtil.getValByTypeAndFieldName("string", paramName, Boolean.TRUE));
        }
    }

    default public String getParamName(ClassLoader classLoader, String paramName, JavaAnnotation annotation) {
        String resolvedParamName = DocUtil.resolveAnnotationValue(classLoader, annotation.getProperty("value"));
        if (StringUtils.isBlank((CharSequence)resolvedParamName)) {
            resolvedParamName = DocUtil.resolveAnnotationValue(classLoader, annotation.getProperty("name"));
        }
        if (!StringUtils.isBlank((CharSequence)resolvedParamName)) {
            paramName = StringUtil.removeQuotes((String)resolvedParamName);
        }
        return StringUtil.removeQuotes((String)paramName);
    }

    default public List<ApiDoc> handleTagsApiDoc(List<ApiDoc> apiDocList) {
        if (CollectionUtil.isEmpty(apiDocList)) {
            return Collections.emptyList();
        }
        HashMap copyMap = new HashMap(16);
        apiDocList.forEach(doc -> {
            Object[] tags = doc.getTags();
            if (ArrayUtils.isEmpty((Object[])tags)) {
                tags = new String[]{doc.getPackageName() + "." + doc.getName()};
            }
            for (Object tag : tags) {
                tag = StringUtil.trim((String)tag);
                copyMap.computeIfPresent(tag, (k, v) -> {
                    List<Object> list = CollectionUtil.isEmpty(v.getList()) ? new ArrayList() : v.getList();
                    list.addAll(doc.getList());
                    v.setList(list);
                    return v;
                });
                copyMap.putIfAbsent(tag, doc);
            }
        });
        HashMap<String, ApiDoc> allMap = new HashMap<String, ApiDoc>(copyMap);
        allMap.forEach((k, v) -> {
            List<ApiMethodDoc> methodDocList = v.getList();
            methodDocList.forEach(method -> {
                Object[] tags = method.getTags();
                if (ArrayUtils.isEmpty((Object[])tags)) {
                    return;
                }
                for (Object tag : tags) {
                    tag = StringUtil.trim((String)tag);
                    copyMap.computeIfPresent(tag, (k1, v2) -> {
                        method.setOrder(v2.getList().size() + 1);
                        v2.getList().add((ApiMethodDoc)method);
                        return v2;
                    });
                    copyMap.putIfAbsent(tag, ApiDoc.buildTagApiDoc(v, (String)tag, method));
                }
            });
        });
        ArrayList<ApiDoc> apiDocs = new ArrayList<ApiDoc>(copyMap.values());
        int index = apiDocs.size() - 1;
        for (ApiDoc apiDoc : apiDocs) {
            if (apiDoc.getOrder() != null) continue;
            apiDoc.setOrder(index++);
        }
        apiDocs.sort(Comparator.comparing(ApiDoc::getOrder));
        return apiDocs;
    }

    default public List<JavaAnnotation> getClassAnnotations(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        List interfaceList;
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>(cls.getAnnotations());
        Map<Object, Object> entryAnnotationMap = Objects.isNull(frameworkAnnotations.getEntryAnnotations()) ? Collections.emptyMap() : frameworkAnnotations.getEntryAnnotations();
        Map<Object, Object> mappingAnnotationMap = Objects.isNull(frameworkAnnotations.getMappingAnnotations()) ? Collections.emptyMap() : frameworkAnnotations.getMappingAnnotations();
        boolean hasEntryAndMappingAnnotation = annotationsList.stream().anyMatch(item -> {
            String annotationName = item.getType().getValue();
            String fullyName = item.getType().getFullyQualifiedName();
            return !(!entryAnnotationMap.containsKey(annotationName) && !entryAnnotationMap.containsKey(fullyName) || !mappingAnnotationMap.containsKey(annotationName) && !mappingAnnotationMap.containsKey(fullyName));
        });
        if (hasEntryAndMappingAnnotation) {
            return annotationsList;
        }
        JavaClass superJavaClass = cls.getSuperJavaClass();
        if (Objects.nonNull(superJavaClass) && !"Object".equals(superJavaClass.getSimpleName())) {
            List<JavaAnnotation> superAnnotations = this.getClassAnnotations(superJavaClass, frameworkAnnotations);
            annotationsList.addAll(superAnnotations);
        }
        if (CollectionUtil.isNotEmpty((Collection)(interfaceList = cls.getInterfaces()))) {
            for (JavaClass javaInterface : interfaceList) {
                List<JavaAnnotation> interfaceAnnotations = this.getClassAnnotations(javaInterface, frameworkAnnotations);
                annotationsList.addAll(interfaceAnnotations);
            }
        }
        return annotationsList;
    }

    default public List<JavaAnnotation> getClassAnnotations(JavaClass cls, Map<String, MappingAnnotation> mappingAnnotationMap) {
        List interfaceList;
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>(cls.getAnnotations());
        boolean hasMappingAnnotation = annotationsList.stream().anyMatch(item -> {
            String annotationName = item.getType().getValue();
            String fullyName = item.getType().getFullyQualifiedName();
            return mappingAnnotationMap.containsKey(annotationName) || mappingAnnotationMap.containsKey(fullyName);
        });
        if (hasMappingAnnotation) {
            return annotationsList;
        }
        JavaClass superJavaClass = cls.getSuperJavaClass();
        if (Objects.nonNull(superJavaClass) && !"Object".equals(superJavaClass.getSimpleName())) {
            annotationsList.addAll(this.getClassAnnotations(superJavaClass, mappingAnnotationMap).stream().filter(annotation -> mappingAnnotationMap.containsKey(annotation.getType().getValue()) || mappingAnnotationMap.containsKey(annotation.getType().getFullyQualifiedName())).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(interfaceList = cls.getInterfaces()))) {
            for (JavaClass javaInterface : interfaceList) {
                annotationsList.addAll(this.getClassAnnotations(javaInterface, mappingAnnotationMap).stream().filter(annotation -> mappingAnnotationMap.containsKey(annotation.getType().getValue()) || mappingAnnotationMap.containsKey(annotation.getType().getFullyQualifiedName())).collect(Collectors.toList()));
            }
        }
        return annotationsList;
    }

    default public List<ApiExceptionStatus> buildExceptionStatus(ProjectDocConfigBuilder projectBuilder, Collection<JavaClass> javaClasses, FrameworkAnnotations frameworkAnnotations) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        HashSet<String> statusSet = new HashSet<String>(8);
        ArrayList<ApiExceptionStatus> exceptionStatusList = new ArrayList<ApiExceptionStatus>(8);
        for (JavaClass cls : javaClasses) {
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.isExceptionAdviceEntryPoint(cls, frameworkAnnotations) || Objects.nonNull(ignoreTag)) continue;
            boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
            List methods = cls.getMethods();
            ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
            for (JavaMethod method : methods) {
                if (method.isPrivate() || Objects.nonNull(method.getTagByName("ignore"))) continue;
                docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, null));
            }
            docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, projectBuilder, cls));
            for (DocJavaMethod docJavaMethod : docJavaMethods) {
                String statusCode;
                JavaMethod method = docJavaMethod.getJavaMethod();
                ExceptionAdviceMethod adviceMethod = this.processExceptionAdviceMethod(method);
                if (Objects.isNull(adviceMethod) || !adviceMethod.isExceptionHandlerMethod() || Objects.isNull(adviceMethod.getStatus()) || statusSet.contains(statusCode = HttpStatusUtil.getStatusCode(adviceMethod.getStatus()))) continue;
                statusSet.add(statusCode);
                ApiExceptionStatus apiExceptionStatus = new ApiExceptionStatus();
                apiExceptionStatus.setStatus(statusCode);
                apiExceptionStatus.setDesc(HttpStatusUtil.getStatusDescription(statusCode));
                apiExceptionStatus.setAuthor(docJavaMethod.getAuthor());
                apiExceptionStatus.setDetail(docJavaMethod.getDetail());
                List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
                if (paramsDataToTree) {
                    responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
                }
                apiExceptionStatus.setExceptionResponseParams(responseParams);
                String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
                if (StringUtil.isNotEmpty((String)responseValue)) {
                    responseValue = responseValue.replaceAll("<br>", "");
                    apiExceptionStatus.setResponseUsage(JsonUtil.toPrettyFormat(responseValue));
                } else {
                    apiExceptionStatus.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
                }
                exceptionStatusList.add(apiExceptionStatus);
            }
        }
        if (apiConfig.isAddDefaultHttpStatuses() && exceptionStatusList.isEmpty()) {
            exceptionStatusList.addAll(this.defaultHttpErrorStatuses());
        }
        Collections.sort(exceptionStatusList);
        return exceptionStatusList;
    }

    default public List<ApiMethodDoc> buildEntryPointMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations, List<ApiReqParam> configApiReqParams, IRequestMappingHandler baseMappingHandler, IHeaderHandler headerHandler) {
        String clazName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        ClassLoader classLoader = projectBuilder.getApiConfig().getClassLoader();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        Map<String, MappingAnnotation> mappingAnnotations = Objects.isNull(frameworkAnnotations.getMappingAnnotations()) ? Collections.emptyMap() : frameworkAnnotations.getMappingAnnotations();
        List<JavaAnnotation> classAnnotations = this.getClassAnnotations(cls, mappingAnnotations);
        String baseUrl = "";
        String classMediaType = null;
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            Object consumes;
            String annotationName = annotation.getType().getValue();
            MappingAnnotation mappingAnnotation = mappingAnnotationMap.get(annotationName);
            if (Objects.isNull(mappingAnnotation)) continue;
            if (CollectionUtil.isNotEmpty(mappingAnnotation.getPathProps())) {
                baseUrl = StringUtil.removeQuotes((String)DocUtil.getPathUrl(classLoader, annotation, mappingAnnotation.getPathProps().toArray(new String[0])));
            }
            if (classMediaType != null || (consumes = annotation.getNamedParameter(mappingAnnotation.getConsumesProp())) == null) continue;
            classMediaType = consumes.toString();
        }
        Set<String> filterMethods = DocUtil.findFilterMethods(clazName);
        boolean needAllMethods = filterMethods.contains("*");
        List methods = cls.getMethods();
        List<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (Object method : methods) {
            if (method.isPrivate() || DocUtil.isMatch(apiConfig.getPackageExcludeFilters(), clazName + "." + method.getName()) || Objects.nonNull(method.getTagByName("ignore")) || !needAllMethods && !filterMethods.contains(method.getName())) continue;
            docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, (JavaMethod)method, null));
        }
        docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, projectBuilder, cls));
        List implClasses = cls.getImplements();
        for (JavaType type : implClasses) {
            JavaClass javaClass2 = (JavaClass)type;
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(javaClass2);
            for (JavaMethod method : javaClass2.getMethods()) {
                if (!method.isDefault()) continue;
                docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, actualTypesMap));
            }
        }
        if (apiConfig.getCustomJavaMethodHandler() != null) {
            docJavaMethods = apiConfig.getCustomJavaMethodHandler().apply(cls, docJavaMethods);
        }
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            JavaMethod method = docJavaMethod.getJavaMethod();
            RequestMapping requestMapping = baseMappingHandler.handle(projectBuilder, baseUrl, method, frameworkAnnotations, (javaClass, mapping) -> this.requestMappingPostProcess(javaClass, method, mapping));
            if (Objects.isNull(requestMapping) || Objects.isNull(requestMapping.getShortUrl())) continue;
            docJavaMethod.setMethodType(requestMapping.getMethodType());
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            String mediaType = requestMapping.getMediaType();
            if (Objects.nonNull(mediaType)) {
                apiMethodDoc.setContentType(MediaType.valueOf(mediaType));
            } else if (Objects.nonNull(classMediaType)) {
                apiMethodDoc.setContentType(MediaType.valueOf(classMediaType));
            }
            apiMethodDoc.setDownload(docJavaMethod.isDownload());
            apiMethodDoc.setPage(docJavaMethod.getPage());
            apiMethodDoc.setGroup(group);
            apiMethodDoc.setVersion(docJavaMethod.getVersion());
            if (Objects.nonNull(docJavaMethod.getGroup())) {
                apiMethodDoc.setGroup(docJavaMethod.getGroup());
            }
            List tags = method.getTagsByName("tag");
            apiMethodDoc.setTags((String[])tags.stream().map(DocletTag::getValue).toArray(String[]::new));
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setName(method.getName());
            String common = method.getComment();
            if (StringUtil.isEmpty((String)common)) {
                common = JavaClassUtil.getSameSignatureMethodCommonFromInterface(cls, method);
            }
            apiMethodDoc.setDesc(common);
            apiMethodDoc.setAuthor(docJavaMethod.getAuthor());
            apiMethodDoc.setDetail(docJavaMethod.getDetail());
            String methodUid = DocUtil.generateId(clazName + method.getName() + methodOrder);
            apiMethodDoc.setMethodId(methodUid);
            List<ApiReqParam> apiReqHeaders = headerHandler.handle(method, projectBuilder);
            apiReqHeaders = apiReqHeaders.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            apiMethodDoc.setType(requestMapping.getMethodType());
            apiMethodDoc.setUrl(requestMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(requestMapping.getShortUrl());
            apiMethodDoc.setDeprecated(requestMapping.isDeprecated());
            List<ApiReqParam> apiReqParamList = configApiReqParams.stream().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(docJavaMethod, projectBuilder, apiReqParamList, frameworkAnnotations);
            apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
            apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
            apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            if (paramsDataToTree) {
                this.convertParamsDataToTree(apiMethodDoc);
            }
            Map<String, List<ApiReqParam>> reqParamMap = configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn));
            List headerParamList = reqParamMap.getOrDefault(ApiReqParamInTypeEnum.HEADER.getValue(), Collections.emptyList());
            List<ApiReqParam> allApiReqHeaders = Stream.of(headerParamList, apiReqHeaders).filter(Objects::nonNull).flatMap(Collection::stream).distinct().filter(param -> DocUtil.filterPath(requestMapping, param)).collect(Collectors.toList());
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqHeaders, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            String path = apiMethodDoc.getPath().split(";")[0];
            String pathUrl = DocUtil.formatPathUrl(path);
            List<ApiParam> pathParams = apiMethodDoc.getPathParams();
            Iterator<ApiParam> pathIterator = pathParams.iterator();
            while (pathIterator.hasNext()) {
                ApiParam next = pathIterator.next();
                String pathKey = "{" + next.getField() + "}";
                if (pathUrl.contains(pathKey)) continue;
                pathIterator.remove();
            }
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, projectBuilder, frameworkAnnotations);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                responseValue = responseValue.replaceAll("<br>", "");
                apiMethodDoc.setResponseUsage(JsonUtil.toPrettyFormat(responseValue));
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            Map<String, String> extensions = DocUtil.getCommentsByTag(method, "extension", null);
            if (extensions != null) {
                HashMap<String, Object> extensionParams = apiMethodDoc.getExtensions() != null ? apiMethodDoc.getExtensions() : new HashMap<String, Object>();
                extensions.entrySet().stream().forEach(e -> extensionParams.put((String)e.getKey(), DocUtil.detectTagValue((String)e.getValue())));
                apiMethodDoc.setExtensions(extensionParams);
            }
            TornaUtil.setTornaArrayTags(docJavaMethod.getJavaMethod(), apiMethodDoc, apiConfig);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    default public ApiMethodReqParam requestParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder, List<ApiReqParam> configApiReqParams, FrameworkAnnotations frameworkAnnotations) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        boolean isStrict = builder.getApiConfig().isStrict();
        boolean isShowValidation = builder.getApiConfig().isShowValidation();
        ClassLoader classLoader = builder.getApiConfig().getClassLoader();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = docJavaMethod.getParamTagMap();
        Map<String, String> paramsComments = docJavaMethod.getParamsComments();
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        HashMap<String, String> mappingParams = new HashMap<String, String>(16);
        List methodAnnotations = javaMethod.getAnnotations();
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            MappingAnnotation mappingAnnotation = mappingAnnotationMap.get(annotationName);
            if (!Objects.nonNull(mappingAnnotation) || !StringUtil.isNotEmpty((String)mappingAnnotation.getParamsProp()) || Objects.isNull(paramsObjects = annotation.getNamedParameter(mappingAnnotation.getParamsProp()))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamToApiParam(paramsObjects.toString(), paramList, mappingParams);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamToApiParam(str, paramList, mappingParams);
            }
        }
        Map<String, Map<String, ApiReqParam>> collect = configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn, Collectors.toMap(ApiReqParam::getName, m -> m, (k1, k2) -> k1)));
        Map<String, ApiReqParam> pathReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.PATH.getValue(), Collections.emptyMap());
        Map<String, ApiReqParam> queryReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.QUERY.getValue(), Collections.emptyMap());
        List<DocJavaParameter> parameterList = this.getJavaParameterList(builder, docJavaMethod, frameworkAnnotations);
        if (parameterList.isEmpty()) {
            AtomicInteger querySize = new AtomicInteger(paramList.size() + 1);
            paramList.addAll(queryReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setQueryParam(true).setId(querySize.getAndIncrement())).collect(Collectors.toList()));
            AtomicInteger pathSize = new AtomicInteger(1);
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(pathReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setPathParam(true).setId(pathSize.getAndIncrement())).collect(Collectors.toList()))).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        int requestBodyCounter = 0;
        block2: for (DocJavaParameter apiParameter : parameterList) {
            Map<String, Object> map;
            String[] gicNameArr;
            boolean queryParam;
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            if (mappingParams.containsKey(paramName)) continue;
            String typeName = apiParameter.getGenericCanonicalName();
            String simpleTypeName = apiParameter.getTypeValue();
            String simpleName = simpleTypeName.toLowerCase();
            String fullyQualifiedName = apiParameter.getFullyQualifiedName();
            String genericFullyQualifiedName = apiParameter.getGenericFullyQualifiedName();
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullyQualifiedName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            StringBuilder comment = new StringBuilder(this.paramCommentResolve(paramTagMap.get(paramName)));
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(genericFullyQualifiedName);
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            String strRequired = "false";
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            boolean required = false;
            boolean isRequestParam = false;
            if (annotations.isEmpty() && (Methods.GET.getValue().equals(docJavaMethod.getMethodType()) || Methods.DELETE.getValue().equals(docJavaMethod.getMethodType()))) {
                isRequestParam = true;
            }
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if (this.ignoreMvcParamWithAnnotation(annotationName)) continue block2;
                if (frameworkAnnotations.getRequestParamAnnotation().getAnnotationName().equals(annotationName) || frameworkAnnotations.getPathVariableAnnotation().getAnnotationName().equals(annotationName)) {
                    AnnotationValue annotationDefaultVal;
                    String defaultValueProp = "defaultValue";
                    String requiredProp = "required";
                    if (frameworkAnnotations.getRequestParamAnnotation().getAnnotationName().equals(annotationName)) {
                        defaultValueProp = frameworkAnnotations.getRequestParamAnnotation().getDefaultValueProp();
                        requiredProp = frameworkAnnotations.getRequestParamAnnotation().getRequiredProp();
                        isRequestParam = true;
                    }
                    if (frameworkAnnotations.getPathVariableAnnotation().getAnnotationName().equals(annotationName)) {
                        defaultValueProp = frameworkAnnotations.getPathVariableAnnotation().getDefaultValueProp();
                        requiredProp = frameworkAnnotations.getPathVariableAnnotation().getRequiredProp();
                        isPathVariable = true;
                    }
                    if (Objects.nonNull(annotationDefaultVal = annotation.getProperty(defaultValueProp))) {
                        mockValue = DocUtil.resolveAnnotationValue(classLoader, annotationDefaultVal);
                    }
                    paramName = this.getParamName(classLoader, paramName, annotation);
                    AnnotationValue annotationRequired = annotation.getProperty(requiredProp);
                    strRequired = Objects.nonNull(annotationRequired) ? annotationRequired.toString() : "true";
                }
                if (JavaClassValidateUtil.isJSR303Required(annotationName)) {
                    strRequired = "true";
                }
                if (frameworkAnnotations.getRequestBodyAnnotation().getAnnotationName().equals(annotationName)) {
                    mockValue = JsonBuildHelper.buildJson(fullyQualifiedName, typeName, Boolean.FALSE, 0, new HashMap<String, String>(16), groupClasses, builder);
                    ++requestBodyCounter;
                    isRequestBody = true;
                }
                required = Boolean.parseBoolean(strRequired);
            }
            comment.append(JavaFieldUtil.getJsrComment(isShowValidation, classLoader, annotations));
            if (requestFieldToUnderline && !isPathVariable) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            if (JavaClassValidateUtil.isFile(typeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(false).setRequired(required).setVersion("-").setDesc(comment.toString());
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment.append("(array of file)");
                    param.setType("file");
                    param.setDesc(comment.toString());
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            boolean bl = queryParam = Methods.GET.getValue().equals(docJavaMethod.getMethodType()) && Methods.DELETE.getValue().equals(docJavaMethod.getMethodType()) && !isRequestBody && !isPathVariable;
            if (JavaClassValidateUtil.isCollection(fullyQualifiedName) || JavaClassValidateUtil.isArray(fullyQualifiedName)) {
                Map<String, Object> map2;
                ApiParam param;
                JavaClass gicJavaClass;
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                String gicName = gicNameArr[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (StringUtil.isNotEmpty((String)(mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicName, gicName))) && !mockValue.contains(",")) {
                    mockValue = StringUtils.join((Object[])new String[]{mockValue, ",", JavaFieldUtil.createMockValue(paramsComments, paramName, gicName, gicName)});
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setEnumValues(JavaClassUtil.getEnumValues(gicJavaClass)).setEnumInfo(JavaClassUtil.getEnumInfo(gicJavaClass, builder)).setType("array").setValue(String.valueOf(value));
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setVersion("-").setValue(mockValue);
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isFile(gicName)) {
                    ApiParam param2 = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(false).setRequired(required).setVersion("-").setHasItems(true).setDesc(comment + "(array of file)");
                    paramList.add(param2);
                    continue;
                }
                if (requestBodyCounter <= 0 && isRequestParam) continue;
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.TRUE, null));
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullyQualifiedName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment.toString()).setRequired(required).setVersion("-");
                paramList.add(param);
                if (requestBodyCounter <= 0) continue;
                map = OpenApiSchemaUtil.primaryTypeSchema(simpleName);
                docJavaMethod.setRequestSchema(map);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullyQualifiedName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    map = OpenApiSchemaUtil.mapTypeSchema("object");
                    docJavaMethod.setRequestSchema(map);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    Map<String, Object> map3 = OpenApiSchemaUtil.mapTypeSchema(gicNameArr[1]);
                    docJavaMethod.setRequestSchema(map3);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, null));
                continue;
            }
            if (javaClass.isEnum()) {
                String enumName = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, isPathVariable || queryParam);
                if (Boolean.TRUE.equals(builder.getApiConfig().getInlineEnum())) {
                    comment.append("<br/>[Enum: " + StringUtil.removeQuotes((String)enumName) + "]");
                }
                ApiParam param = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(StringUtil.removeDoubleQuotes((String)String.valueOf(value))).setType("enum").setDesc(comment.toString()).setRequired(required).setVersion("-").setEnumInfo(JavaClassUtil.getEnumInfo(javaClass, builder)).setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, String.valueOf(required), Boolean.FALSE, new HashMap<String, String>(16), builder, groupClasses, 0, Boolean.FALSE, null));
        }
        return ApiParamTreeUtil.buildMethodReqParam(paramList, queryReqParamMap, pathReqParamMap, docJavaMethod.getMethodType());
    }

    default public ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, ProjectDocConfigBuilder configBuilder, FrameworkAnnotations frameworkAnnotations) {
        String methodType = apiMethodDoc.getType();
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> queryParamsMap = new LinkedHashMap<String, String>();
        ClassLoader classLoader = configBuilder.getApiConfig().getClassLoader();
        apiMethodDoc.getPathParams().stream().filter(Objects::nonNull).filter(p -> StringUtil.isNotEmpty((String)p.getValue()) || p.isConfigParam()).forEach(param -> pathParamsMap.put(param.getSourceField(), param.getValue()));
        apiMethodDoc.getQueryParams().stream().filter(Objects::nonNull).filter(p -> StringUtil.isNotEmpty((String)p.getValue()) || p.isConfigParam()).forEach(param -> queryParamsMap.put(param.getSourceField(), param.getValue()));
        List methodAnnotations = method.getAnnotations();
        Map<String, MappingAnnotation> mappingAnnotationMap = frameworkAnnotations.getMappingAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            MappingAnnotation mappingAnnotation = mappingAnnotationMap.get(annotationName);
            if (!Objects.nonNull(mappingAnnotation) || !StringUtil.isNotEmpty((String)mappingAnnotation.getParamsProp()) || Objects.isNull(paramsObjects = annotation.getNamedParameter(mappingAnnotation.getParamsProp()))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamProcess(paramsObjects.toString(), queryParamsMap);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamProcess(str, queryParamsMap);
            }
        }
        List<DocJavaParameter> parameterList = this.getJavaParameterList(configBuilder, javaMethod, frameworkAnnotations);
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.isEmpty()) {
            String path = apiMethodDoc.getPath().split(";")[0];
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String url = UrlUtil.urlJoin((String)path, queryParamsMap);
            url = StringUtil.removeQuotes((String)url);
            url = apiMethodDoc.getServerUrl() + "/" + url;
            url = UrlUtil.simplifyUrl((String)url);
            CurlRequest curlRequest = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            String format = CurlUtil.toCurl(curlRequest);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> paramsComments = DocUtil.getCommentsByTag(method, "param", null);
        List<String> mvcRequestAnnotations = this.listMvcRequestAnnotations();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        block2: for (DocJavaParameter apiParameter : parameterList) {
            FormData formData;
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            String genericFullyQualifiedName = apiParameter.getGenericFullyQualifiedName();
            String fullyQualifiedName = apiParameter.getFullyQualifiedName();
            String gicTypeName = apiParameter.getGenericCanonicalName();
            String simpleTypeName = apiParameter.getTypeValue();
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(genericFullyQualifiedName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicTypeName, simpleTypeName);
            if (queryParamsMap.containsKey(paramName)) {
                mockValue = (String)queryParamsMap.get(paramName);
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, configBuilder.getJavaProjectBuilder());
            boolean paramAdded = false;
            boolean requestParam = false;
            if (annotations.isEmpty()) {
                requestParam = true;
            }
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                String fullName = annotation.getType().getSimpleName();
                if (!mvcRequestAnnotations.contains(fullName) || paramAdded) continue;
                if (this.ignoreMvcParamWithAnnotation(annotationName)) continue block2;
                AnnotationValue annotationDefaultVal = annotation.getProperty("defaultValue");
                if (Objects.nonNull(annotationDefaultVal)) {
                    mockValue = DocUtil.resolveAnnotationValue(classLoader, annotationDefaultVal);
                }
                paramName = this.getParamName(classLoader, paramName, annotation);
                if (frameworkAnnotations.getRequestBodyAnnotation().getAnnotationName().equals(annotationName)) {
                    if (apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded")) {
                        apiMethodDoc.setContentType("application/json");
                    }
                    boolean isArrayOrCollection = false;
                    if (JavaClassValidateUtil.isArray(fullyQualifiedName) || JavaClassValidateUtil.isCollection(fullyQualifiedName)) {
                        simpleTypeName = globGicName[0];
                        isArrayOrCollection = true;
                    }
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        if (isArrayOrCollection) {
                            mockValue = StringUtil.isNotEmpty((String)mockValue) ? "[" + mockValue + "]" : "[" + DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName) + "]";
                            mockValue = JsonUtil.toPrettyFormat(mockValue);
                        }
                        requestExample.setJsonBody(mockValue).setJson(true);
                    } else {
                        String json = JsonBuildHelper.buildJson(fullyQualifiedName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(16), groupClasses, configBuilder);
                        requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
                    }
                    queryParamsMap.remove(paramName);
                    paramAdded = true;
                    continue;
                }
                if (frameworkAnnotations.getPathVariableAnnotation().getAnnotationName().contains(annotationName)) {
                    if (javaClass.isEnum()) {
                        Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                        mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                    }
                    if (pathParamsMap.containsKey(paramName)) {
                        mockValue = (String)pathParamsMap.get(paramName);
                    }
                    pathParamsMap.put(paramName, mockValue);
                    paramAdded = true;
                    continue;
                }
                if (!frameworkAnnotations.getRequestParamAnnotation().getAnnotationName().contains(annotationName)) continue;
                if (javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                    mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                }
                if (queryParamsMap.containsKey(paramName)) {
                    mockValue = (String)queryParamsMap.get(paramName);
                }
                if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                    requestExample.addJsonBody(mockValue);
                }
                if (JavaClassValidateUtil.isFile(fullyQualifiedName)) break;
                queryParamsMap.put(paramName, mockValue);
                requestParam = true;
                paramAdded = true;
            }
            if (paramAdded) continue;
            if (JavaClassValidateUtil.isFile(gicTypeName)) {
                apiMethodDoc.setContentType("multipart/form-data");
                formData = new FormData();
                formData.setKey(paramName);
                formData.setType("file");
                if (fullyQualifiedName.contains("[]") || fullyQualifiedName.endsWith(">")) {
                    comment = comment + "(array of file)";
                    formData.setType("file");
                    formData.setHasItems(true);
                }
                formData.setDescription(comment);
                formData.setValue(mockValue);
                formData.setSrc(new ArrayList(0));
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullyQualifiedName) && !requestParam) {
                formData = new FormData();
                formData.setKey(paramName);
                formData.setDescription(comment);
                formData.setType("text");
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isArray(fullyQualifiedName) || JavaClassValidateUtil.isCollection(fullyQualifiedName)) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum() && requestParam) {
                    throw new RuntimeException("can't support binding Collection on method " + method.getName() + " Check it in " + method.getDeclaringClass().getCanonicalName());
                }
                JavaClass javaClass1 = configBuilder.getClassByName(gicName);
                String value = Objects.nonNull(javaClass1) && javaClass1.isEnum() ? String.valueOf(JavaClassUtil.getEnumValue(javaClass1, Boolean.TRUE)) : RandomUtil.randomValueByType((String)gicName);
                FormData formData2 = new FormData();
                formData2.setKey(paramName);
                if (!paramName.contains("[]")) {
                    formData2.setKey(paramName + "[]");
                }
                formData2.setDescription(comment);
                formData2.setType("text");
                formData2.setValue(value);
                formDataList.add(formData2);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                FormData formData3 = new FormData();
                formData3.setKey(paramName);
                formData3.setType("text");
                formData3.setDescription(comment);
                formData3.setValue(strVal);
                formDataList.add(formData3);
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(16), 0, configBuilder, "", groupClasses));
        }
        boolean hasFormDataUploadFile = formDataList.stream().anyMatch(form -> Objects.equals(form.getType(), "file"));
        if (hasFormDataUploadFile) {
            apiMethodDoc.setContentType("multipart/form-data");
        }
        requestExample.setFormDataList(formDataList);
        Map<String, String> formDataToMap = DocUtil.formDataToMap(formDataList);
        queryParamsMap.putAll(formDataToMap);
        RequestExampleUtil.setExampleBody(apiMethodDoc, requestExample, formDataList, pathParamsMap, queryParamsMap);
        return requestExample;
    }

    default public boolean defaultEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        if (Objects.isNull(frameworkAnnotations)) {
            return false;
        }
        Map<String, EntryAnnotation> entryAnnotationMap = frameworkAnnotations.getEntryAnnotations();
        if (Objects.isNull(frameworkAnnotations.getEntryAnnotations())) {
            return false;
        }
        List classAnnotations = cls.getAnnotations();
        return classAnnotations.stream().anyMatch(annotation -> {
            String name = annotation.getType().getValue();
            return entryAnnotationMap.containsKey(name);
        });
    }

    default public boolean defaultExceptionAdviceEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        if (Objects.isNull(frameworkAnnotations)) {
            return false;
        }
        List<JavaAnnotation> classAnnotations = DocClassUtil.getAnnotations(cls);
        if (Objects.isNull(frameworkAnnotations.getExceptionAdviceAnnotations())) {
            return false;
        }
        Map<String, ExceptionAdviceAnnotation> exceptionAdviceAnnotationMap = frameworkAnnotations.getExceptionAdviceAnnotations();
        return classAnnotations.stream().anyMatch(annotation -> {
            String name = annotation.getType().getValue();
            return exceptionAdviceAnnotationMap.containsKey(name);
        });
    }

    default public List<DocJavaMethod> getParentsClassMethods(ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, JavaClass cls) {
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>();
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            for (JavaMethod method : parentMethodList) {
                docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, actualTypesMap));
            }
            docJavaMethods.addAll(this.getParentsClassMethods(apiConfig, projectBuilder, parentClass));
        }
        return docJavaMethods;
    }

    default public DocJavaMethod convertToDocJavaMethod(ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, JavaMethod method, Map<String, JavaType> actualTypesMap) {
        DocletTag docletTag;
        JavaClass cls = method.getDeclaringClass();
        String clzName = cls.getCanonicalName();
        if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
            throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
        }
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        DocJavaMethod docJavaMethod = DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap);
        if (Objects.nonNull(method.getTagByName("download"))) {
            docJavaMethod.setDownload(true);
        }
        DocletTag pageTag = method.getTagByName("page");
        if (Objects.nonNull(method.getTagByName("page"))) {
            String pageUrl = projectBuilder.getServerUrl() + "/" + pageTag.getValue();
            docJavaMethod.setPage(UrlUtil.simplifyUrl((String)pageUrl));
        }
        if (Objects.nonNull(docletTag = method.getTagByName("group"))) {
            docJavaMethod.setGroup(docletTag.getValue());
        }
        docJavaMethod.setParamTagMap(DocUtil.getCommentsByTag(method, "param", clzName));
        docJavaMethod.setParamsComments(DocUtil.getCommentsByTag(method, "param", null));
        Map<String, String> authorMap = DocUtil.getCommentsByTag(method, "author", cls.getName());
        String authorValue = String.join((CharSequence)", ", new ArrayList<String>(authorMap.keySet()));
        if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
            docJavaMethod.setAuthor(JsonUtil.toPrettyFormat(authorValue));
        }
        if (apiConfig.isShowAuthor() && StringUtil.isEmpty((String)authorValue)) {
            docJavaMethod.setAuthor(classAuthor);
        }
        String comment = DocUtil.getEscapeAndCleanComment(method.getComment());
        docJavaMethod.setDesc(comment);
        String version = DocUtil.getNormalTagComments(method, "since", cls.getName());
        docJavaMethod.setVersion(version);
        String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
        if (StringUtil.isEmpty((String)apiNoteValue)) {
            apiNoteValue = method.getComment();
        }
        docJavaMethod.setDetail(apiNoteValue != null ? apiNoteValue : "");
        return docJavaMethod;
    }

    public boolean isEntryPoint(JavaClass var1, FrameworkAnnotations var2);

    public boolean isExceptionAdviceEntryPoint(JavaClass var1, FrameworkAnnotations var2);

    public List<String> listMvcRequestAnnotations();

    public void requestMappingPostProcess(JavaClass var1, JavaMethod var2, RequestMapping var3);

    public boolean ignoreMvcParamWithAnnotation(String var1);

    public ExceptionAdviceMethod processExceptionAdviceMethod(JavaMethod var1);

    public List<ApiExceptionStatus> defaultHttpErrorStatuses();
}

